/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.sortorders.registry;

import com.agfa.pacs.base.swing.lists.models.ComparatorAdapter;
import com.agfa.pacs.impaxee.AbstractRegistry;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.hanging.registry.HPRegistry;
import com.agfa.pacs.impaxee.sortorders.model.xml.CustomSortOrder;
import com.agfa.pacs.logging.ALogger;
import com.tiani.config.xml.minijaxb.MarshalException;
import com.tiani.config.xml.minijaxb.XmlLoader;
import java.util.ArrayList;
import java.util.Collections;

public class CustomSortOrderRegistry
extends AbstractRegistry<CustomSortOrder> {
    public static final ALogger log = ALogger.getLogger(HPRegistry.class);
    private static CustomSortOrderRegistry instance;

    private CustomSortOrderRegistry() {
        super(new ArrayList(), new ComparatorAdapter());
        this.loadFromConfig(Config.impaxee.jvision.SORTSPLIT.customSortOrders.getKey());
    }

    public static CustomSortOrderRegistry getInstance() {
        if (instance == null) {
            instance = new CustomSortOrderRegistry();
        }
        return instance;
    }

    public static void saveIfExists() {
        if (instance != null) {
            instance.save();
        }
    }

    public void save() {
        this.writeToConfig(Config.impaxee.jvision.SORTSPLIT.customSortOrders.getKey());
    }

    public CustomSortOrder getOrder(String string) {
        CustomSortOrder customSortOrder = new CustomSortOrder();
        customSortOrder.setName(string);
        int n = Collections.binarySearch(this.getAll(), customSortOrder);
        if (n >= 0) {
            return (CustomSortOrder)this.getElementAt(n);
        }
        return null;
    }

    public boolean containsOrder(String string) {
        CustomSortOrder customSortOrder = new CustomSortOrder();
        customSortOrder.setName(string);
        int n = Collections.binarySearch(this.getAll(), customSortOrder);
        return n >= 0;
    }

    @Override
    protected CustomSortOrder parseXML(String string) {
        XmlLoader xmlLoader = new XmlLoader();
        try {
            return (CustomSortOrder)xmlLoader.load(string, CustomSortOrder.class);
        }
        catch (MarshalException marshalException) {
            log.error("Cannot parse custom sort order XML: " + string, (Throwable)marshalException);
            return null;
        }
    }
}

