/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.sessions;

import com.agfa.pacs.impaxee.hanging.model.enums.MainLayoutType;
import com.agfa.pacs.impaxee.hanging.runtime.DisplayLayoutRuntime;
import com.agfa.pacs.impaxee.hanging.runtime.LayoutRuntime;
import com.agfa.pacs.impaxee.hanging.runtime.ScreenLayoutRuntime;
import com.agfa.pacs.impaxee.sessions.SessionDisplay;
import com.agfa.pacs.impaxee.sessions.SessionKeyObject;
import com.tiani.jvision.main.MainFrame2;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.jvision.vis.VisScreen2;
import com.tiani.jvision.vis.layout.IStateLytScreen;
import com.tiani.jvision.vis.layout.StateLytScreen;
import java.awt.Dimension;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class SessionLyt {
    private MainLayoutType lyt;
    private int lytCols;
    private int lytRows;
    private int nVisScreens;
    private int nVisDisplays;
    private List<IStateLytScreen> screenLayouts = new Vector<IStateLytScreen>();
    private List<Dimension> displayDim = new Vector<Dimension>();

    public SessionLyt() {
    }

    public SessionLyt(DataInputStream dataInputStream, SessionKeyObject sessionKeyObject, int n) throws IOException {
        this();
        this.read(dataInputStream, sessionKeyObject, n);
    }

    public SessionLyt(MainFrame2 mainFrame2) {
        this();
        this.capture(mainFrame2);
    }

    public LayoutRuntime convert(List<SessionDisplay> list) {
        LayoutRuntime layoutRuntime = new LayoutRuntime(null);
        int n = 0;
        layoutRuntime.setType(this.lyt);
        for (IStateLytScreen iStateLytScreen : this.screenLayouts) {
            ScreenLayoutRuntime screenLayoutRuntime = new ScreenLayoutRuntime(null);
            screenLayoutRuntime.setHorizontalXVertical(StateLytScreen.getType(iStateLytScreen));
            int n2 = StateLytScreen.getRequiredDisplayCount(iStateLytScreen);
            int n3 = 0;
            while (n3 < n2) {
                DisplayLayoutRuntime displayLayoutRuntime = new DisplayLayoutRuntime(null);
                Dimension dimension = this.displayDim.get(n + n3);
                displayLayoutRuntime.setHorizontalXVertical(String.valueOf(dimension.width) + "x" + dimension.height);
                displayLayoutRuntime.setPluginName(list.get(n + n3).getPluginName());
                screenLayoutRuntime.addDisplayLayout(displayLayoutRuntime);
                ++n3;
            }
            n += n2;
            layoutRuntime.addScreenLayoutRuntime(screenLayoutRuntime);
        }
        return layoutRuntime;
    }

    private void capture(MainFrame2 mainFrame2) {
        this.lyt = mainFrame2.getLytMode();
        this.lytCols = mainFrame2.getLyt().getCols();
        this.lytRows = mainFrame2.getLyt().getRows();
        List<VisScreen2> list = mainFrame2.getScreens();
        this.nVisScreens = list.size();
        this.screenLayouts.clear();
        for (VisScreen2 object2 : list) {
            this.screenLayouts.add(new StateLytScreen(object2.getLyt()));
        }
        List<VisDisplay2> list2 = mainFrame2.getDisplays();
        this.nVisDisplays = list2.size();
        this.displayDim.clear();
        for (Object visDisplay2 : list2) {
            this.displayDim.add(((VisDisplay2)visDisplay2).getLyt().getDim());
        }
    }

    String[] getSpecialScreenLayouts() {
        String[] stringArray = new String[this.nVisScreens];
        int n = 0;
        while (n < this.nVisScreens) {
            IStateLytScreen iStateLytScreen = this.screenLayouts.get(n);
            if (iStateLytScreen.getMergedCells() != null) {
                stringArray[n] = StateLytScreen.getType(iStateLytScreen);
            }
            ++n;
        }
        return stringArray;
    }

    public void write(DataOutputStream dataOutputStream) throws Throwable {
        SessionLyt sessionLyt = this;
        dataOutputStream.writeInt(sessionLyt.lyt.getIntID());
        dataOutputStream.writeInt(sessionLyt.lytCols);
        dataOutputStream.writeInt(sessionLyt.lytRows);
        dataOutputStream.writeInt(sessionLyt.nVisScreens);
        dataOutputStream.writeInt(sessionLyt.nVisDisplays);
        int n = 0;
        while (n < sessionLyt.nVisScreens) {
            int n2;
            int n3;
            IStateLytScreen iStateLytScreen = this.screenLayouts.get(n);
            if (iStateLytScreen.getMergedCells() == null) {
                n3 = iStateLytScreen.getCols();
                n2 = iStateLytScreen.getRows();
            } else {
                n3 = StateLytScreen.getRequiredDisplayCount(iStateLytScreen);
                n2 = 1;
                while (n3 % 2 == 0 && n2 < n3) {
                    n3 /= 2;
                    n2 *= 2;
                }
            }
            dataOutputStream.writeInt(n3);
            dataOutputStream.writeInt(n2);
            ++n;
        }
        n = 0;
        while (n < sessionLyt.nVisDisplays) {
            dataOutputStream.writeInt(sessionLyt.displayDim.get((int)n).width);
            dataOutputStream.writeInt(sessionLyt.displayDim.get((int)n).height);
            ++n;
        }
    }

    public void read(DataInputStream dataInputStream, SessionKeyObject sessionKeyObject, int n) throws IOException {
        int n2;
        int n3;
        SessionLyt sessionLyt = this;
        sessionLyt.lyt = MainLayoutType.getMainLayoutTypeForMode(dataInputStream.readInt());
        sessionLyt.lytCols = dataInputStream.readInt();
        sessionLyt.lytRows = dataInputStream.readInt();
        sessionLyt.nVisScreens = dataInputStream.readInt();
        sessionLyt.nVisDisplays = dataInputStream.readInt();
        sessionLyt.screenLayouts.clear();
        sessionLyt.displayDim.clear();
        int n4 = 0;
        while (n4 < sessionLyt.nVisScreens) {
            n3 = dataInputStream.readInt();
            n2 = dataInputStream.readInt();
            String string = sessionKeyObject.getSpecialScreenLayouts(n, n4);
            IStateLytScreen iStateLytScreen = null;
            if (string != null) {
                iStateLytScreen = StateLytScreen.parse(sessionLyt.lyt, string, null);
            }
            if (iStateLytScreen == null) {
                iStateLytScreen = new StateLytScreen(n3, n2);
            }
            sessionLyt.screenLayouts.add(iStateLytScreen);
            ++n4;
        }
        n4 = 0;
        while (n4 < sessionLyt.nVisDisplays) {
            n3 = dataInputStream.readInt();
            n2 = dataInputStream.readInt();
            sessionLyt.displayDim.add(new Dimension(n3, n2));
            ++n4;
        }
    }

    public boolean equals(SessionLyt sessionLyt) {
        if (this.lyt != sessionLyt.lyt) {
            return false;
        }
        if (this.lytCols != sessionLyt.lytCols) {
            return false;
        }
        if (this.lytRows != sessionLyt.lytRows) {
            return false;
        }
        if (this.nVisScreens != sessionLyt.nVisScreens) {
            return false;
        }
        if (this.nVisDisplays != sessionLyt.nVisDisplays) {
            return false;
        }
        if (!this.screenLayouts.equals(sessionLyt.screenLayouts)) {
            return false;
        }
        return this.displayDim.equals(sessionLyt.displayDim);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }
}

