/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.sessions;

import com.agfa.pacs.impaxee.User;
import com.agfa.pacs.impaxee.presentationstate.PresentationStatePoolCollector;
import com.agfa.pacs.impaxee.sessions.SessionDisplaySet;
import com.agfa.pacs.impaxee.sessions.SessionSnapshotRuntime;
import com.tiani.jvision.plugin.PluginName;
import com.tiani.jvision.vis.VisDisplay2;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Vector;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.io.DicomInputStream;
import org.dcm4che3.io.DicomOutputStream;

public class SessionDisplay {
    protected String pluginName = "Default";
    protected int navigPos = 0;
    protected boolean isSynced = false;
    protected List<Attributes> psts = new Vector<Attributes>();
    protected boolean[] visSelectStates = new boolean[0];
    protected boolean[] objMarkedStates = new boolean[0];
    private boolean hasMarked = false;
    protected int navigPosMarked = 0;
    protected List<Attributes> pstsMarked = new Vector<Attributes>();
    protected boolean[] visSelectStatesMarked = new boolean[0];
    private SessionDisplaySet sessionDisplaySet = null;
    private final SessionSnapshotRuntime parent;
    int[] seqObjIndexesMarked = new int[0];
    transient VisDisplay2 disp;
    private boolean isMissingPresentationStates;

    public SessionDisplay(SessionSnapshotRuntime sessionSnapshotRuntime) {
        this.parent = sessionSnapshotRuntime;
    }

    public SessionDisplay(DataInputStream dataInputStream, List<SessionDisplaySet> list, SessionSnapshotRuntime sessionSnapshotRuntime) throws IOException {
        this(sessionSnapshotRuntime);
        this.read(dataInputStream, list);
    }

    public SessionDisplay(VisDisplay2 visDisplay2, SessionDisplaySet sessionDisplaySet, SessionSnapshotRuntime sessionSnapshotRuntime) {
        this(sessionSnapshotRuntime);
        this.capture(visDisplay2, sessionDisplaySet);
    }

    public SessionSnapshotRuntime getParent() {
        return this.parent;
    }

    private void capture(VisDisplay2 visDisplay2, SessionDisplaySet sessionDisplaySet) {
        block6: {
            block5: {
                this.disp = visDisplay2;
                this.pluginName = sessionDisplaySet.getDisplaySet().isSetLiveSecondaryCapture() ? PluginName.DEFAULT.getPluginName() : this.disp.getData().getType().getName();
                this.navigPos = this.disp.getNavigPos();
                this.isSynced = this.disp.getData().isSynchronized();
                this.sessionDisplaySet = sessionDisplaySet;
                PresentationStatePoolCollector presentationStatePoolCollector = new PresentationStatePoolCollector(User.getUserNameAsPN(), "SESSION", this.getParent().getParent().getVisibleName(), false);
                this.disp.createPresentationStates(presentationStatePoolCollector);
                this.psts.clear();
                this.psts.addAll(presentationStatePoolCollector.getPresentationStateDicomObjects());
                boolean bl = this.isMissingPresentationStates = presentationStatePoolCollector.isMissingData() && PluginName.DEFAULT.getPluginName().equals(this.disp.getData().getType().getName());
                if (this.disp.getData().isDefaultPluginActive()) break block5;
                int n = this.disp.getVis().size();
                this.visSelectStates = new boolean[n];
                this.objMarkedStates = new boolean[n];
                int n2 = 0;
                while (n2 < n) {
                    this.visSelectStates[n2] = this.disp.getVis().get(n2).isSelected();
                    this.objMarkedStates[n2] = false;
                    ++n2;
                }
                break block6;
            }
            int n = this.disp.getVis().size();
            this.visSelectStates = new boolean[n];
            this.objMarkedStates = new boolean[n];
            int n3 = 0;
            while (n3 < n) {
                this.visSelectStates[n3] = this.disp.getVis().get(n3).isSelected();
                this.objMarkedStates[n3] = false;
                ++n3;
            }
            n3 = 0;
            int n4 = 0;
            while (n4 < this.objMarkedStates.length) {
                this.objMarkedStates[n4] = false;
                if (this.objMarkedStates[n4]) {
                    n3 = 1;
                }
                ++n4;
            }
            if (n3 != 0) break block6;
            n4 = 0;
            while (n4 < this.objMarkedStates.length) {
                this.objMarkedStates[n4] = true;
                ++n4;
            }
        }
    }

    public VisDisplay2 getVisDisplay() {
        return this.disp;
    }

    public void setVisDisplay(VisDisplay2 visDisplay2) {
        this.disp = visDisplay2;
    }

    public SessionDisplaySet getSessionDisplaySet() {
        return this.sessionDisplaySet;
    }

    public void setSessionDisplaySet(SessionDisplaySet sessionDisplaySet) {
        this.sessionDisplaySet = sessionDisplaySet;
    }

    public String getSeqUID() {
        if (this.sessionDisplaySet != null) {
            return this.sessionDisplaySet.getSessionSeqUID();
        }
        return "";
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public boolean[] getVisSelectStates() {
        return this.visSelectStates;
    }

    public int getNavigPos() {
        return this.navigPos;
    }

    public List<Attributes> getPresentationStates() {
        return this.psts;
    }

    public boolean isMissingPresentationStates() {
        return this.isMissingPresentationStates;
    }

    public void write(DataOutputStream dataOutputStream) throws Throwable {
        Object[] objectArray;
        dataOutputStream.writeUTF(this.getSeqUID());
        dataOutputStream.writeUTF(this.pluginName);
        dataOutputStream.writeInt(this.navigPos);
        dataOutputStream.writeBoolean(this.isSynced);
        dataOutputStream.writeInt(this.psts.size());
        for (Attributes attributes : this.psts) {
            this.writeDicomObject(dataOutputStream, attributes);
        }
        dataOutputStream.writeInt(this.visSelectStates.length);
        boolean[] blArray = this.visSelectStates;
        int n = this.visSelectStates.length;
        int n2 = 0;
        while (n2 < n) {
            boolean bl = blArray[n2];
            dataOutputStream.writeBoolean(bl);
            ++n2;
        }
        int n3 = 0;
        n2 = 0;
        while (n2 < this.objMarkedStates.length) {
            if (this.objMarkedStates[n2]) {
                ++n3;
            }
            ++n2;
        }
        if (n3 == 0 || n3 == this.objMarkedStates.length) {
            dataOutputStream.writeInt(0);
        } else {
            dataOutputStream.writeInt(this.objMarkedStates.length);
            objectArray = this.objMarkedStates;
            int n4 = this.objMarkedStates.length;
            n = 0;
            while (n < n4) {
                n2 = objectArray[n];
                dataOutputStream.writeBoolean(n2 != 0);
                ++n;
            }
        }
        dataOutputStream.writeInt(this.seqObjIndexesMarked.length);
        objectArray = this.seqObjIndexesMarked;
        int n5 = this.seqObjIndexesMarked.length;
        n = 0;
        while (n < n5) {
            n2 = objectArray[n];
            dataOutputStream.writeInt(n2);
            ++n;
        }
    }

    public void read(DataInputStream dataInputStream, List<SessionDisplaySet> list) throws IOException {
        int n;
        String string = dataInputStream.readUTF();
        this.pluginName = dataInputStream.readUTF();
        this.navigPos = dataInputStream.readInt();
        this.isSynced = dataInputStream.readBoolean();
        int n2 = dataInputStream.readInt();
        this.psts.clear();
        int n3 = 0;
        while (n3 < n2) {
            Attributes attributes = this.readDicomObject(dataInputStream);
            this.psts.add(attributes);
            ++n3;
        }
        n3 = dataInputStream.readInt();
        this.visSelectStates = new boolean[n3];
        int n4 = 0;
        while (n4 < this.visSelectStates.length) {
            this.visSelectStates[n4] = dataInputStream.readBoolean();
            ++n4;
        }
        n4 = dataInputStream.readInt();
        this.objMarkedStates = new boolean[n3];
        if (n4 == 0) {
            n = 0;
            while (n < this.objMarkedStates.length) {
                this.objMarkedStates[n] = true;
                ++n;
            }
        } else {
            n = 0;
            while (n < this.objMarkedStates.length) {
                this.objMarkedStates[n] = dataInputStream.readBoolean();
                ++n;
            }
        }
        this.restoreMarkedSettings();
        n = dataInputStream.readInt();
        this.seqObjIndexesMarked = new int[n];
        int n5 = 0;
        while (n5 < n) {
            this.seqObjIndexesMarked[n5] = dataInputStream.readInt();
            ++n5;
        }
        for (SessionDisplaySet sessionDisplaySet : list) {
            if (!sessionDisplaySet.getSessionSeqUID().equals(string)) continue;
            this.sessionDisplaySet = sessionDisplaySet;
        }
    }

    private void writeDicomObject(DataOutputStream dataOutputStream, Attributes attributes) throws Throwable {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DicomOutputStream dicomOutputStream = new DicomOutputStream((OutputStream)byteArrayOutputStream, "1.2.840.10008.1.2.1");
        dicomOutputStream.writeDataset(attributes.createFileMetaInformation("1.2.840.10008.1.2.1"), attributes);
        dicomOutputStream.close();
        byteArrayOutputStream.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        dataOutputStream.writeInt(byArray.length);
        dataOutputStream.write(byArray);
    }

    private Attributes readDicomObject(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        if (n == 0) {
            return null;
        }
        byte[] byArray = new byte[n];
        dataInputStream.read(byArray);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DicomInputStream dicomInputStream = new DicomInputStream((InputStream)byteArrayInputStream);
        Attributes attributes = dicomInputStream.readDataset(-1, -1);
        byteArrayInputStream.close();
        return attributes;
    }

    private void restoreMarkedSettings() {
        this.hasMarked = false;
        int n = 0;
        int n2 = 0;
        while (n2 < this.objMarkedStates.length) {
            if (this.objMarkedStates[n2]) {
                ++n;
            }
            ++n2;
        }
        if (n != this.objMarkedStates.length && n != 0) {
            this.hasMarked = true;
        }
        this.navigPosMarked = this.navigPos;
        this.pstsMarked.clear();
        this.visSelectStatesMarked = new boolean[n];
        if (this.hasMarked) {
            n2 = 0;
            while (n2 < this.navigPos) {
                if (!this.objMarkedStates[n2]) {
                    --this.navigPosMarked;
                }
                ++n2;
            }
            n2 = 0;
            int n3 = 0;
            while (n3 < this.objMarkedStates.length) {
                if (this.objMarkedStates[n3]) {
                    this.pstsMarked.add(this.psts.get(n3));
                    this.visSelectStatesMarked[n2] = this.visSelectStates[n3];
                    ++n2;
                }
                ++n3;
            }
        }
    }

    public boolean isSynced() {
        return this.isSynced;
    }

    public boolean equals(SessionDisplay sessionDisplay) {
        if (!this.getSeqUID().equals(sessionDisplay.getSeqUID())) {
            return false;
        }
        if (!this.pluginName.equals(sessionDisplay.pluginName)) {
            return false;
        }
        if (this.navigPos != sessionDisplay.navigPos) {
            return false;
        }
        if (this.isSynced != sessionDisplay.isSynced) {
            return false;
        }
        if (this.psts.size() != sessionDisplay.psts.size()) {
            return false;
        }
        if (this.visSelectStates.length != sessionDisplay.visSelectStates.length) {
            return false;
        }
        if (this.objMarkedStates.length != sessionDisplay.objMarkedStates.length) {
            return false;
        }
        int n = 0;
        while (n < this.visSelectStates.length) {
            if (this.visSelectStates[n] != sessionDisplay.visSelectStates[n]) {
                return false;
            }
            ++n;
        }
        n = 0;
        while (n < this.objMarkedStates.length) {
            if (this.objMarkedStates[n] != sessionDisplay.objMarkedStates[n]) {
                return false;
            }
            ++n;
        }
        return sessionDisplay.disp == null || sessionDisplay.disp.getData() == null || sessionDisplay.disp.getData().isSavedForSession();
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[]{"psts", "pstsMarked"});
    }

    public SessionDisplay cloneForSave() {
        SessionDisplay sessionDisplay = new SessionDisplay(this.getParent());
        sessionDisplay.sessionDisplaySet = this.sessionDisplaySet.cloneForSave();
        sessionDisplay.pluginName = this.pluginName;
        sessionDisplay.navigPos = this.navigPos;
        sessionDisplay.isSynced = this.isSynced;
        sessionDisplay.hasMarked = this.hasMarked;
        sessionDisplay.navigPosMarked = this.navigPosMarked;
        sessionDisplay.disp = this.disp;
        int n = 0;
        while (n < this.psts.size()) {
            sessionDisplay.psts.add(this.psts.get(n));
            ++n;
        }
        n = 0;
        while (n < this.pstsMarked.size()) {
            sessionDisplay.pstsMarked.add(this.pstsMarked.get(n));
            ++n;
        }
        sessionDisplay.objMarkedStates = new boolean[this.objMarkedStates.length];
        n = 0;
        while (n < this.objMarkedStates.length) {
            sessionDisplay.objMarkedStates[n] = this.objMarkedStates[n];
            ++n;
        }
        sessionDisplay.visSelectStates = new boolean[this.visSelectStates.length];
        n = 0;
        while (n < this.visSelectStates.length) {
            sessionDisplay.visSelectStates[n] = this.visSelectStates[n];
            ++n;
        }
        sessionDisplay.visSelectStatesMarked = new boolean[this.visSelectStatesMarked.length];
        n = 0;
        while (n < this.visSelectStatesMarked.length) {
            sessionDisplay.visSelectStatesMarked[n] = this.visSelectStatesMarked[n];
            ++n;
        }
        return sessionDisplay;
    }
}

