/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.plugin;

import com.agfa.pacs.impaxee.plugin.IPlugin;
import com.agfa.pacs.impaxee.plugin.PluginFactory;
import com.agfa.pacs.impaxee.plugin.PluginKeeper;
import com.tiani.jvision.plugin.PluginName;
import java.util.List;

public abstract class PluginManager {
    public static int getPluginCount() {
        int n = PluginFactory.getInstance().getPluginKeeper().size();
        return n;
    }

    public static IPlugin getPlugin(int n) {
        return PluginFactory.getInstance().getPluginKeeper().get(n).getPlugin();
    }

    public static PluginKeeper getPluginKeeper(int n) {
        return PluginFactory.getInstance().getPluginKeeper().get(n);
    }

    public static IPlugin getTFPlugin() {
        return PluginManager.getPlugin(PluginName.TF.getPluginName(), true);
    }

    public static IPlugin getRadiotherapyPlugin() {
        return PluginManager.getPlugin(PluginName.DVH.getPluginName(), true);
    }

    public static IPlugin getPlugin(String string) {
        if (string == null || string.length() < 1) {
            return null;
        }
        return PluginManager.getPlugin(string, false);
    }

    private static IPlugin getPlugin(String string, boolean bl) {
        List<IPlugin> list = PluginFactory.getInstance().getPlugins();
        for (IPlugin iPlugin : list) {
            if (!iPlugin.getName().equals(string) || iPlugin.noDisplayPlugin() && !bl) continue;
            return iPlugin;
        }
        return null;
    }

    public static IPlugin getPluginByActionCode(String string) {
        if (string == null) {
            return null;
        }
        List<IPlugin> list = PluginFactory.getInstance().getPlugins();
        for (IPlugin iPlugin : list) {
            if (!iPlugin.getActionID().equals(string) || iPlugin.noDisplayPlugin()) continue;
            return iPlugin;
        }
        return null;
    }
}

