/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.plugin;

import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PDataScope;
import com.agfa.pacs.impaxee.actions.impl.AbstractPDataAction;
import com.agfa.pacs.impaxee.mousemodeinfo.IMouseModeInfo;
import com.agfa.pacs.impaxee.mousemodeinfo.MouseModeInfoGlobal;
import com.agfa.pacs.impaxee.plugin.IDisplayPlugin;
import com.agfa.pacs.impaxee.plugin.IPlugin;
import com.agfa.pacs.impaxee.plugin.MultiSeriesSupport;
import com.agfa.pacs.impaxee.plugin.PluginObjectData;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.jvision.event.TEvent;
import com.tiani.jvision.image.View;
import com.tiani.jvision.main.IToolBarTabPanel;
import com.tiani.jvision.main.TabDefRecord;
import com.tiani.jvision.vis.Vis2;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.jvision.vis.VisDisplayData;
import com.tiani.jvision.vis.event.IVisNavigationEventHandler;
import com.tiani.jvision.vis.layout.LytDisplay;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractDisplayPlugin
implements IDisplayPlugin {
    private List<TabDefRecord> tabRecords;
    protected VisDisplayData visDisplayData;
    protected IPlugin plugin;

    public AbstractDisplayPlugin(VisDisplayData visDisplayData, IPlugin iPlugin) {
        this.visDisplayData = visDisplayData;
        this.plugin = iPlugin;
        this.getMouseModeInfo().addMouseModeInfoListener(this);
        if (!(this.getMouseModeInfo() instanceof MouseModeInfoGlobal)) {
            MouseModeInfoGlobal.getInstance().addMouseModeInfoListener(this);
        }
    }

    protected List<IFrameObjectData> getSelectedFrames(PluginObjectData[] pluginObjectDataArray) {
        ArrayList<IFrameObjectData> arrayList = new ArrayList<IFrameObjectData>(pluginObjectDataArray.length);
        int n = 0;
        while (n < pluginObjectDataArray.length) {
            if (pluginObjectDataArray[n].isSelected) {
                arrayList.add(pluginObjectDataArray[n].frameData);
            }
            ++n;
        }
        if (arrayList.isEmpty()) {
            this.addAllFrames(pluginObjectDataArray, arrayList);
        }
        return arrayList;
    }

    protected List<IFrameObjectData> getAllFrames(PluginObjectData[] pluginObjectDataArray) {
        ArrayList<IFrameObjectData> arrayList = new ArrayList<IFrameObjectData>(pluginObjectDataArray.length);
        this.addAllFrames(pluginObjectDataArray, arrayList);
        return arrayList;
    }

    private void addAllFrames(PluginObjectData[] pluginObjectDataArray, List<IFrameObjectData> list) {
        int n = 0;
        while (n < pluginObjectDataArray.length) {
            list.add(pluginObjectDataArray[n].frameData);
            ++n;
        }
    }

    @Override
    public void cleanUp() {
        MouseModeInfoGlobal.getInstance().removeMouseModeInfoListener(this);
        this.getMouseModeInfo().removeMouseModeInfoListener(this);
    }

    @Override
    public void updateActiveTabs() {
    }

    @Override
    public List<TabDefRecord> getTabRecords() {
        if (this.tabRecords == null) {
            this.tabRecords = new ArrayList<TabDefRecord>();
            IToolBarTabPanel[] iToolBarTabPanelArray = this.getToolBarComponents();
            if (iToolBarTabPanelArray != null) {
                IToolBarTabPanel[] iToolBarTabPanelArray2 = iToolBarTabPanelArray;
                int n = iToolBarTabPanelArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IToolBarTabPanel iToolBarTabPanel = iToolBarTabPanelArray2[n2];
                    if (iToolBarTabPanel != null) {
                        this.tabRecords.add(new TabDefRecord(iToolBarTabPanel, iToolBarTabPanel.getTitle()));
                    }
                    ++n2;
                }
            }
        }
        return this.tabRecords;
    }

    public void setTabRecords(List<TabDefRecord> list) {
        this.tabRecords = list;
    }

    @Override
    public void contextGained() {
    }

    @Override
    public boolean wantsFullscreenOnStart() {
        return false;
    }

    @Override
    public IMouseModeInfo getMouseModeInfo() {
        return MouseModeInfoGlobal.getInstance();
    }

    @Override
    public IVisNavigationEventHandler getVisNavigationEventHandler() {
        return null;
    }

    @Override
    public boolean isMeasuringAllowed() {
        return true;
    }

    @Override
    public void mouseModeChanged() {
        if (this.tabRecords != null) {
            for (TabDefRecord object : this.tabRecords) {
                object.tabComp.updateGUI();
            }
        }
        if (this.visDisplayData != null && this.getMouseModeInfo() != null) {
            IMouseModeInfo iMouseModeInfo = this.getMouseModeInfo();
            VisDisplay2 visDisplay2 = this.visDisplayData.getVisDisplay();
            int n = 0;
            while (n < visDisplay2.getVisViewCount()) {
                Vis2 vis2 = visDisplay2.getVisView(n);
                vis2.getMouseHandler().setCursor(iMouseModeInfo.getCursor(vis2));
                vis2.invalidate();
                vis2.repaint();
                ++n;
            }
        }
    }

    @Override
    public void hotregionOutsideModeChanged(boolean bl) {
        if (this.visDisplayData != null && this.getMouseModeInfo() != null) {
            IMouseModeInfo iMouseModeInfo = this.getMouseModeInfo();
            boolean bl2 = iMouseModeInfo.areHotRegionsInside();
            boolean bl3 = iMouseModeInfo.areHotRegionsEnabled();
            VisDisplay2 visDisplay2 = this.visDisplayData.getVisDisplay();
            int n = 0;
            while (n < visDisplay2.getVisViewCount()) {
                Vis2 vis2 = visDisplay2.getVisView(n);
                vis2.updateHROutsideMode(bl2);
                if (bl3) {
                    vis2.addHRs();
                } else {
                    vis2.removeHRs();
                }
                vis2.invalidate();
                vis2.repaint();
                ++n;
            }
        }
    }

    @Override
    public List<PAction> getInvalidGlobalActions() {
        return new ArrayList<PAction>();
    }

    @Override
    public List<PAction> getInvalidDisplayToolbarActions() {
        return new ArrayList<PAction>();
    }

    @Override
    public boolean isAbleToHandleLayoutChanges() {
        return true;
    }

    @Override
    public boolean isAggregating() {
        return true;
    }

    @Override
    public final boolean isLayerable() {
        return this.getMultiSeriesSupport() == MultiSeriesSupport.LAYERABLE;
    }

    @Override
    public final boolean isReusable() {
        return this.getMultiSeriesSupport() != MultiSeriesSupport.NONE;
    }

    protected abstract MultiSeriesSupport getMultiSeriesSupport();

    @Override
    public LytDisplay getSpecialLayout() {
        return null;
    }

    @Override
    public List<PAction> getPluginContextMenuButtonActions(View view) {
        return new ArrayList<PAction>(3);
    }

    @Override
    public List<PAction> getPluginContextMenuTextActions(View view) {
        return new ArrayList<PAction>(1);
    }

    @Override
    public List<VisData> getSecondaryCaptureVisDatas(PDataScope pDataScope) {
        return AbstractPDataAction.getVisDatas(pDataScope);
    }

    @Override
    public boolean simpleAnimate() {
        return false;
    }

    @Override
    public void activateSynchronisation(boolean bl) {
    }

    @Override
    public void notifyHangupCompleted() {
    }

    @Override
    public void handleTEvent(TEvent tEvent, Object object) {
    }
}

