/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.hanging.model.xml;

import com.agfa.pacs.impaxee.hanging.gui.ConditionListEntry;
import com.agfa.pacs.impaxee.hanging.model.AbstractTag;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IDataObject;
import com.tiani.base.data.ISeriesData;
import com.tiani.util.expressions.BooleanNode;
import com.tiani.util.expressions.IEvaluationContext;
import com.tiani.util.expressions.OperatorEnum;
import java.text.Collator;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class Condition
extends AbstractTag
implements Comparable<Condition> {
    private static final ALogger log = ALogger.getLogger(Condition.class);
    private static Collator collator = Collator.getInstance();
    private static final String xmlName;
    private static final Map<Condition, BooleanNode> conditionCache;
    private OperatorEnum operator = OperatorEnum.EQUAL;
    private String value = "";

    static {
        collator.setStrength(0);
        xmlName = Condition.classBaseName(Condition.class);
        conditionCache = new ConcurrentHashMap<Condition, BooleanNode>(256, 0.75f, 4);
    }

    public Condition() {
    }

    public Condition(Integer n, OperatorEnum operatorEnum, String string) {
        this.setTag(n);
        this.setOperator(operatorEnum);
        this.setValue(string);
    }

    public OperatorEnum getOperator() {
        return this.operator;
    }

    public void setOperator(OperatorEnum operatorEnum) {
        this.operator = operatorEnum;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        this.value = string == null ? "" : string;
    }

    @Override
    public void setTag(Integer n) {
        super.setTag(n);
    }

    public static boolean evaluate(Condition condition, IEvaluationContext iEvaluationContext) throws IllegalArgumentException {
        BooleanNode booleanNode = conditionCache.get(condition);
        if (booleanNode == null) {
            booleanNode = OperatorEnum.createBooleanNode(condition.getTag(), condition.getOperator(), condition.getValue());
            if (booleanNode != null) {
                conditionCache.put(condition, booleanNode);
            } else {
                return false;
            }
        }
        return booleanNode.evaluate(iEvaluationContext);
    }

    private static String getTag(IDataObject iDataObject, int n) {
        if (n == 524384) {
            return iDataObject.getModality();
        }
        if (n == 528446) {
            return iDataObject.getSeriesDescription();
        }
        if (n == 528432) {
            return iDataObject.getDicomObject().getString(528432);
        }
        if (n == 524296) {
            return Arrays.toString(iDataObject.getDicomObject().getStrings(n));
        }
        if (n == 524310) {
            if (iDataObject instanceof ISeriesData) {
                iDataObject = ((ISeriesData)iDataObject).getFirstObject();
            }
            return iDataObject.getDicomObject().getString(n);
        }
        return null;
    }

    public static boolean evaluate(Condition condition, IDataObject iDataObject) throws IllegalArgumentException {
        Object object;
        OperatorEnum operatorEnum = condition.getOperator();
        if (operatorEnum == OperatorEnum.EQUAL) {
            object = Condition.getTag(iDataObject, condition.getTag());
            if (object != null) {
                object = ((String)object).toUpperCase();
                return ((String)object).equals(condition.value.toUpperCase());
            }
        } else if (operatorEnum == OperatorEnum.CONTAINS) {
            object = Condition.getTag(iDataObject, condition.getTag());
            if (object != null) {
                object = ((String)object).toUpperCase();
                return ((String)object).contains(condition.value.toUpperCase());
            }
        } else if (operatorEnum == OperatorEnum.DOESNOTCONTAIN && (object = Condition.getTag(iDataObject, condition.getTag())) != null) {
            return !((String)(object = ((String)object).toUpperCase())).contains(condition.value.toUpperCase());
        }
        if ((object = conditionCache.get(condition)) == null) {
            object = OperatorEnum.createBooleanNode(condition.getTag(), condition.getOperator(), condition.getValue());
            if (object != null) {
                conditionCache.put(condition, (BooleanNode)object);
            } else {
                return false;
            }
        }
        return object.evaluate(iDataObject);
    }

    public Condition clone() {
        Condition condition = new Condition();
        condition.operator = this.operator;
        condition.value = this.value;
        condition.setTag(this.getTag());
        return condition;
    }

    @Override
    public int compareTo(Condition condition) {
        if (condition != null) {
            return collator.compare(this.toString(), condition.toString());
        }
        return 1;
    }

    public String generatedDescription() {
        return ConditionListEntry.getPlainString(this);
    }

    @Override
    public String toString() {
        return this.generatedDescription();
    }

    public String tagName() {
        return xmlName;
    }
}

