/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.hanging.impl;

import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.IStudyContainer;
import com.agfa.pacs.impaxee.hanging.impl.ImpaxEEDisplaySet;
import com.agfa.pacs.impaxee.hanging.model.xml.HangingProtocol;
import com.agfa.pacs.impaxee.hanging.runtime.HangingProtocolRuntime;
import com.agfa.pacs.impaxee.hanging.runtime.UserDefinedHangingProtocolRuntime;
import com.agfa.pacs.impaxee.splitsort.model.ISplitAndSortRuntime;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.util.TicketOffice;

public class HangingFactory {
    private static final ALogger log = ALogger.getLogger(HangingFactory.class);
    private static HangingFactory instance = new HangingFactory();

    public static HangingFactory getInstance() {
        return instance;
    }

    public HangingProtocolRuntime newHangingCase(IStudyContainer iStudyContainer, HangingProtocol hangingProtocol, boolean bl) {
        return new UserDefinedHangingProtocolRuntime(iStudyContainer, hangingProtocol, iStudyContainer.getPatientRepresentation().getDecompositionRuntime(), bl);
    }

    public IDisplaySet newDisplaySet(IFrameObjectData[] iFrameObjectDataArray, ISplitAndSortRuntime iSplitAndSortRuntime) {
        return ImpaxEEDisplaySet.createDisplaySet(HangingFactory.generateUIDforObjects(iFrameObjectDataArray), iFrameObjectDataArray, iSplitAndSortRuntime);
    }

    private static String generateUIDforObjects(IFrameObjectData[] iFrameObjectDataArray) {
        if (iFrameObjectDataArray == null || iFrameObjectDataArray.length == 0) {
            log.info("generateUIDforObjects: No objects list or list empty. Getting incremental ticket as ID.");
            return Long.toString(TicketOffice.getNewStamp());
        }
        StringBuilder stringBuilder = new StringBuilder(iFrameObjectDataArray[0].getSOPInstanceUID());
        if (iFrameObjectDataArray.length > 1) {
            stringBuilder.append(iFrameObjectDataArray[iFrameObjectDataArray.length - 1].getSOPInstanceUID());
        }
        return stringBuilder.toString();
    }
}

