/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.hanging.gui.advanced;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.hanging.model.IHangingProtocolDefinition;
import com.agfa.pacs.impaxee.hanging.model.xml.HangingCondition;
import com.agfa.pacs.impaxee.hanging.model.xml.ReferencedRole;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class HangingProtocolWarningUtil {
    private HangingProtocolWarningUtil() {
    }

    public static List<String> getWarnings(IHangingProtocolDefinition iHangingProtocolDefinition) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!iHangingProtocolDefinition.getActive().booleanValue()) {
            arrayList.add(Messages.getString("HangingProtocolTreeNode.WarningNotInUse"));
        }
        if (!HangingProtocolWarningUtil.isAllowedForAtLeastOneRole(iHangingProtocolDefinition)) {
            arrayList.add(Messages.getString("HangingProtocolTreeNode.WarningNoRoleSelected"));
        }
        if (iHangingProtocolDefinition.getHangingApplicability().hangingConditions().length == 0) {
            arrayList.add(Messages.getString("HangingProtocolTreeNode.WarningNoRoles"));
        } else {
            HangingCondition[] hangingConditionArray = iHangingProtocolDefinition.getHangingApplicability().hangingConditions();
            int n = hangingConditionArray.length;
            int n2 = 0;
            while (n2 < n) {
                HangingCondition hangingCondition2 = hangingConditionArray[n2];
                if (hangingCondition2.referencedDescriptorList().size() == 0) {
                    arrayList.add(String.valueOf(Messages.getString("HangingProtocolTreeNode.WarningEmptyRole1")) + " \"" + hangingCondition2.getName() + "\" " + Messages.getString("HangingProtocolTreeNode.WarningEmptyRole2"));
                }
                ++n2;
            }
        }
        return arrayList;
    }

    public static String createToolTipText(Collection<String> collection, Collection<String> collection2) {
        if (collection.size() == 0 && collection2.size() == 0) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        if (collection.size() > 0) {
            stringBuilder.append("<b>");
            stringBuilder.append(Messages.getString("ActivationStateTreeCellRenderer.Errors"));
            stringBuilder.append("</b>");
            for (String string : collection) {
                stringBuilder.append("<br> - ");
                stringBuilder.append(string);
            }
            if (!collection2.isEmpty()) {
                stringBuilder.append("<br>");
            }
        }
        if (collection2.size() > 0) {
            stringBuilder.append("<b>");
            stringBuilder.append(Messages.getString("ActivationStateTreeCellRenderer.Warnings"));
            stringBuilder.append("</b>");
            for (String string : collection2) {
                stringBuilder.append("<br> - ");
                stringBuilder.append(string);
            }
        }
        stringBuilder.append("</html>");
        return stringBuilder.toString();
    }

    private static boolean isAllowedForAtLeastOneRole(IHangingProtocolDefinition iHangingProtocolDefinition) {
        if (iHangingProtocolDefinition.getHangingAccessAuthorization() != null) {
            int n = 0;
            while (true) {
                ReferencedRole referencedRole;
                if ((referencedRole = iHangingProtocolDefinition.getHangingAccessAuthorization().getReferencedRole(n)) == null) {
                    return false;
                }
                if (Boolean.FALSE.equals(referencedRole.getForbidden())) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }
}

