/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.hanging.gui.advanced;

import com.agfa.pacs.base.swing.IComponentFactory;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.impaxee.hanging.HangingProtocolManipulationListenerDispatcher;
import com.agfa.pacs.impaxee.hanging.HangingUtil;
import com.agfa.pacs.impaxee.hanging.IConditionEvaluator;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.IHangingProtocolManipulationListener;
import com.agfa.pacs.impaxee.hanging.gui.advanced.ActivationStateTreeNode;
import com.agfa.pacs.impaxee.hanging.gui.advanced.CreateAbstractConditionPanel;
import com.agfa.pacs.impaxee.hanging.gui.advanced.DisplaySettingsPanel;
import com.agfa.pacs.impaxee.hanging.model.IDisplayLayoutDefinition;
import com.agfa.pacs.impaxee.hanging.model.enums.MainLayoutType;
import com.agfa.pacs.impaxee.hanging.model.xml.Condition;
import com.agfa.pacs.impaxee.hanging.model.xml.DisplaySetCondition;
import com.agfa.pacs.impaxee.hanging.runtime.DisplayLayoutRuntime;
import com.agfa.pacs.impaxee.hanging.runtime.HangingProtocolRuntime;
import com.agfa.pacs.impaxee.hanging.runtime.ScreenLayoutRuntime;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.tree.MutableTreeNode;

public class DisplayTreeNode
extends ActivationStateTreeNode
implements IHangingProtocolManipulationListener,
IConditionEvaluator {
    private int display;
    private CreateAbstractConditionPanel cdcPanel;
    private DisplaySettingsPanel displaySettingsPanel;
    private JPanel panel;
    private DisplaySetCondition displaySetCondition;
    private IDisplayLayoutDefinition displayLayout;

    public DisplayTreeNode(Window window, MainLayoutType mainLayoutType, DisplaySetCondition displaySetCondition2, IDisplayLayoutDefinition iDisplayLayoutDefinition, IHangingProtocolManipulationListener iHangingProtocolManipulationListener, IComponentFactory iComponentFactory, int n, boolean bl) {
        super(iComponentFactory);
        this.display = n;
        this.displayLayout = iDisplayLayoutDefinition;
        this.displaySetCondition = displaySetCondition2;
        HangingProtocolManipulationListenerDispatcher hangingProtocolManipulationListenerDispatcher = new HangingProtocolManipulationListenerDispatcher();
        hangingProtocolManipulationListenerDispatcher.registerListener(iHangingProtocolManipulationListener);
        hangingProtocolManipulationListenerDispatcher.registerListener(this);
        this.cdcPanel = new CreateAbstractConditionPanel(window, Messages.getString("DisplayTreeNode.DisplayConditionSets"), this.displaySetCondition, iComponentFactory, hangingProtocolManipulationListenerDispatcher, this);
        this.displaySettingsPanel = new DisplaySettingsPanel(mainLayoutType, iDisplayLayoutDefinition, iComponentFactory, hangingProtocolManipulationListenerDispatcher);
        this.panel = ComponentFactory.instance.createPanel(new BorderLayout());
        this.panel.add((Component)this.cdcPanel, "Center");
        this.panel.add((Component)this.displaySettingsPanel, "North");
        this.kindOfHangingChanged(bl);
    }

    @Override
    public String toString() {
        return String.valueOf(Messages.getString("MyTreeNode.Display")) + " " + this.display;
    }

    public CreateAbstractConditionPanel getCreateAbstractConditionPanel() {
        return this.cdcPanel;
    }

    public DisplaySettingsPanel getDisplaySettingsPanel() {
        return this.displaySettingsPanel;
    }

    @Override
    public JPanel getPanel() {
        return this.panel;
    }

    public void screenLayoutTypeChanged(MainLayoutType mainLayoutType) {
        this.getDisplaySettingsPanel().setLayout(mainLayoutType, null);
    }

    public void displayLayoutChanged(MainLayoutType mainLayoutType, String string) {
        this.displaySettingsPanel.setLayout(mainLayoutType, string);
    }

    public DisplaySetCondition getDisplaySetCondition() {
        return this.displaySetCondition;
    }

    public void kindOfHangingChanged(boolean bl) {
        this.setEnabled(this.cdcPanel, !bl);
        this.checkForWarningsAndErrors();
    }

    private void setEnabled(Component component, boolean bl) {
        component.setEnabled(bl);
        if (component instanceof Container) {
            Container container = (Container)component;
            Component[] componentArray = container.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component component2 = componentArray[n2];
                this.setEnabled(component2, bl);
                ++n2;
            }
        }
    }

    public IDisplayLayoutDefinition getDisplayLayout() {
        return this.displayLayout;
    }

    @Override
    public void hangingChanged() {
        this.checkForWarningsAndErrors();
    }

    private void checkForWarningsAndErrors() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.getCreateAbstractConditionPanel().isEnabled() && this.displayLayout instanceof DisplayLayoutRuntime) {
            DisplayLayoutRuntime displayLayoutRuntime = (DisplayLayoutRuntime)this.displayLayout;
            IDisplaySet iDisplaySet = displayLayoutRuntime.getDisplaySet();
            ScreenLayoutRuntime screenLayoutRuntime = displayLayoutRuntime.getScreenLayoutRuntime();
            IDisplaySet iDisplaySet2 = null;
            if (screenLayoutRuntime != null) {
                HangingProtocolRuntime hangingProtocolRuntime = screenLayoutRuntime.getLayoutRuntime().getHangingSnapshot().getHangingDefinitionRuntime().getHangingProtocolRuntime();
                iDisplaySet2 = HangingUtil.getFirstMatchingDisplaySet(hangingProtocolRuntime, this.displaySetCondition);
            }
            if (iDisplaySet != null && iDisplaySet != iDisplaySet2) {
                arrayList.add(Messages.getString("DisplayTreeNode.WarningIncompatibleConditionSets"));
                this.setWarningMessagesSelf(arrayList);
                this.setHasWarningSelf(true);
            } else {
                this.setWarningMessagesSelf(arrayList);
                this.setHasWarningSelf(false);
            }
        } else {
            this.setWarningMessagesSelf(arrayList);
            this.setHasWarningSelf(false);
        }
    }

    @Override
    public boolean isEvaluationPossible() {
        if (this.displayLayout instanceof DisplayLayoutRuntime) {
            DisplayLayoutRuntime displayLayoutRuntime = (DisplayLayoutRuntime)this.displayLayout;
            return displayLayoutRuntime.getDisplaySet() != null && displayLayoutRuntime.getScreenLayoutRuntime() != null;
        }
        return false;
    }

    @Override
    public boolean meetsConditions(Iterable<Condition> iterable) {
        if (this.displayLayout instanceof DisplayLayoutRuntime) {
            DisplayLayoutRuntime displayLayoutRuntime = (DisplayLayoutRuntime)this.displayLayout;
            IDisplaySet iDisplaySet = displayLayoutRuntime.getDisplaySet();
            ScreenLayoutRuntime screenLayoutRuntime = displayLayoutRuntime.getScreenLayoutRuntime();
            if (iDisplaySet != null && screenLayoutRuntime != null) {
                HangingProtocolRuntime hangingProtocolRuntime = screenLayoutRuntime.getLayoutRuntime().getHangingSnapshot().getHangingDefinitionRuntime().getHangingProtocolRuntime();
                return HangingUtil.matches(iDisplaySet, hangingProtocolRuntime, iterable);
            }
        }
        return true;
    }

    @Override
    public void setParent(MutableTreeNode mutableTreeNode) {
        this.parent = mutableTreeNode;
        if (mutableTreeNode instanceof ActivationStateTreeNode) {
            this.hangingChanged();
        }
    }

    @Override
    public void deregisterListeners() {
        super.deregisterListeners();
        this.cdcPanel.deregisterListener();
    }
}

