/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.hanging.gui.advanced;

import com.agfa.pacs.base.swing.IComponentFactory;
import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.ui.DropDownButton;
import com.agfa.pacs.impaxee.actions.ui.LayoutChooserPopupMenu;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.impaxee.hanging.IHangingProtocolManipulationListener;
import com.agfa.pacs.impaxee.hanging.gui.advanced.ScreenSettingsPanel;
import com.agfa.pacs.impaxee.hanging.gui.advanced.SnapshotSettingsPanel;
import com.agfa.pacs.impaxee.hanging.model.DisplayState;
import com.agfa.pacs.impaxee.hanging.model.IDisplayLayoutDefinition;
import com.agfa.pacs.impaxee.hanging.model.IDisplayState;
import com.agfa.pacs.impaxee.hanging.model.enums.MainLayoutType;
import com.agfa.pacs.impaxee.hanging.model.enums.ZoomMode;
import com.agfa.pacs.impaxee.icon.IAIconFactory;
import com.tiani.jvision.plugin.PluginName;
import com.tiani.jvision.toptoolbar.FilterActions;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DisplaySettingsPanel
extends JPanel {
    private JToggleButton[] displayLayoutButtons;
    private JToggleButton[] filmLayoutButtons;
    private final Icon[] variableLayoutIcons;
    private final Icon[] filmLayoutIcons;
    private static String[] variableLayouts = new String[]{"1x1", "1x2", "2x1", "2x2"};
    private static String[] filmLayouts = new String[]{"1x1", "2x2", "3x3", "4x4", "5x5", "6x6", "7x7", "8x8"};
    private static int[] degrees;
    private static String[] degreeCaptions;
    private static int[] pixelZoomFactors;
    private static String[] pixelZoomFactorCaptions;
    private static int[] zfr;
    private Vector<PresentationSizeModeWrapper> wrappers = new Vector();
    private ButtonGroup buttonGroupDisplayLayout;
    private ButtonGroup buttonGroupFilmLayout;
    private JComboBox comboBoxPlugin;
    private final JComboBox comboBoxFilter;
    private IDisplayLayoutDefinition displayLayout;
    private IDisplayState displayState;
    private JPanel panelDisplayLayoutButtons;
    private JPanel panelFilmLayoutButtons;
    private JPanel panelStripeLayout;
    private JPanel panelGB;
    private JLabel labelStripeColsInfo;
    private MainLayoutType screenLayoutType;
    private JComboBox<KeyImageOverviewType> keyImageOverviewCBox;
    private JComboBox comboBoxPresentationSizeMode;
    private JFormattedTextField formattedTextFieldZoomFactor;
    private JFormattedTextField formattedTextViewPortCenterX;
    private JFormattedTextField formattedTextViewPortCenterY;
    private JComboBox comboBoxRotation;
    private JCheckBox checkBoxHorizontalFlip;
    private JCheckBox checkBoxSynced;
    private JCheckBox checkBoxInverted;
    private final JCheckBox checkBoxLocalizer;
    private DropDownButton displayLayoutDropdown;
    private JFormattedTextField formattedTextWindowCenter;
    private JFormattedTextField formattedTextWindowWidth;
    private JComboBox comboBoxPixelZoomFactors;
    private JSlider sliderScrollingPosition;
    private final JCheckBox jumpToFirstKeyImage;
    private JCheckBox checkBoxStoreWindowLevel;
    private JLabel labelWindowCenter;
    private JLabel labelWindowWidth;
    private double currentScrollingPosition;
    private IHangingProtocolManipulationListener listener;

    static {
        int[] nArray = new int[4];
        nArray[1] = 90;
        nArray[2] = 180;
        nArray[3] = 270;
        degrees = nArray;
        degreeCaptions = new String[]{"0\u00b0", "90\u00b0", "180\u00b0", "270\u00b0"};
        pixelZoomFactors = new int[]{1, 2, 4, 8};
        pixelZoomFactorCaptions = new String[]{"1x", "2x", "4x", "8x"};
        int[] nArray2 = new int[9];
        nArray2[2] = 1;
        nArray2[3] = 1;
        nArray2[4] = 2;
        nArray2[5] = 2;
        nArray2[6] = 2;
        nArray2[7] = 3;
        nArray2[8] = 3;
        zfr = nArray2;
    }

    public DisplaySettingsPanel(MainLayoutType mainLayoutType, IDisplayLayoutDefinition iDisplayLayoutDefinition, IComponentFactory iComponentFactory, IHangingProtocolManipulationListener iHangingProtocolManipulationListener) {
        this.displayLayout = iDisplayLayoutDefinition;
        this.displayState = iDisplayLayoutDefinition.getDisplayState();
        this.listener = iHangingProtocolManipulationListener;
        if (this.displayState == null) {
            this.displayState = new DisplayState();
        }
        this.screenLayoutType = mainLayoutType;
        this.setOpaque(false);
        this.setBorder(iComponentFactory.createTitledBorder(Messages.getString("DisplaySettingsPanel.DisplaySettings")));
        this.setLayout(new BorderLayout());
        this.panelGB = ComponentFactory.instance.createPanel(new GridBagLayout());
        this.panelDisplayLayoutButtons = ComponentFactory.instance.createPanel(new GridLayout(1, variableLayouts.length, 0, 0));
        this.panelFilmLayoutButtons = ComponentFactory.instance.createPanel(new GridLayout(2, filmLayouts.length / 2, 0, 0));
        this.panelStripeLayout = ComponentFactory.instance.createPanel(new BorderLayout());
        this.labelStripeColsInfo = iComponentFactory.createLabel("");
        this.panelStripeLayout.add(this.labelStripeColsInfo);
        IAIconFactory iAIconFactory = new IAIconFactory(iComponentFactory, 32);
        this.variableLayoutIcons = new Icon[variableLayouts.length];
        int n = 0;
        while (n < variableLayouts.length) {
            this.variableLayoutIcons[n] = iAIconFactory.loadIcon("icon_display_layout_" + variableLayouts[n] + ".svg");
            ++n;
        }
        this.filmLayoutIcons = new Icon[filmLayouts.length];
        n = 0;
        while (n < filmLayouts.length) {
            this.filmLayoutIcons[n] = iAIconFactory.loadIcon("icon_film_layout_" + filmLayouts[n] + ".svg");
            ++n;
        }
        this.displayLayoutButtons = new JToggleButton[this.variableLayoutIcons.length];
        this.filmLayoutButtons = new JToggleButton[this.filmLayoutIcons.length];
        this.buttonGroupDisplayLayout = new ButtonGroup();
        this.buttonGroupFilmLayout = new ButtonGroup();
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DisplaySettingsPanel.this.storeHorizontalXVertical();
            }
        };
        int n2 = 0;
        while (n2 < this.variableLayoutIcons.length) {
            this.displayLayoutButtons[n2] = SnapshotSettingsPanel.createToggleButtonWithScaledIcon(iComponentFactory, this.variableLayoutIcons[n2]);
            this.buttonGroupDisplayLayout.add(this.displayLayoutButtons[n2]);
            this.panelDisplayLayoutButtons.add(this.displayLayoutButtons[n2]);
            this.displayLayoutButtons[n2].addActionListener(actionListener);
            ++n2;
        }
        this.displayLayoutDropdown = new DropDownButton("", null, LayoutChooserPopupMenu.createPopupMenu(new LayoutChooserPopupMenu.ILayoutSelectionHandler(){

            @Override
            public void layoutSelected(LayoutChooserPopupMenu.ILayoutSelectionSource iLayoutSelectionSource) {
                DisplaySettingsPanel.this.displayLayoutDropdown.setText(iLayoutSelectionSource.toLayoutString());
                DisplaySettingsPanel.this.storeHorizontalXVertical();
            }
        }), DropDownButton.Orientation.bottom);
        this.panelDisplayLayoutButtons.add(this.displayLayoutDropdown);
        this.displayLayoutDropdown.setPreferredSize(new Dimension(GUI.getScaledInt((int)100), (int)this.displayLayoutButtons[0].getPreferredSize().getHeight()));
        this.displayLayoutDropdown.setIcon((Icon)iAIconFactory.loadIcon("layout-configuration.svg"));
        n2 = 0;
        while (n2 < this.filmLayoutIcons.length) {
            this.filmLayoutButtons[n2] = SnapshotSettingsPanel.createToggleButtonWithScaledIcon(iComponentFactory, this.filmLayoutIcons[n2]);
            this.buttonGroupFilmLayout.add(this.filmLayoutButtons[n2]);
            this.panelFilmLayoutButtons.add(this.filmLayoutButtons[n2]);
            this.filmLayoutButtons[n2].addActionListener(actionListener);
            ++n2;
        }
        this.panelDisplayLayoutButtons.setAlignmentX(0.0f);
        this.comboBoxPlugin = iComponentFactory.createComboBox((Object[])PluginName.pluginValues());
        this.comboBoxFilter = iComponentFactory.createComboBox((Object[])FilterActions.FilterType.values());
        Object object = ZoomMode.values();
        int n3 = ((ZoomMode[])object).length;
        int n4 = 0;
        while (n4 < n3) {
            ZoomMode zoomMode = object[n4];
            this.wrappers.add(new PresentationSizeModeWrapper(zoomMode));
            ++n4;
        }
        this.comboBoxPresentationSizeMode = iComponentFactory.createComboBox(this.wrappers);
        this.comboBoxPresentationSizeMode.setSelectedIndex(-1);
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setMaximumFractionDigits(3);
        this.formattedTextFieldZoomFactor = iComponentFactory.createFormattedTextField((Format)numberFormat);
        Dimension dimension = this.formattedTextFieldZoomFactor.getPreferredSize();
        dimension.width = iComponentFactory.scaleInt(50);
        this.formattedTextFieldZoomFactor.setPreferredSize(dimension);
        this.comboBoxPixelZoomFactors = iComponentFactory.createComboBox((Object[])pixelZoomFactorCaptions);
        dimension = this.comboBoxPixelZoomFactors.getPreferredSize();
        dimension.width = iComponentFactory.scaleInt(60);
        this.comboBoxPixelZoomFactors.setPreferredSize(dimension);
        NumberFormat numberFormat2 = NumberFormat.getNumberInstance();
        numberFormat2.setMaximumFractionDigits(6);
        this.formattedTextViewPortCenterX = iComponentFactory.createFormattedTextField((Format)numberFormat2);
        this.formattedTextViewPortCenterY = iComponentFactory.createFormattedTextField((Format)numberFormat2);
        dimension = this.formattedTextViewPortCenterX.getPreferredSize();
        dimension.width = iComponentFactory.scaleInt(60);
        this.formattedTextViewPortCenterX.setPreferredSize(dimension);
        dimension = this.formattedTextViewPortCenterY.getPreferredSize();
        dimension.width = iComponentFactory.scaleInt(60);
        this.formattedTextViewPortCenterY.setPreferredSize(dimension);
        this.comboBoxRotation = iComponentFactory.createComboBox((Object[])degreeCaptions);
        this.checkBoxHorizontalFlip = iComponentFactory.createCheckBox(Messages.getString("DisplaySettingsPanel.HorizontalFlip"));
        this.checkBoxSynced = iComponentFactory.createCheckBox(Messages.getString("DisplaySettingsPanel.Synchronized"));
        this.checkBoxInverted = iComponentFactory.createCheckBox(Messages.getString("DisplaySettingsPanel.Inverted"));
        this.checkBoxLocalizer = iComponentFactory.createCheckBox(Messages.getString("DisplaySettingsPanel.Localizer"));
        object = NumberFormat.getNumberInstance();
        ((NumberFormat)object).setMaximumFractionDigits(6);
        this.formattedTextWindowCenter = iComponentFactory.createFormattedTextField((Format)new EmptyStringNumberFormatter((Format)object));
        this.formattedTextWindowWidth = iComponentFactory.createFormattedTextField((Format)new EmptyStringNumberFormatter((Format)object));
        dimension = this.formattedTextWindowCenter.getPreferredSize();
        dimension.width = iComponentFactory.scaleInt(60);
        this.formattedTextWindowCenter.setPreferredSize(dimension);
        dimension = this.formattedTextWindowWidth.getPreferredSize();
        dimension.width = iComponentFactory.scaleInt(60);
        this.formattedTextWindowWidth.setPreferredSize(dimension);
        this.labelWindowCenter = iComponentFactory.createLabel(String.valueOf(Messages.getString("DisplaySettingsPanel.WindowCenter")) + ":");
        this.labelWindowWidth = iComponentFactory.createLabel(String.valueOf(Messages.getString("DisplaySettingsPanel.WindowWidth")) + ":");
        this.checkBoxStoreWindowLevel = iComponentFactory.createCheckBox(Messages.getString("EditDisplaysetConditionAndSimpleDisplayStatePanel.UseWindowLevel"), Messages.getString("EditDisplaysetConditionAndSimpleDisplayStatePanel.UseWindowLevelToolTip"));
        this.sliderScrollingPosition = iComponentFactory.createSlider(Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(100), Integer.valueOf(0));
        this.sliderScrollingPosition.setMajorTickSpacing(25);
        this.sliderScrollingPosition.setPaintLabels(true);
        this.sliderScrollingPosition.setPaintTicks(true);
        this.sliderScrollingPosition.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                int n = DisplaySettingsPanel.this.sliderScrollingPosition.getValue();
                DisplaySettingsPanel.this.currentScrollingPosition = (double)n / 100.0;
            }
        });
        this.jumpToFirstKeyImage = iComponentFactory.createCheckBox(Messages.getString("DisplaySettingsPanel.JumpToFirstKeyImage"));
        this.keyImageOverviewCBox = iComponentFactory.createComboBox((Object[])KeyImageOverviewType.values());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelGB.add((Component)iComponentFactory.createLabel(String.valueOf(Messages.getString("DisplaySettingsPanel.Layout")) + ":"), gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.panelGB.add((Component)iComponentFactory.createLabel(String.valueOf(Messages.getString("DisplaySettingsPanel.Plugin")) + ":"), gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.panelGB.add((Component)iComponentFactory.createLabel(String.valueOf(Messages.getString("DisplaySettingsPanel.Filter")) + ":"), gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.panelGB.add((Component)iComponentFactory.createLabel(String.valueOf(Messages.getString("DisplaySettingsPanel.ViewPortCenter")) + " (x)" + ":"), gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.panelGB.add((Component)iComponentFactory.createLabel(String.valueOf(Messages.getString("DisplaySettingsPanel.ViewPortCenter")) + " (y)" + ":"), gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.panelGB.add((Component)iComponentFactory.createLabel(String.valueOf(Messages.getString("DisplaySettingsPanel.Rotation")) + ":"), gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.panelGB.add((Component)this.checkBoxHorizontalFlip, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.panelGB.add((Component)iComponentFactory.createLabel(String.valueOf(Messages.getString("DisplaySettingsPanel.ScrollingPosition")) + ":"), gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.panelGB.add((Component)this.comboBoxPlugin, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.panelGB.add((Component)this.comboBoxFilter, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.panelGB.add((Component)this.formattedTextViewPortCenterX, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.panelGB.add((Component)this.formattedTextViewPortCenterY, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.panelGB.add((Component)this.comboBoxRotation, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.panelGB.add((Component)this.checkBoxSynced, gridBagConstraints);
        ++gridBagConstraints.gridx;
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 0;
        this.panelGB.add((Component)iComponentFactory.createLabel(String.valueOf(Messages.getString("DisplaySettingsPanel.ZoomMode")) + ":"), gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.panelGB.add((Component)iComponentFactory.createLabel(String.valueOf(Messages.getString("DisplaySettingsPanel.MagnificationRatio")) + ":"), gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.panelGB.add((Component)iComponentFactory.createLabel(String.valueOf(Messages.getString("DisplaySettingsPanel.KeyImageOverview")) + ":"), gridBagConstraints);
        gridBagConstraints.gridwidth = 2;
        ++gridBagConstraints.gridy;
        this.panelGB.add((Component)this.checkBoxStoreWindowLevel, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        ++gridBagConstraints.gridy;
        this.panelGB.add((Component)this.labelWindowCenter, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.panelGB.add((Component)this.labelWindowWidth, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.panelGB.add((Component)this.checkBoxInverted, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.panelGB.add((Component)this.comboBoxPresentationSizeMode, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.panelGB.add((Component)this.formattedTextFieldZoomFactor, gridBagConstraints);
        this.panelGB.add((Component)this.comboBoxPixelZoomFactors, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.panelGB.add(this.keyImageOverviewCBox, gridBagConstraints);
        gridBagConstraints.gridy += 2;
        this.panelGB.add((Component)this.formattedTextWindowCenter, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.panelGB.add((Component)this.formattedTextWindowWidth, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.panelGB.add((Component)this.checkBoxLocalizer, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        this.panelGB.add((Component)this.sliderScrollingPosition, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.panelGB.add((Component)this.jumpToFirstKeyImage, gridBagConstraints);
        this.ensureSamePreferredSize(this.comboBoxPlugin, this.comboBoxPresentationSizeMode);
        this.add((Component)this.panelGB, "Center");
        this.init(iDisplayLayoutDefinition);
        this.registerListeners();
        this.showProperInputComponentForZoomFactor();
    }

    private void ensureSamePreferredSize(JComponent jComponent, JComponent jComponent2) {
        Dimension dimension = jComponent.getPreferredSize();
        Dimension dimension2 = jComponent2.getPreferredSize();
        int n = Math.max(dimension.height, dimension2.height);
        int n2 = Math.max(dimension.width, dimension2.width);
        jComponent.setPreferredSize(new Dimension(n2, n));
        jComponent2.setPreferredSize(new Dimension(n2, n));
    }

    private void registerListeners() {
        this.comboBoxPresentationSizeMode.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                DisplaySettingsPanel.this.showProperInputComponentForZoomFactor();
                DisplaySettingsPanel.this.storeZoomMode();
            }
        });
        this.formattedTextFieldZoomFactor.addPropertyChangeListener("value", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                DisplaySettingsPanel.this.storeZoomMode();
            }
        });
        this.comboBoxPlugin.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                DisplaySettingsPanel.this.storePluginName();
                DisplaySettingsPanel.this.enableDisplayStateComponents(DisplaySettingsPanel.this.comboBoxPlugin.getSelectedItem() == PluginName.DEFAULT);
            }
        });
        this.comboBoxFilter.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                DisplaySettingsPanel.this.storeFilterName();
            }
        });
        this.formattedTextViewPortCenterX.addPropertyChangeListener("value", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                DisplaySettingsPanel.this.storeViewPortCenterX();
            }
        });
        this.formattedTextViewPortCenterY.addPropertyChangeListener("value", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                DisplaySettingsPanel.this.storeViewPortCenterY();
            }
        });
        this.formattedTextWindowCenter.addPropertyChangeListener("value", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                DisplaySettingsPanel.this.storeWindowCenter();
            }
        });
        this.formattedTextWindowWidth.addPropertyChangeListener("value", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                DisplaySettingsPanel.this.storeWindowWidth();
            }
        });
        this.checkBoxInverted.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DisplaySettingsPanel.this.storeInverted();
            }
        });
        this.checkBoxLocalizer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DisplaySettingsPanel.this.storeLocalizer();
            }
        });
        this.checkBoxSynced.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DisplaySettingsPanel.this.storeSynced();
            }
        });
        this.checkBoxHorizontalFlip.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DisplaySettingsPanel.this.storeHorizontalFlip();
            }
        });
        this.comboBoxRotation.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                DisplaySettingsPanel.this.storeImageRotation();
            }
        });
        this.comboBoxPixelZoomFactors.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                DisplaySettingsPanel.this.storeZoomMode();
            }
        });
        this.sliderScrollingPosition.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                DisplaySettingsPanel.this.storeScrollingPosition();
            }
        });
        this.jumpToFirstKeyImage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DisplaySettingsPanel.this.storeJumpToFirstKeyImage();
            }
        });
        this.checkBoxStoreWindowLevel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DisplaySettingsPanel.this.setWindowingComponentsVisible(DisplaySettingsPanel.this.checkBoxStoreWindowLevel.isSelected());
                DisplaySettingsPanel.this.storeUseWindowLevel();
            }
        });
        this.keyImageOverviewCBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DisplaySettingsPanel.this.displayState.setKeyImageOverviewStudyIndex(((KeyImageOverviewType)((Object)DisplaySettingsPanel.this.keyImageOverviewCBox.getSelectedItem())).getStudyIndex());
                DisplaySettingsPanel.this.informListener();
            }
        });
    }

    private void setWindowingComponentsVisible(boolean bl) {
        this.formattedTextWindowCenter.setVisible(bl);
        this.formattedTextWindowWidth.setVisible(bl);
        this.labelWindowCenter.setVisible(bl);
        this.labelWindowWidth.setVisible(bl);
    }

    protected void showProperInputComponentForZoomFactor() {
        Object object = this.comboBoxPresentationSizeMode.getSelectedItem();
        this.formattedTextFieldZoomFactor.setVisible(false);
        this.comboBoxPixelZoomFactors.setVisible(false);
        if (object != null && object instanceof PresentationSizeModeWrapper) {
            if (((PresentationSizeModeWrapper)object).getZoomMode() == ZoomMode.NORMAL) {
                this.formattedTextFieldZoomFactor.setVisible(true);
            } else if (((PresentationSizeModeWrapper)object).getZoomMode() == ZoomMode.PIXELIDENTITY) {
                this.comboBoxPixelZoomFactors.setVisible(true);
            }
        }
    }

    public void setLayout(MainLayoutType mainLayoutType, String string) {
        this.panelGB.remove(this.panelDisplayLayoutButtons);
        this.panelGB.remove(this.panelFilmLayoutButtons);
        this.panelGB.remove(this.panelStripeLayout);
        if (mainLayoutType == MainLayoutType.variable) {
            this.panelGB.add((Component)this.panelDisplayLayoutButtons, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
            int n = this.getIndexOfVariableLayout(string);
            this.buttonGroupDisplayLayout.clearSelection();
            if (n >= 0) {
                this.displayLayoutButtons[n].setSelected(true);
                this.displayLayoutDropdown.setText(variableLayouts[n]);
            } else {
                this.displayLayoutDropdown.setText(string);
            }
        } else if (mainLayoutType == MainLayoutType.film) {
            this.panelGB.add((Component)this.panelFilmLayoutButtons, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
            int n = this.getIndexOfFilmLayout(string);
            if (this.buttonGroupFilmLayout.getSelection() != null) {
                this.buttonGroupFilmLayout.getSelection().setSelected(false);
            }
            if (n >= 0) {
                this.filmLayoutButtons[n].setSelected(true);
            } else {
                this.filmLayoutButtons[0].setSelected(true);
            }
        } else if (mainLayoutType == MainLayoutType.stripe) {
            this.panelGB.add((Component)this.panelStripeLayout, new GridBagConstraints(1, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.labelStripeColsInfo.setText(string == null ? "1x1" : ScreenSettingsPanel.correctStripeCols(string));
        }
        this.screenLayoutType = mainLayoutType;
        this.storeHorizontalXVertical();
    }

    public void init(IDisplayLayoutDefinition iDisplayLayoutDefinition) {
        if (iDisplayLayoutDefinition != null) {
            PluginName pluginName = PluginName.getItemWithName(iDisplayLayoutDefinition.getPluginName());
            this.comboBoxPlugin.setSelectedItem((Object)(pluginName != null ? pluginName : PluginName.DEFAULT));
            this.enableDisplayStateComponents(this.comboBoxPlugin.getSelectedItem() == PluginName.DEFAULT);
            this.setLayout(this.screenLayoutType, iDisplayLayoutDefinition.getHorizontalXVertical());
            IDisplayState iDisplayState = iDisplayLayoutDefinition.getDisplayState();
            if (iDisplayState != null) {
                this.comboBoxFilter.setSelectedItem((Object)FilterActions.FilterType.parse(iDisplayState.getFilterName()));
                this.comboBoxPresentationSizeMode.setSelectedItem(iDisplayState.getZoomMode() != null ? this.getWrapperForPresentationSizeMode(iDisplayState.getZoomMode()) : this.getWrapperForPresentationSizeMode(ZoomMode.NORMAL));
                this.formattedTextFieldZoomFactor.setEnabled(iDisplayState.getZoomMode() != ZoomMode.TRUESIZE);
                this.comboBoxPixelZoomFactors.setSelectedIndex(zfr[(int)Math.min(Math.max(0.0, iDisplayState.getMagnificationRatio()), 8.0)]);
                this.formattedTextFieldZoomFactor.setValue(iDisplayState.getMagnificationRatio());
                this.formattedTextViewPortCenterX.setValue(iDisplayState.getViewPortCenterX());
                this.formattedTextViewPortCenterY.setValue(iDisplayState.getViewPortCenterY());
                this.checkBoxHorizontalFlip.setSelected(iDisplayState.getImageHorizontalFlip() != null ? iDisplayState.getImageHorizontalFlip() : false);
                this.checkBoxInverted.setSelected(iDisplayState.getImageInvert() != null ? iDisplayState.getImageInvert() : false);
                this.checkBoxLocalizer.setSelected(iDisplayState.getLocalizerEnabled() != null ? iDisplayState.getLocalizerEnabled() : false);
                this.checkBoxSynced.setSelected(iDisplayState.getSynced() != null ? iDisplayState.getSynced() : false);
                this.sliderScrollingPosition.setValue(iDisplayState.getScrollPosition() != null ? (int)(100.0 * iDisplayState.getScrollPosition() + 0.5) : 0);
                this.currentScrollingPosition = iDisplayState.getScrollPosition() != null ? iDisplayState.getScrollPosition() : 0.0;
                this.jumpToFirstKeyImage.setSelected(Boolean.TRUE.equals(iDisplayState.getJumpToFirstKeyImage()));
                this.keyImageOverviewCBox.setSelectedItem((Object)KeyImageOverviewType.getForStudyIndex(iDisplayState.getKeyImageOverviewStudyIndex()));
                Integer n = iDisplayState.getImageRotation();
                if (n != null) {
                    int n2 = 0;
                    int n3 = n % 360 / 90 * 90;
                    int n4 = 1;
                    while (n4 < degrees.length) {
                        if (degrees[n4] == n3) {
                            n2 = n4;
                            break;
                        }
                        ++n4;
                    }
                    this.comboBoxRotation.setSelectedIndex(n2);
                } else {
                    this.comboBoxRotation.setSelectedIndex(0);
                }
                this.formattedTextWindowCenter.setValue(iDisplayState.getWindowCenter());
                this.formattedTextWindowWidth.setValue(iDisplayState.getWindowWidth());
                this.setWindowingComponentsVisible(iDisplayState.getUseWindowLevel());
                this.checkBoxStoreWindowLevel.setSelected(iDisplayState.getUseWindowLevel());
            } else {
                this.comboBoxPresentationSizeMode.setSelectedItem(this.getWrapperForPresentationSizeMode(ZoomMode.NORMAL));
                this.formattedTextFieldZoomFactor.setEnabled(false);
                this.formattedTextFieldZoomFactor.setValue(Float.valueOf(1.0f));
                this.comboBoxPixelZoomFactors.setSelectedIndex(0);
                this.formattedTextViewPortCenterX.setValue(0.0);
                this.formattedTextViewPortCenterY.setValue(0.0);
                this.checkBoxHorizontalFlip.setSelected(false);
                this.checkBoxInverted.setSelected(false);
                this.checkBoxLocalizer.setSelected(false);
                this.checkBoxSynced.setSelected(false);
                this.comboBoxRotation.setSelectedIndex(0);
                this.formattedTextWindowCenter.setValue(null);
                this.formattedTextWindowWidth.setValue(null);
                this.setWindowingComponentsVisible(true);
                this.checkBoxStoreWindowLevel.setSelected(true);
                this.sliderScrollingPosition.setValue(0);
                this.jumpToFirstKeyImage.setSelected(false);
                this.keyImageOverviewCBox.setSelectedItem((Object)KeyImageOverviewType.NO);
            }
        } else {
            this.comboBoxPlugin.setSelectedItem((Object)PluginName.DEFAULT);
            this.comboBoxFilter.setSelectedItem((Object)FilterActions.FilterType.None);
            this.setLayout(this.screenLayoutType, null);
        }
    }

    private void enableDisplayStateComponents(boolean bl) {
        JToggleButton jToggleButton;
        boolean bl2 = this.comboBoxPlugin.getSelectedItem() == PluginName.MAMMO2;
        this.comboBoxPresentationSizeMode.setEnabled(bl || bl2);
        this.formattedTextFieldZoomFactor.setEnabled(bl || bl2);
        this.comboBoxPixelZoomFactors.setEnabled(bl);
        this.formattedTextViewPortCenterX.setEnabled(bl);
        this.formattedTextViewPortCenterY.setEnabled(bl);
        this.checkBoxHorizontalFlip.setEnabled(bl || bl2);
        this.checkBoxSynced.setEnabled(bl || bl2);
        this.checkBoxLocalizer.setEnabled(bl);
        this.comboBoxRotation.setEnabled(bl);
        this.formattedTextWindowCenter.setEnabled(bl);
        this.formattedTextWindowWidth.setEnabled(bl);
        this.checkBoxStoreWindowLevel.setEnabled(bl);
        this.sliderScrollingPosition.setEnabled(bl);
        this.jumpToFirstKeyImage.setEnabled(bl);
        JToggleButton[] jToggleButtonArray = this.filmLayoutButtons;
        int n = this.filmLayoutButtons.length;
        int n2 = 0;
        while (n2 < n) {
            jToggleButton = jToggleButtonArray[n2];
            jToggleButton.setEnabled(bl);
            ++n2;
        }
        jToggleButtonArray = this.displayLayoutButtons;
        n = this.displayLayoutButtons.length;
        n2 = 0;
        while (n2 < n) {
            jToggleButton = jToggleButtonArray[n2];
            jToggleButton.setEnabled(bl);
            ++n2;
        }
    }

    private int getIndexOfVariableLayout(String string) {
        int n = 0;
        while (n < variableLayouts.length) {
            if (variableLayouts[n].equalsIgnoreCase(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private int getIndexOfFilmLayout(String string) {
        int n = 0;
        while (n < filmLayouts.length) {
            if (filmLayouts[n].equalsIgnoreCase(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void setStripeDisplayLayout(String string) {
        this.labelStripeColsInfo.setText(string);
    }

    private void storeHorizontalXVertical() {
        String string = this.displayLayout.getHorizontalXVertical();
        if (this.screenLayoutType == MainLayoutType.film) {
            int n = 0;
            while (n < this.filmLayoutButtons.length) {
                if (this.filmLayoutButtons[n].isSelected() && !filmLayouts[n].equalsIgnoreCase(string)) {
                    this.displayLayout.setHorizontalXVertical(filmLayouts[n]);
                    this.informListener();
                    break;
                }
                ++n;
            }
        } else if (this.screenLayoutType == MainLayoutType.stripe) {
            if (!this.labelStripeColsInfo.getText().equalsIgnoreCase(string)) {
                this.displayLayout.setHorizontalXVertical(this.labelStripeColsInfo.getText());
                this.informListener();
            }
        } else {
            String string2;
            boolean bl = false;
            int n = 0;
            while (n < this.displayLayoutButtons.length) {
                if (this.displayLayoutButtons[n].isSelected() && !variableLayouts[n].equalsIgnoreCase(string)) {
                    this.displayLayout.setHorizontalXVertical(variableLayouts[n]);
                    this.displayLayoutDropdown.setText(variableLayouts[n]);
                    bl = true;
                    this.informListener();
                    break;
                }
                ++n;
            }
            if (!(bl || (string2 = this.displayLayoutDropdown.getText()) == null || string2.isEmpty() || string2.equals(string))) {
                this.displayLayout.setHorizontalXVertical(string2);
                this.buttonGroupDisplayLayout.clearSelection();
                int n2 = this.getIndexOfVariableLayout(string2);
                if (n2 >= 0) {
                    this.displayLayoutButtons[n2].setSelected(true);
                    this.informListener();
                }
            }
        }
    }

    private void storeUseWindowLevel() {
        Boolean bl = this.displayState.getUseWindowLevel();
        Boolean bl2 = this.checkBoxStoreWindowLevel.isSelected();
        if (!bl2.equals(bl)) {
            this.displayState.setUseWindowLevel(bl2);
            this.informListener();
        }
    }

    private void storeImageRotation() {
        Integer n = this.displayState.getImageRotation();
        Integer n2 = 0;
        int n3 = this.comboBoxRotation.getSelectedIndex();
        if (n3 >= 0 && n3 < degrees.length) {
            n2 = degrees[n3];
        }
        if (!n2.equals(n)) {
            this.displayState.setImageRotation(n2);
            this.informListener();
        }
    }

    private void storeViewPortCenterY() {
        Double d = this.displayState.getViewPortCenterY();
        Double d2 = 0.0;
        Object object = this.formattedTextViewPortCenterY.getValue();
        if (object != null && object instanceof Number) {
            Number number = (Number)object;
            d2 = number.doubleValue();
        }
        if (!d2.equals(d)) {
            this.displayState.setViewPortCenterY(d2);
            this.informListener();
        }
    }

    private void storeViewPortCenterX() {
        Double d = this.displayState.getViewPortCenterX();
        Double d2 = 0.0;
        Object object = this.formattedTextViewPortCenterX.getValue();
        if (object != null && object instanceof Number) {
            Number number = (Number)object;
            d2 = number.doubleValue();
        }
        if (!d2.equals(d)) {
            this.displayState.setViewPortCenterX(d2);
            this.informListener();
        }
    }

    private void storeHorizontalFlip() {
        Boolean bl = this.displayState.getImageHorizontalFlip();
        Boolean bl2 = this.checkBoxHorizontalFlip.isSelected();
        if (!bl2.equals(bl)) {
            this.displayState.setImageHorizontalFlip(bl2);
            this.informListener();
        }
    }

    private void storeInverted() {
        Boolean bl = this.displayState.getImageInvert();
        Boolean bl2 = this.checkBoxInverted.isSelected();
        if (!bl2.equals(bl)) {
            this.displayState.setImageInvert(bl2);
            this.informListener();
        }
    }

    void storeLocalizer() {
        Boolean bl = this.displayState.getLocalizerEnabled();
        Boolean bl2 = this.checkBoxLocalizer.isSelected();
        if (!bl2.equals(bl)) {
            this.displayState.setLocalizerEnabled(bl2);
            this.informListener();
        }
    }

    private void storeWindowWidth() {
        Double d = this.displayState.getWindowWidth();
        Object object = this.formattedTextWindowWidth.getValue();
        if (object != null && object instanceof Number) {
            Number number = (Number)object;
            Double d2 = number.doubleValue();
            if (!d2.equals(d)) {
                this.displayState.setWindowWidth(d2);
                this.informListener();
            }
        } else if (d != null) {
            this.displayState.setWindowWidth(null);
            this.informListener();
        }
    }

    private void storeWindowCenter() {
        Double d = this.displayState.getWindowCenter();
        Object object = this.formattedTextWindowCenter.getValue();
        if (object != null && object instanceof Number) {
            Number number = (Number)object;
            Double d2 = number.doubleValue();
            if (!d2.equals(d)) {
                this.displayState.setWindowCenter(d2);
                this.informListener();
            }
        } else if (d != null) {
            this.displayState.setWindowCenter(null);
            this.informListener();
        }
    }

    private void storeSynced() {
        Boolean bl = this.displayState.getSynced();
        Boolean bl2 = this.checkBoxSynced.isSelected();
        if (!bl2.equals(bl)) {
            this.displayState.setSynced(bl2);
            this.informListener();
        }
    }

    private void storePluginName() {
        String string = this.displayLayout.getPluginName();
        Object object = this.comboBoxPlugin.getSelectedItem();
        if (object != null && object instanceof PluginName) {
            String string2 = ((PluginName)((Object)object)).getPluginName();
            if (!string2.equals(string)) {
                this.displayLayout.setPluginName(string2);
                this.informListener();
            }
        } else if (string != null) {
            this.displayLayout.setPluginName(null);
            this.informListener();
        }
    }

    void storeFilterName() {
        String string = this.displayState.getFilterName();
        Object object = this.comboBoxFilter.getSelectedItem();
        if (object instanceof FilterActions.FilterType) {
            String string2 = ((FilterActions.FilterType)((Object)object)).name();
            if (!string2.equals(string)) {
                this.displayState.setFilterName(string2);
                this.informListener();
            }
        } else if (string != null) {
            this.displayState.setFilterName(null);
            this.informListener();
        }
    }

    private void storeScrollingPosition() {
        Double d = this.displayState.getScrollPosition();
        Double d2 = this.currentScrollingPosition;
        if (!d2.equals(d)) {
            this.displayState.setScrollPosition(d2);
            this.informListener();
        }
    }

    void storeJumpToFirstKeyImage() {
        Boolean bl = this.displayState.getJumpToFirstKeyImage();
        Boolean bl2 = this.jumpToFirstKeyImage.isSelected();
        if (!bl2.equals(bl)) {
            this.displayState.setJumpToFirstKeyImage(bl2);
            this.informListener();
        }
    }

    private void storeZoomMode() {
        ZoomMode zoomMode = this.displayState.getZoomMode();
        Double d = this.displayState.getMagnificationRatio();
        ZoomMode zoomMode2 = ZoomMode.NORMAL;
        Double d2 = 0.0;
        Object object = this.comboBoxPresentationSizeMode.getSelectedItem();
        if (object != null && object instanceof PresentationSizeModeWrapper) {
            int n;
            zoomMode2 = ((PresentationSizeModeWrapper)object).getZoomMode();
            if (zoomMode2 == ZoomMode.NORMAL) {
                Object object2 = this.formattedTextFieldZoomFactor.getValue();
                if (object2 != null && object2 instanceof Number) {
                    Number number = (Number)object2;
                    d2 = number.doubleValue();
                }
            } else if (zoomMode2 == ZoomMode.PIXELIDENTITY && (n = this.comboBoxPixelZoomFactors.getSelectedIndex()) >= 0) {
                d2 = pixelZoomFactors[n];
            }
        }
        boolean bl = false;
        if (zoomMode != zoomMode2) {
            bl = true;
            this.displayState.setZoomMode(zoomMode2);
        }
        if (!d2.equals(d)) {
            bl = true;
            this.displayState.setMagnificationRatio(d2);
        }
        if (bl) {
            this.informListener();
        }
    }

    public PresentationSizeModeWrapper getWrapperForPresentationSizeMode(ZoomMode zoomMode) {
        for (PresentationSizeModeWrapper presentationSizeModeWrapper : this.wrappers) {
            if (presentationSizeModeWrapper.getZoomMode() != zoomMode) continue;
            return presentationSizeModeWrapper;
        }
        return null;
    }

    private void informListener() {
        if (this.listener != null) {
            this.listener.hangingChanged();
        }
    }

    private static class EmptyStringNumberFormatter
    extends Format {
        private Format delegate;

        public EmptyStringNumberFormatter(Format format) {
            this.delegate = format;
        }

        @Override
        public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
            if (object != null && object instanceof String && ((String)object).trim().length() == 0) {
                return new StringBuffer();
            }
            return this.delegate.format(object, stringBuffer, fieldPosition);
        }

        @Override
        public Object parseObject(String string) throws ParseException {
            ParsePosition parsePosition = new ParsePosition(0);
            Object object = this.parseObject(string, parsePosition);
            if (parsePosition.getIndex() == 0) {
                throw new ParseException("Format.parseObject(String) failed", parsePosition.getErrorIndex());
            }
            return object;
        }

        @Override
        public Object parseObject(String string, ParsePosition parsePosition) {
            if (string == null || string.trim().length() == 0) {
                parsePosition.setIndex(-1);
                return null;
            }
            return this.delegate.parseObject(string, parsePosition);
        }
    }

    private static enum KeyImageOverviewType {
        NO(-1),
        BASE(0),
        PRIOR1(1),
        PRIOR2(2),
        PRIOR3(3),
        PRIOR4(4),
        PRIOR5(5);

        private int studyIndex;

        private KeyImageOverviewType(int n2) {
            this.studyIndex = n2;
        }

        public static KeyImageOverviewType getForStudyIndex(Integer n) {
            if (n != null) {
                KeyImageOverviewType[] keyImageOverviewTypeArray = KeyImageOverviewType.values();
                int n2 = keyImageOverviewTypeArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    KeyImageOverviewType keyImageOverviewType = keyImageOverviewTypeArray[n3];
                    if (keyImageOverviewType.studyIndex == n) {
                        return keyImageOverviewType;
                    }
                    ++n3;
                }
            }
            return NO;
        }

        public int getStudyIndex() {
            return this.studyIndex;
        }

        public String toString() {
            return Messages.getString("DisplaySettingsPanel.KeyImageOverviewType." + this.name().toUpperCase());
        }
    }

    private static class PresentationSizeModeWrapper {
        private ZoomMode zoomMode;

        public PresentationSizeModeWrapper(ZoomMode zoomMode) {
            this.zoomMode = zoomMode;
        }

        public String toString() {
            return this.zoomMode.getDescription();
        }

        public ZoomMode getZoomMode() {
            return this.zoomMode;
        }
    }
}

