/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.hanging.gui;

import com.agfa.pacs.base.swing.util.EventUtil;
import com.agfa.pacs.data.shared.store.IStoreHandler;
import com.agfa.pacs.data.shared.worklist.IWorklistContext;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PActionRegistry;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.data.fetcher.IPerform;
import com.agfa.pacs.impaxee.data.fetcher.IStore;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.hanging.IHanging;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.impaxee.hanging.gui.IUnsavedDataCollector;
import com.agfa.pacs.impaxee.hanging.gui.UnsavedDataCollectorFactory;
import com.agfa.pacs.impaxee.hanging.gui.UnsavedDataDialog;
import com.agfa.pacs.impaxee.hanging.gui.UnsavedDataElement;
import com.agfa.pacs.impaxee.hanging.gui.UnsavedSelectableDataElement;
import com.agfa.pacs.impaxee.hanging.model.PatientsUnsavedDataMapping;
import com.agfa.pacs.impaxee.keyimages.KeyImageInfo;
import com.agfa.pacs.impaxee.keyimages.KeyImageManager;
import com.agfa.pacs.impaxee.keyimages.KeyImageType;
import com.agfa.pacs.impaxee.keyimages.SaveKeyImagesItemFactory;
import com.agfa.pacs.impaxee.presentationstate.PresentationStateUnsavedItem;
import com.agfa.pacs.impaxee.presentationstate.TemporaryPresentationStateUnsavedItemFactory;
import com.agfa.pacs.impaxee.save.ISaveItem;
import com.agfa.pacs.impaxee.sessions.gui.WorklistChooser;
import com.agfa.pacs.listtext.dicomobject.presentationstate.IPresentationStateInfo;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.base.data.IPatientData;
import com.tiani.base.data.ISeriesData;
import com.tiani.base.data.IStudyData;
import com.tiani.jvision.image.View;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.main.SecondaryCaptureUnsavedItem;
import com.tiani.jvision.overlay.Overlay;
import com.tiani.jvision.plugin.PluginName;
import com.tiani.jvision.util.StorageLicense;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.jvision.vis.VisScreen2;
import com.tiani.util.message.Message;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;

public class UnsavedHangingsManager {
    private static final ALogger log = ALogger.getLogger(UnsavedHangingsManager.class);
    private static final EnumSet<PluginName> PLUGINS_SUPPORTED_MARKUPS_STORAGE = EnumSet.of(PluginName.DEFAULT, PluginName.MAMMO2);
    private static final PAction STORE_PS_ACTION = PActionRegistry.getAction("STORE_PRESENTATION_STATE");
    private UnsavedDataDialog dialog;
    private final List<IStoreHandler> storeHandlers = new ArrayList<IStoreHandler>();

    public boolean manageSave(JFrame jFrame, IPatientRepresentation iPatientRepresentation, IStudyData iStudyData) {
        return this.manageSave(jFrame, iPatientRepresentation, iStudyData, false);
    }

    public boolean manageSave(JFrame jFrame, IPatientRepresentation iPatientRepresentation, IStudyData iStudyData, boolean bl) {
        long l = Config.impaxee.jvision.MAIN.saveUnsavedDataOnRemovePatient.get();
        if (l == 2L) {
            return true;
        }
        PatientsUnsavedDataMapping patientsUnsavedDataMapping = this.collectUnsavedData(jFrame, iPatientRepresentation, iStudyData);
        if (patientsUnsavedDataMapping == null) {
            return true;
        }
        List<IFrameObjectData> list = this.collectUnsavedKeyImages(iPatientRepresentation, iStudyData, KeyImageType.ForConference);
        boolean bl2 = false;
        if (l == 0L) {
            if (!bl && !this.checkAllDataSaveable(patientsUnsavedDataMapping)) {
                Message.warning(Messages.getString("UnsavedHangingsManager.SaveUnsavedItems"), Messages.getString("UnsavedHangingsManager.AutoSaveNotPossible"));
                bl2 = this.displaySaveDialog(jFrame, patientsUnsavedDataMapping);
            } else {
                bl2 = this.saveHangings(patientsUnsavedDataMapping);
            }
        } else if (l == 1L) {
            boolean bl3 = bl2 = bl || this.displaySaveDialog(jFrame, patientsUnsavedDataMapping);
        }
        if (bl2 && !list.isEmpty() && this.unsavedKeyImagesSaved(list, KeyImageType.ForConference)) {
            this.addToWorklists(list);
        }
        return bl2;
    }

    private boolean displaySaveDialog(JFrame jFrame, PatientsUnsavedDataMapping patientsUnsavedDataMapping) {
        this.dialog = new UnsavedDataDialog((Frame)jFrame, patientsUnsavedDataMapping);
        this.dialog.setVisible(true);
        for (ISaveItem iSaveItem : this.dialog.getSaveItems()) {
            List<IStoreHandler> list = iSaveItem.getStoreHandlers();
            if (list == null) continue;
            this.storeHandlers.addAll(list);
        }
        return this.dialog.getDialogResult() != 2;
    }

    private boolean checkAllDataSaveable(PatientsUnsavedDataMapping patientsUnsavedDataMapping) {
        List<UnsavedDataElement> list = patientsUnsavedDataMapping.getAllUnsavedData();
        for (UnsavedDataElement unsavedDataElement : list) {
            ISaveItem iSaveItem = unsavedDataElement.getSaveItem();
            if (iSaveItem.isSaveable()) continue;
            return false;
        }
        return true;
    }

    private PatientsUnsavedDataMapping collectUnsavedData(JFrame jFrame, IPatientRepresentation iPatientRepresentation, IStudyData iStudyData) {
        PatientsUnsavedDataMapping patientsUnsavedDataMapping = new PatientsUnsavedDataMapping();
        if (Config.impaxee.jvision.MAIN.saveUnsavedSession.get()) {
            this.collectUnsavedSessions(iPatientRepresentation, iStudyData, patientsUnsavedDataMapping);
        }
        if (Config.impaxee.jvision.MAIN.saveUnsavedSecondaryCaptures.get()) {
            this.collectUnsavedSC(iPatientRepresentation, iStudyData, patientsUnsavedDataMapping);
        }
        if (Config.impaxee.jvision.MAIN.saveUnsavedMarkups.get()) {
            this.collectUnsavedPresentationStates(iPatientRepresentation, iStudyData, patientsUnsavedDataMapping);
        }
        if (Config.impaxee.jvision.MAIN.saveUnsavedKeyImages.get()) {
            this.collectUnsavedKeyImages(iPatientRepresentation, iStudyData, patientsUnsavedDataMapping);
        }
        for (IUnsavedDataCollector iUnsavedDataCollector : UnsavedDataCollectorFactory.getInstance().getUnsavedDataCollectors()) {
            iUnsavedDataCollector.collectUnsavedData(iPatientRepresentation, iStudyData, patientsUnsavedDataMapping);
        }
        return patientsUnsavedDataMapping.size() > 0 ? patientsUnsavedDataMapping : null;
    }

    private void collectUnsavedSessions(IPatientRepresentation iPatientRepresentation, IStudyData iStudyData, PatientsUnsavedDataMapping patientsUnsavedDataMapping) {
        Map<IPatientRepresentation, List<IHanging>> map = DataManager.getInstance().getUnsavedHangings();
        if (map != null) {
            for (IPatientRepresentation iPatientRepresentation2 : map.keySet()) {
                if (iPatientRepresentation != null && iPatientRepresentation2 != iPatientRepresentation) continue;
                List<IHanging> list = map.get(iPatientRepresentation2);
                for (IHanging iHanging : list) {
                    if (iStudyData != null && iHanging.getStudyContainer().getBaseStudy() != iStudyData) continue;
                    UnsavedSelectableDataElement unsavedSelectableDataElement = new UnsavedSelectableDataElement(iHanging, iPatientRepresentation2);
                    patientsUnsavedDataMapping.put(iPatientRepresentation2, unsavedSelectableDataElement);
                }
            }
        }
    }

    private void collectUnsavedSC(IPatientRepresentation iPatientRepresentation, IStudyData iStudyData, PatientsUnsavedDataMapping patientsUnsavedDataMapping) {
        if (StorageLicense.canStoreSC()) {
            List<IStudyData> list = this.getLoadedStudies(iPatientRepresentation, iStudyData);
            for (IStudyData iStudyData2 : list) {
                IPatientRepresentation iPatientRepresentation2 = DataManager.getInstance().getPatientRepresentation(iStudyData2.getParent().getKey());
                List<ISeriesData> list2 = iStudyData2.getSeries();
                for (ISeriesData iSeriesData : list2) {
                    if (iSeriesData.isSecondaryCaptureSaved() || iSeriesData.isSetLiveSecondaryCapture()) continue;
                    UnsavedDataElement unsavedDataElement = this.createSecondaryCaptureUnsavedItem(iSeriesData, iPatientRepresentation2);
                    patientsUnsavedDataMapping.put(iPatientRepresentation2, unsavedDataElement);
                }
            }
        }
    }

    private void collectUnsavedKeyImages(IPatientRepresentation iPatientRepresentation, IStudyData iStudyData, PatientsUnsavedDataMapping patientsUnsavedDataMapping) {
        List<IStudyData> list = this.getLoadedStudies(iPatientRepresentation, iStudyData);
        if (list != null) {
            for (IStudyData iStudyData2 : list) {
                KeyImageType[] keyImageTypeArray = KeyImageManager.getInstance().getModifiedTypesOfStudy(iStudyData2);
                if (keyImageTypeArray == null || keyImageTypeArray.length <= 0) continue;
                IPatientRepresentation iPatientRepresentation2 = DataManager.getInstance().getPatientRepresentation(iStudyData2.getParent().getKey());
                patientsUnsavedDataMapping.put(iPatientRepresentation2, new UnsavedSelectableDataElement(new SaveKeyImagesItemFactory(iStudyData2), iPatientRepresentation2));
            }
        }
    }

    private List<IFrameObjectData> collectUnsavedKeyImages(IPatientRepresentation iPatientRepresentation, IStudyData iStudyData, KeyImageType keyImageType) {
        List<IStudyData> list;
        if (Config.impaxee.jvision.MAIN.saveUnsavedKeyImages.get() && (list = this.getLoadedStudies(iPatientRepresentation, iStudyData)) != null) {
            ArrayList<IFrameObjectData> arrayList = new ArrayList<IFrameObjectData>();
            KeyImageManager keyImageManager = KeyImageManager.getInstance();
            for (IStudyData iStudyData2 : list) {
                List<IFrameObjectData> list2;
                KeyImageType[] keyImageTypeArray = keyImageManager.getModifiedTypesOfStudy(iStudyData2);
                if (keyImageTypeArray == null || !Arrays.asList(keyImageTypeArray).contains((Object)keyImageType) || (list2 = keyImageManager.getKeyImagesOfStudy(iStudyData2, keyImageType)) == null) continue;
                for (IFrameObjectData iFrameObjectData : list2) {
                    if (!keyImageManager.isModified(iFrameObjectData)) continue;
                    arrayList.add(iFrameObjectData);
                }
            }
            return arrayList;
        }
        return Collections.emptyList();
    }

    private boolean unsavedKeyImagesSaved(Collection<IFrameObjectData> collection, KeyImageType keyImageType) {
        KeyImageManager keyImageManager = KeyImageManager.getInstance();
        if (collection != null) {
            for (IFrameObjectData iFrameObjectData : collection) {
                KeyImageInfo keyImageInfo;
                if (!(keyImageType != null ? (keyImageInfo = keyImageManager.getKeyInfo(iFrameObjectData)) != null && keyImageInfo.isModified(keyImageType) : keyImageManager.isModified(iFrameObjectData))) continue;
                return false;
            }
        }
        return true;
    }

    private void addToWorklists(final Collection<IFrameObjectData> collection) {
        if (collection == null || collection.isEmpty()) {
            return;
        }
        try {
            IPerform iPerform;
            Collection<IWorklistContext> collection2;
            IStore iStore = DataManager.getInstance().getDataStore();
            ArrayList<IWorklistContext> arrayList = new ArrayList<IWorklistContext>(iStore.getAvailableWorklistContexts());
            WorklistChooser worklistChooser = new WorklistChooser(JVision2.getMainFrame(), arrayList, null);
            if ("OK_OPTION".equals(worklistChooser.getDialogResult()) && (collection2 = worklistChooser.getSelectedWorklistContexts()) != null && !collection2.isEmpty() && (iPerform = DataManager.getInstance().getDataPerform("ADD_TO_WORKLIST")) != null) {
                EventUtil.invokeNotOnEDT((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        iPerform.perform(new IPerform.DefaultPerformContext(JVision2.getMainFrame(), collection2), collection);
                    }
                });
            }
        }
        catch (Exception exception) {
            log.error("Adding marked images to worklist(s) failed!", (Throwable)exception);
        }
    }

    private List<IStudyData> getLoadedStudies(IPatientRepresentation iPatientRepresentation, IStudyData iStudyData) {
        ArrayList<IStudyData> arrayList = new ArrayList<IStudyData>();
        if (iPatientRepresentation == null) {
            arrayList.addAll(DataManager.getInstance().getAllStudies());
        } else if (iStudyData == null) {
            IPatientData iPatientData = DataManager.getInstance().getLoadedPatientData(iPatientRepresentation.getPatientKey());
            if (iPatientData != null) {
                arrayList.addAll(iPatientData.getStudies());
            }
        } else {
            arrayList.add(DataManager.getInstance().getStudy(iStudyData.getKey()));
        }
        return arrayList;
    }

    private UnsavedDataElement createSecondaryCaptureUnsavedItem(ISeriesData iSeriesData, IPatientRepresentation iPatientRepresentation) {
        IPerform iPerform = DataManager.getInstance().getDataPerform("EXPORT_SC_DIRECT");
        boolean bl = iPerform.canInferStoreTargetNode(iSeriesData.getParent());
        UnsavedDataElement unsavedDataElement = null;
        unsavedDataElement = bl ? new UnsavedSelectableDataElement(new SecondaryCaptureUnsavedItem(iSeriesData, false), iPatientRepresentation) : new UnsavedDataElement(new SecondaryCaptureUnsavedItem(iSeriesData, true), iPatientRepresentation);
        return unsavedDataElement;
    }

    private void collectUnsavedPresentationStates(IPatientRepresentation iPatientRepresentation, IStudyData iStudyData, PatientsUnsavedDataMapping patientsUnsavedDataMapping) {
        Object object;
        VisDisplay2 visDisplay2;
        if (!STORE_PS_ACTION.isAvailable()) {
            return;
        }
        List<IStudyData> list = this.getLoadedStudies(iPatientRepresentation, iStudyData);
        if (list == null || list.isEmpty()) {
            return;
        }
        List<VisScreen2> list2 = JVision2.getMainFrame().getScreens();
        int n = 0;
        while (n < list2.size()) {
            VisScreen2 visScreen2 = list2.get(n);
            List<VisDisplay2> list3 = visScreen2.getDisplays();
            int n2 = 0;
            while (n2 < list3.size()) {
                visDisplay2 = list3.get(n2);
                if ((iPatientRepresentation == null || visDisplay2.getData().getPatientRepresentation() == iPatientRepresentation) && ((object = visDisplay2.getData().getPlugin()) == null || PLUGINS_SUPPORTED_MARKUPS_STORAGE.contains((Object)object.getPluginName())) && this.existUnsavedMarkups(visDisplay2, list)) {
                    patientsUnsavedDataMapping.put(visDisplay2.getData().getPatientRepresentation(), new UnsavedSelectableDataElement(new PresentationStateUnsavedItem(visDisplay2, n, n2), iPatientRepresentation));
                }
                ++n2;
            }
            ++n;
        }
        for (IStudyData iStudyData2 : list) {
            int n3 = this.getMaxSeriesNumber(iStudyData2);
            IPatientRepresentation iPatientRepresentation2 = DataManager.getInstance().getPatientRepresentation(iStudyData2.getParent().getKey());
            visDisplay2 = iStudyData2.getFramePresentationStateProviderContainer();
            object = visDisplay2.getAllPresentationStateInfos();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                IPresentationStateInfo iPresentationStateInfo = (IPresentationStateInfo)iterator.next();
                if (!iPresentationStateInfo.containsUnsavedGraphicAnnotations()) continue;
                Attributes attributes = iPresentationStateInfo.getDataset();
                attributes.setInt(0x200011, VR.IS, new int[]{++n3});
                patientsUnsavedDataMapping.put(iPatientRepresentation2, new UnsavedSelectableDataElement(new TemporaryPresentationStateUnsavedItemFactory(iStudyData2, attributes), iPatientRepresentation2));
            }
        }
    }

    private int getMaxSeriesNumber(IStudyData iStudyData) {
        int n = 0;
        for (ISeriesData iSeriesData : iStudyData.getSeries()) {
            int n2 = iSeriesData.getDicomObject().getInt(0x200011, 0);
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    private boolean existUnsavedMarkups(VisDisplay2 visDisplay2, List<IStudyData> list) {
        for (VisData visData : visDisplay2.getVis()) {
            if (visData == null || visData.getView() == null || !this.isMatchingStudy(visData, list)) continue;
            View view = visData.getView();
            if (view.hasRemovedPO()) {
                return true;
            }
            for (Overlay overlay : view.getOverlays()) {
                if (!overlay.isUnsavedROI()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isMatchingStudy(VisData visData, List<IStudyData> list) {
        return visData != null && list.contains(visData.getStudyData());
    }

    private boolean saveHangings(PatientsUnsavedDataMapping patientsUnsavedDataMapping) {
        if (patientsUnsavedDataMapping == null || patientsUnsavedDataMapping.size() == 0) {
            return true;
        }
        boolean bl = true;
        List<UnsavedDataElement> list = patientsUnsavedDataMapping.getAllUnsavedData();
        for (UnsavedDataElement unsavedDataElement : list) {
            ISaveItem iSaveItem = unsavedDataElement.getSaveItem();
            if (iSaveItem == null || !(unsavedDataElement instanceof UnsavedSelectableDataElement)) continue;
            bl = iSaveItem.isSaveable() && iSaveItem.save(true) && bl;
            List<IStoreHandler> list2 = iSaveItem.getStoreHandlers();
            if (list2 == null) continue;
            this.storeHandlers.addAll(list2);
        }
        return bl;
    }

    public List<IStoreHandler> getStoreHandlers() {
        return this.storeHandlers;
    }
}

