/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.gui.chart;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.gui.chart.AutoLabelAxisData;
import com.agfa.pacs.impaxee.gui.chart.IAxisData;
import com.agfa.pacs.impaxee.gui.chart.IDataPoint;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.font.FontRenderContext;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Chart {
    private final List<IDataPoint[]> data = new ArrayList<IDataPoint[]>(4);
    private final List<Color> colors = new ArrayList<Color>(4);
    private final List<Boolean> dataPointFlags = new ArrayList<Boolean>(4);
    private final IAxisData xAxis;
    private final IAxisData yAxis;
    private boolean isInconsistent;
    private double scalingFactor = 1.0;
    private IDataPoint minimum;
    private IDataPoint maximum;

    public Chart(int n, int n2) {
        this((IAxisData)new AutoLabelAxisData(n), n2);
    }

    public IDataPoint getDataPoint(int n, int n2) {
        int n3 = this.scaleInt(7) / 2;
        Iterator<IDataPoint[]> iterator = this.data.iterator();
        while (iterator.hasNext()) {
            IDataPoint[] iDataPointArray;
            IDataPoint[] iDataPointArray2 = iDataPointArray = iterator.next();
            int n4 = iDataPointArray.length;
            int n5 = 0;
            while (n5 < n4) {
                IDataPoint iDataPoint = iDataPointArray2[n5];
                int n6 = this.xAxis.convertToPixelSpace(iDataPoint.getX());
                int n7 = this.yAxis.convertToPixelSpace(iDataPoint.getY());
                if (Math.abs(n6 - n) < n3 && Math.abs(n7 - n2) < n3) {
                    return iDataPoint;
                }
                ++n5;
            }
        }
        return null;
    }

    public Chart(IAxisData iAxisData, int n) {
        this(iAxisData, new AutoLabelAxisData(n));
    }

    public Chart(IAxisData iAxisData, IAxisData iAxisData2) {
        this.xAxis = iAxisData;
        this.yAxis = iAxisData2;
    }

    public void setInconsistent() {
        this.isInconsistent = true;
    }

    public void setScalingFactor(double d) {
        this.scalingFactor = d;
    }

    public IAxisData getXAxis() {
        return this.xAxis;
    }

    public IAxisData getYAxis() {
        return this.yAxis;
    }

    public void addChartLine(Color color, boolean bl, IDataPoint ... iDataPointArray) {
        if (iDataPointArray == null || iDataPointArray.length == 0) {
            throw new IllegalArgumentException("No data values given.");
        }
        if (iDataPointArray.length == 1) {
            throw new IllegalArgumentException("Only a single data point given.");
        }
        this.data.add(iDataPointArray);
        this.colors.add(color);
        this.dataPointFlags.add(bl);
        IDataPoint[] iDataPointArray2 = iDataPointArray;
        int n = iDataPointArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDataPoint iDataPoint = iDataPointArray2[n2];
            this.xAxis.registerDataValue(iDataPoint.getX());
            this.yAxis.registerDataValue(iDataPoint.getY());
            ++n2;
        }
    }

    public void setExtremumValues(IDataPoint iDataPoint, IDataPoint iDataPoint2) {
        this.minimum = iDataPoint;
        this.maximum = iDataPoint2;
    }

    public boolean isChartAvailable() {
        return !this.data.isEmpty() && !this.isInconsistent;
    }

    public void draw(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5;
        IDataPoint[] iDataPointArray;
        Font font = graphics.getFont();
        int n6 = this.scaleInt(font.getSize());
        graphics.setFont(font.deriveFont((float)n6));
        if (!this.isChartAvailable()) {
            String string = this.isInconsistent ? Messages.getString("Chart.InconsistentData") : Messages.getString("Chart.NoData");
            int n7 = graphics.getFontMetrics().stringWidth(string);
            graphics.drawString(string, (n + n3 - n7) / 2, (n2 + n4) / 2 + n6 * 3 / 2);
            return;
        }
        String string = this.xAxis.getUnit();
        String string2 = this.yAxis.getUnit();
        int n8 = n + this.scaleInt(70);
        int n9 = n4 - this.scaleInt(40);
        int n10 = n3 - this.scaleInt(60);
        int n11 = n2 + this.scaleInt(20);
        if (string2 != null) {
            n11 += this.scaleInt(10);
        }
        int n12 = n10 - n8;
        int n13 = n11 - n9;
        graphics.drawLine(n8, n9, n10, n9);
        graphics.drawLine(n8, n9, n8, n11);
        this.xAxis.setPixelRange(n8, n10);
        this.yAxis.setPixelRange(n9, n11);
        int n14 = this.scaleInt(5);
        int n15 = this.xAxis.getTickMarkCount();
        double d = (double)n12 / ((double)n15 - 1.0);
        int n16 = this.scaleInt(8);
        int n17 = 0;
        while (n17 < n15) {
            int n18 = (int)((double)n8 + (double)n17 * d);
            graphics.drawLine(n18, n9 - n14, n18, n9 + n14);
            graphics.drawString(this.xAxis.getTickMarkLabel(n17), n18 - n16, n9 + 2 * n6);
            ++n17;
        }
        if (string != null) {
            n17 = graphics.getFontMetrics().stringWidth(string);
            graphics.drawString(string, n3 - n17 - n14, n9 + n14);
        }
        n17 = this.yAxis.getTickMarkCount();
        double d2 = (double)n13 / ((double)n17 - 1.0);
        int n19 = this.scaleInt(50);
        int n20 = this.scaleInt(10);
        int n21 = 0;
        while (n21 < n17) {
            int n22 = (int)((double)n9 + (double)n21 * d2);
            graphics.drawLine(n8 - n14, n22, n8 + n14, n22);
            iDataPointArray = this.yAxis.getTickMarkLabel(n21);
            n5 = Math.min(graphics.getFontMetrics().stringWidth((String)iDataPointArray), n19) + n20;
            graphics.drawString((String)iDataPointArray, n8 - n5, n22 + n6 / 2);
            ++n21;
        }
        if (string2 != null) {
            n21 = graphics.getFontMetrics().stringWidth(string2);
            graphics.drawString(string2, n8 - n21 / 2, n2 + n6);
        }
        n21 = this.data.size() - 1;
        while (n21 >= 0) {
            Color color = graphics.getColor();
            graphics.setColor(this.colors.get(n21));
            iDataPointArray = this.data.get(n21);
            n5 = this.xAxis.convertToPixelSpace(iDataPointArray[0].getX());
            int n23 = this.yAxis.convertToPixelSpace(iDataPointArray[0].getY());
            if (this.dataPointFlags.get(n21).booleanValue()) {
                this.drawDataPoint(graphics, n5, n23);
            }
            int n24 = 1;
            while (n24 < iDataPointArray.length) {
                IDataPoint iDataPoint = iDataPointArray[n24];
                int n25 = this.xAxis.convertToPixelSpace(iDataPoint.getX());
                int n26 = this.yAxis.convertToPixelSpace(iDataPoint.getY());
                if (this.dataPointFlags.get(n21).booleanValue()) {
                    this.drawDataPoint(graphics, n25, n26);
                }
                graphics.drawLine(n5, n23, n25, n26);
                n5 = n25;
                n23 = n26;
                ++n24;
            }
            graphics.setColor(color);
            --n21;
        }
        if (this.minimum != null && this.maximum != null) {
            this.drawExtremum(graphics, this.minimum, true);
            this.drawExtremum(graphics, this.maximum, false);
        }
        graphics.setFont(font);
    }

    private void drawExtremum(Graphics graphics, IDataPoint iDataPoint, boolean bl) {
        DecimalFormat decimalFormat = new DecimalFormat("#0.0");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.valueOf(decimalFormat.format(iDataPoint.getY())));
        if (this.yAxis.getUnit() != null) {
            stringBuilder.append(" ");
            stringBuilder.append(this.yAxis.getUnit());
        }
        String string = stringBuilder.toString();
        Font font = graphics.getFont();
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        FontRenderContext fontRenderContext = fontMetrics.getFontRenderContext();
        float f = (float)font.getStringBounds(string, fontRenderContext).getHeight();
        int n = Math.round(f);
        int n2 = graphics.getFontMetrics().stringWidth(string);
        if (bl) {
            graphics.drawString(string, this.xAxis.convertToPixelSpace(this.xAxis.getMaximum()) - n2, this.yAxis.convertToPixelSpace(iDataPoint.getY()) + n);
        } else {
            graphics.drawString(string, this.xAxis.convertToPixelSpace(this.xAxis.getMaximum()) - n2, this.yAxis.convertToPixelSpace(iDataPoint.getY()) - 6);
        }
    }

    private void drawDataPoint(Graphics graphics, int n, int n2) {
        int n3 = this.scaleInt(7);
        int n4 = n3 / 2;
        int n5 = n - n4;
        int n6 = n2 - n4;
        if (n5 < 0 || n6 < 0) {
            graphics.fillOval(n, n2, n3, n3);
        } else {
            graphics.fillOval(n5, n6, n3, n3);
        }
    }

    private int scaleInt(int n) {
        return (int)((double)n * this.scalingFactor + 0.5);
    }
}

