/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.gsts;

import com.agfa.pacs.impaxee.gsts.IWindowPreset;
import com.agfa.pacs.listtext.dicomobject.module.ps.IVOILUT;
import com.agfa.pacs.logging.ALogger;
import java.util.ArrayList;

public class WindowLevelPreset
implements IWindowPreset {
    private static final ALogger LOGGER = ALogger.getLogger(WindowLevelPreset.class);
    private final double windowCenter;
    private final double windowWidth;
    private String explanation;

    private WindowLevelPreset(double d, double d2, String string) {
        this.windowCenter = d;
        this.windowWidth = d2;
        this.explanation = string;
    }

    public static WindowLevelPreset[] createList(IVOILUT iVOILUT) {
        if (iVOILUT == null || !iVOILUT.hasWindow()) {
            return null;
        }
        try {
            double[] dArray = iVOILUT.getWindowCenters();
            double[] dArray2 = iVOILUT.getWindowWidths();
            String[] stringArray = iVOILUT.getWindowExplanations();
            int n = dArray.length;
            ArrayList<WindowLevelPreset> arrayList = new ArrayList<WindowLevelPreset>(n);
            int n2 = 0;
            while (n2 < n) {
                arrayList.add(new WindowLevelPreset(dArray[n2], dArray2[n2], stringArray[n2]));
                ++n2;
            }
            return arrayList.toArray(new WindowLevelPreset[arrayList.size()]);
        }
        catch (Exception exception) {
            LOGGER.error("Parsing window level presets failed.", (Throwable)exception);
            return null;
        }
    }

    public double getWindowCenter() {
        return this.windowCenter;
    }

    public double getWindowWidth() {
        return this.windowWidth;
    }

    @Override
    public String getDescription() {
        return this.explanation;
    }

    @Override
    public void setDescription(String string) {
        this.explanation = string;
    }
}

