/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.descriptors.gui;

import com.agfa.pacs.base.swing.IComponentFactory;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.descriptors.Descriptor;
import com.agfa.pacs.impaxee.descriptors.DescriptorRegistry;
import com.agfa.pacs.impaxee.descriptors.gui.DescriptorEditPanel;
import com.tiani.gui.dialog.StandardDialog;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class DescriptorEditDialog
extends StandardDialog {
    private DescriptorEditPanel descriptorEditPanel;
    private Descriptor originalDescriptor;
    private Descriptor clonedDescriptor;

    public DescriptorEditDialog(JFrame jFrame, IComponentFactory iComponentFactory, Descriptor descriptor, boolean bl) {
        super((Frame)jFrame, Messages.getString("DescriptorEditDialog.DialogTitle"), iComponentFactory);
        this.init(iComponentFactory, descriptor, bl);
    }

    public DescriptorEditDialog(JDialog jDialog, IComponentFactory iComponentFactory, Descriptor descriptor, boolean bl) {
        super((Dialog)jDialog, Messages.getString("DescriptorEditDialog.DialogTitle"), iComponentFactory);
        this.init(iComponentFactory, descriptor, bl);
    }

    private void init(IComponentFactory iComponentFactory, Descriptor descriptor, boolean bl) {
        this.originalDescriptor = descriptor;
        this.clonedDescriptor = descriptor.clone();
        this.descriptorEditPanel = new DescriptorEditPanel(iComponentFactory, this.clonedDescriptor, bl);
        this.addOKButton(new OKAction());
        this.addCancelButton(new CancelAction());
        this.setContent(this.descriptorEditPanel);
        this.setSize(iComponentFactory.scaleInt(700), iComponentFactory.scaleInt(550));
        this.initLocation();
        this.setModal(true);
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super.putValue("ShortDescription", Messages.getString("DescriptorEditDialog.CancelToolTip"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DescriptorEditDialog.this.setDialogResult(2);
            DescriptorEditDialog.this.setVisible(false);
        }
    }

    private class OKAction
    extends AbstractAction {
        public OKAction() {
            super.putValue("ShortDescription", Messages.getString("DescriptorEditDialog.OKToolTip"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (DescriptorEditDialog.this.clonedDescriptor.getName() == null || DescriptorEditDialog.this.clonedDescriptor.getName().length() == 0) {
                JOptionPane.showMessageDialog(DescriptorEditDialog.this, Messages.getString("DescriptorEditDialog.WarningMissingName"), Messages.getString("DescriptorEditDialog.Error"), 0);
                return;
            }
            int n = Collections.binarySearch(DescriptorRegistry.getInstance().getAll(), DescriptorEditDialog.this.clonedDescriptor);
            if (n >= 0) {
                JOptionPane.showMessageDialog(DescriptorEditDialog.this, Messages.getString("DescriptorEditDialog.WarningDuplicatedName"), Messages.getString("DescriptorEditDialog.Error"), 0);
                return;
            }
            DescriptorEditDialog.this.originalDescriptor.initWith(DescriptorEditDialog.this.clonedDescriptor);
            DescriptorEditDialog.this.setDialogResult(0);
            DescriptorEditDialog.this.setVisible(false);
        }
    }
}

