/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.demographics.model;

import com.agfa.pacs.impaxee.demographics.model.AbstractDemographicsContainerElement;
import com.agfa.pacs.impaxee.demographics.model.DemographicsLine;
import com.agfa.pacs.impaxee.demographics.model.IDemographicsDefinitonChangeListener;
import com.agfa.pacs.impaxee.demographics.model.IDemographicsElementListener;
import com.agfa.pacs.impaxee.demographics.model.IDemographicsFontListener;
import com.agfa.pacs.impaxee.demographics.model.IDemographicsParagraphListener;
import com.tiani.config.mappingfonts.model.Font;
import com.tiani.config.mappingfonts.model.Line;
import com.tiani.config.mappingfonts.model.Paragraph;

public class DemographicsParagraph
extends AbstractDemographicsContainerElement<IDemographicsParagraphListener>
implements IDemographicsFontListener,
IDemographicsElementListener,
IDemographicsDefinitonChangeListener {
    private Paragraph paragraph;

    public DemographicsParagraph(Paragraph paragraph, Font font, boolean bl) {
        super(paragraph.getFont(), font, bl);
        this.paragraph = paragraph;
    }

    public void addDemographicsLine(DemographicsLine demographicsLine, int n) {
        if (n == -1) {
            n = this.lineCount();
        }
        this.paragraph.addLine(n, demographicsLine.getLine());
        demographicsLine.setParent(this);
        demographicsLine.registerDemographicsDefinitonChangeListener(this);
        for (IDemographicsParagraphListener iDemographicsParagraphListener : this.mappingElementlisteners) {
            iDemographicsParagraphListener.mappingLineAdded(demographicsLine, n);
        }
        this.informListenersContentChanged();
    }

    public void exchange(int n, int n2) {
        Line line = this.paragraph.getLine(n);
        Line line2 = this.paragraph.getLine(n2);
        this.paragraph.setLine(n, line2);
        this.paragraph.setLine(n2, line);
        for (IDemographicsParagraphListener iDemographicsParagraphListener : this.mappingElementlisteners) {
            iDemographicsParagraphListener.mappingLinesExchanged(n, n2);
        }
        this.informListenersContentChanged();
    }

    public int getIndexOf(DemographicsLine demographicsLine) {
        return this.paragraph.indexOf(demographicsLine.getLine());
    }

    public int lineCount() {
        return this.paragraph.lineCount();
    }

    public void removeLine(DemographicsLine demographicsLine) {
        demographicsLine.registerDemographicsDefinitonChangeListener(this);
        int n = this.paragraph.indexOf(demographicsLine.getLine());
        this.paragraph.removeLine(demographicsLine.getLine());
        for (IDemographicsParagraphListener iDemographicsParagraphListener : this.mappingElementlisteners) {
            iDemographicsParagraphListener.mappingLineDeleted(n);
        }
        this.informListenersContentChanged();
    }

    public DemographicsLine[] createMappingLines() {
        Line[] lineArray = this.paragraph.getLines();
        DemographicsLine[] demographicsLineArray = new DemographicsLine[lineArray.length];
        int n = 0;
        while (n < lineArray.length) {
            demographicsLineArray[n] = new DemographicsLine(lineArray[n], this);
            demographicsLineArray[n].registerDemographicsDefinitonChangeListener(this);
            ++n;
        }
        return demographicsLineArray;
    }

    @Override
    public void fontChanged(Object object) {
        this.remergeFonts();
    }

    @Override
    protected Font createLevelFont() {
        this.paragraph.setFont(new Font());
        return this.paragraph.getFont();
    }

    @Override
    public void mappingDefinitionChanged(Object object) {
        this.informListenersContentChanged();
    }
}

