/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.demographics.model;

import com.agfa.pacs.impaxee.demographics.model.AbstractDemographicsElement;
import com.agfa.pacs.impaxee.demographics.model.DemographicsParagraph;
import com.agfa.pacs.impaxee.demographics.model.IDemographicsDefinitonChangeListener;
import com.tiani.config.mappingfonts.model.Font;
import com.tiani.config.mappingfonts.model.MappingConfiguration;
import com.tiani.config.mappingfonts.model.Paragraph;
import com.tiani.config.mappingfonts.model.enums.ParagraphLocation;

public class DemographicsDefinition
extends AbstractDemographicsElement
implements IDemographicsDefinitonChangeListener {
    private MappingConfiguration mappingConfiguration;
    private DemographicsParagraph[] demographicsParagraphs;

    public DemographicsDefinition(Font font, MappingConfiguration mappingConfiguration, boolean bl) {
        super(mappingConfiguration.getFont(), font, bl);
        this.mappingConfiguration = mappingConfiguration;
        this.ensureParagraphs(mappingConfiguration);
        Paragraph[] paragraphArray = mappingConfiguration.getParagraphs();
        this.demographicsParagraphs = new DemographicsParagraph[paragraphArray.length];
        int n = 0;
        while (n < paragraphArray.length) {
            this.demographicsParagraphs[n] = new DemographicsParagraph(paragraphArray[n], this.getMergedFont(), bl);
            this.registerMappingFontListener(this.demographicsParagraphs[n]);
            this.demographicsParagraphs[n].registerDemographicsDefinitonChangeListener(this);
            ++n;
        }
    }

    private void ensureParagraphs(MappingConfiguration mappingConfiguration) {
        Paragraph paragraph = null;
        Paragraph paragraph2 = null;
        Paragraph paragraph3 = null;
        Paragraph paragraph4 = null;
        Paragraph[] paragraphArray = mappingConfiguration.getParagraphs();
        int n = paragraphArray.length;
        int n2 = 0;
        while (n2 < n) {
            Paragraph paragraph5 = paragraphArray[n2];
            if (paragraph5.getLocation() == ParagraphLocation.TOPLEFT) {
                paragraph = paragraph5;
            } else if (paragraph5.getLocation() == ParagraphLocation.TOPRIGHT) {
                paragraph2 = paragraph5;
            } else if (paragraph5.getLocation() == ParagraphLocation.BOTTOMLEFT) {
                paragraph3 = paragraph5;
            } else if (paragraph5.getLocation() == ParagraphLocation.BOTTOMRIGHT) {
                paragraph4 = paragraph5;
            }
            ++n2;
        }
        if (paragraph == null) {
            this.addParagraph(mappingConfiguration, ParagraphLocation.TOPLEFT);
        }
        if (this.isQuadMapping()) {
            if (paragraph2 == null) {
                this.addParagraph(mappingConfiguration, ParagraphLocation.TOPRIGHT);
            }
            if (paragraph3 == null) {
                this.addParagraph(mappingConfiguration, ParagraphLocation.BOTTOMLEFT);
            }
            if (paragraph4 == null) {
                this.addParagraph(mappingConfiguration, ParagraphLocation.BOTTOMRIGHT);
            }
        }
    }

    private void addParagraph(MappingConfiguration mappingConfiguration, ParagraphLocation paragraphLocation) {
        Paragraph paragraph = new Paragraph();
        paragraph.setLocation(paragraphLocation);
        mappingConfiguration.addParagraph(paragraph);
    }

    public void mappingFontChanged() {
        this.remergeFonts();
    }

    public MappingConfiguration getMappingConfiguration() {
        return this.mappingConfiguration;
    }

    public DemographicsParagraph[] getMappingParagraphs() {
        return this.demographicsParagraphs;
    }

    @Override
    protected Font createLevelFont() {
        this.mappingConfiguration.setFont(new Font());
        return this.mappingConfiguration.getFont();
    }

    @Override
    public void mappingDefinitionChanged(Object object) {
        this.informListenersContentChanged();
    }
}

