/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.dcminfo;

import com.agfa.pacs.base.swing.IComponentFactory;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.IStudyContainer;
import com.agfa.pacs.listtext.lta.base.dicominfo.AbstractDicomInfoDialog;
import com.agfa.pacs.listtext.lta.base.dicominfo.CompareTagsTableModel;
import com.agfa.pacs.listtext.lta.base.dicominfo.DicomInfoDialogManager;
import com.agfa.pacs.listtext.lta.base.dicominfo.SimpleTagsTableModel;
import com.agfa.pacs.listtext.lta.base.dicominfo.TagsTableModel;
import com.agfa.pacs.listtext.lta.base.tagdictionary.DicomTag;
import com.agfa.pacs.listtext.lta.base.tagdictionary.Tag;
import com.agfa.pacs.listtext.lta.base.tagdictionary.TagDictionary;
import com.agfa.pacs.listtext.swingx.icon.PIcon;
import com.agfa.pacs.listtext.swingx.icon.PIconFactory;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.gui.dialog.GUIMessageHandler;
import com.tiani.jvision.event.TEvent;
import com.tiani.jvision.event.TEventDispatch;
import com.tiani.jvision.event.TEventHandler;
import com.tiani.jvision.image.View;
import com.tiani.jvision.main.DisplaySetEvaluable;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.patinfo.DataSelectionManager;
import com.tiani.jvision.patinfo.ISelectionListener;
import com.tiani.jvision.vis.VisDisplayData;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;

public class ImpaxEEDicomInfoDialog
extends AbstractDicomInfoDialog {
    private static final long serialVersionUID = 1L;
    private static PIcon pinIcon;
    private static PIcon unpinIcon;
    private ActiveImageEventHandler activeImageEventHandler;
    private DataSelectionListener dataSelectionListener;
    private JPanel advancedComparePanel;
    private JButton pinCurrentButton;
    private JButton unpinButton;
    private JCheckBox showSameCheckBox;
    private View currentView;
    private View pinnedView;

    static {
        PIconFactory pIconFactory = new PIconFactory((IComponentFactory)ComponentFactory.instance, 24);
        pinIcon = pIconFactory.loadIcon(ImpaxEEDicomInfoDialog.class, "pin.svg");
        unpinIcon = pIconFactory.loadIcon(ImpaxEEDicomInfoDialog.class, "unpin.svg");
    }

    private ImpaxEEDicomInfoDialog() {
        super((Window)JVision2.getMainFrame(), (IComponentFactory)ComponentFactory.instance);
        DicomInfoDialogManager.getInstance().registerDicomInfoDialog((AbstractDicomInfoDialog)this);
        this.addComponentListener(new DialogComponentListener());
    }

    public static ImpaxEEDicomInfoDialog getInstance() {
        return LazyHolder.instance;
    }

    public void init(Attributes attributes) {
        SimpleTagsTableModel simpleTagsTableModel;
        if (this.pinnedView != null && this.pinnedView.getDisplayData() == null) {
            this.pinView(null, false);
        }
        if (this.pinnedView != null && this.pinnedView != this.currentView) {
            ArrayList<Attributes> arrayList = new ArrayList<Attributes>(2);
            arrayList.add(attributes);
            arrayList.add(ImpaxEEDicomInfoDialog.getAttributes(this.pinnedView));
            boolean bl = true;
            if (this.showSameCheckBox != null) {
                bl = !this.showSameCheckBox.isSelected();
            }
            simpleTagsTableModel = new CompareTagsTableModel(arrayList, bl, (IComponentFactory)ComponentFactory.instance);
        } else {
            simpleTagsTableModel = new SimpleTagsTableModel(attributes, (IComponentFactory)ComponentFactory.instance);
        }
        simpleTagsTableModel.show(this.showDicom, this.showDicomPrivate);
        this.tableTags.setModel((TableModel)simpleTagsTableModel);
        this.setTableColumnModelPrefs((TagsTableModel)simpleTagsTableModel);
    }

    public void showDialog(View view) {
        if (DataSelectionManager.getInstance().isMultiPatientCompareActive()) {
            ComponentFactory.instance.showErrorDialog(Messages.getString("ImpaxEEDicomInfoDialog.MPErrorTitle"), Messages.getString("ImpaxEEDicomInfoDialog.MPErrorMessage"), null);
        } else if (!this.isVisible()) {
            if (!DicomInfoDialogManager.getInstance().isDialogVisible()) {
                this.setCurrentView(view);
                this.setSize(800, 600);
                GUIMessageHandler.centerSizedWindow((Window)((Object)this));
                this.setVisible(true);
            } else {
                DicomInfoDialogManager.getInstance().visibleToFront();
            }
        } else {
            this.toFront();
        }
    }

    public void setCurrentView(View view) {
        this.currentView = view;
        this.reinitFromCurrentView();
    }

    private void reinitFromCurrentView() {
        this.init(ImpaxEEDicomInfoDialog.getAttributes(this.currentView));
        this.checkSearch();
    }

    private static Attributes getAttributes(View view) {
        Attributes attributes;
        if (view != null && view.getDisplayData() != null) {
            IFrameObjectData iFrameObjectData = view.getFrameData();
            attributes = iFrameObjectData.isBeingLossyPrefetched() ? new Attributes(iFrameObjectData.getMainFrame().getMergedDatasetFromQueryObject()) : new Attributes(iFrameObjectData.getDicomObject());
            IDisplaySet iDisplaySet = view.getDisplayData().getDisplaySet();
            IStudyContainer iStudyContainer = DataSelectionManager.getInstance().getActiveHanging().getStudyContainer();
            DisplaySetEvaluable displaySetEvaluable = new DisplaySetEvaluable(iFrameObjectData, iDisplaySet, iStudyContainer);
            Tag[] tagArray = TagDictionary.getInstance().getPrivateTagDictionary().allTags();
            int n = tagArray.length;
            int n2 = 0;
            while (n2 < n) {
                int n3;
                String string;
                Tag tag = tagArray[n2];
                if (tag instanceof DicomTag && (string = displaySetEvaluable.resolveString(n3 = ((DicomTag)tag).getNumber().intValue())) != null && string.length() > 0) {
                    attributes.setString(n3, VR.LT, string);
                }
                ++n2;
            }
        } else {
            attributes = new Attributes();
        }
        return attributes;
    }

    protected JPanel getAdvancedComparePanel() {
        if (this.advancedComparePanel == null) {
            this.advancedComparePanel = new JPanel();
            this.advancedComparePanel.setBorder(BorderFactory.createEmptyBorder());
            this.pinCurrentButton = ComponentFactory.instance.createButton((Icon)pinIcon);
            this.pinCurrentButton.setToolTipText(Messages.getString("ImpaxEEDicomInfoDialog.pinCurrentButtonToolTip"));
            this.pinCurrentButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ImpaxEEDicomInfoDialog.this.pinView(ImpaxEEDicomInfoDialog.this.currentView, true);
                }
            });
            this.advancedComparePanel.add(this.pinCurrentButton);
            this.unpinButton = ComponentFactory.instance.createButton((Icon)unpinIcon);
            this.unpinButton.setToolTipText(Messages.getString("ImpaxEEDicomInfoDialog.unpinButtonToolTip"));
            this.unpinButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ImpaxEEDicomInfoDialog.this.pinView(null, true);
                }
            });
            this.unpinButton.setEnabled(false);
            this.advancedComparePanel.add(this.unpinButton);
            this.showSameCheckBox = ComponentFactory.instance.createCheckBox(Messages.getString("ImpaxEEDicomInfoDialog.showSameCheckBoxText"));
            this.showSameCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ImpaxEEDicomInfoDialog.this.reinitFromCurrentView();
                        }
                    });
                }
            });
            this.advancedComparePanel.add(this.showSameCheckBox);
        }
        return this.advancedComparePanel;
    }

    private void pinView(View view, boolean bl) {
        this.pinnedView = view;
        if (view != null) {
            this.unpinButton.setEnabled(true);
        } else {
            this.unpinButton.setEnabled(false);
        }
        if (bl) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ImpaxEEDicomInfoDialog.this.reinitFromCurrentView();
                }
            });
        }
    }

    /* synthetic */ ImpaxEEDicomInfoDialog(ImpaxEEDicomInfoDialog impaxEEDicomInfoDialog) {
        this();
    }

    private class ActiveImageEventHandler
    implements TEventHandler {
        private ActiveImageEventHandler() {
        }

        @Override
        public void handleTEvent(TEvent tEvent, final Object object, int n) {
            if (tEvent.id == 53 && object instanceof View) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ImpaxEEDicomInfoDialog.this.setCurrentView((View)object);
                    }
                });
            }
        }
    }

    private class DataSelectionListener
    implements ISelectionListener {
        private DataSelectionListener() {
        }

        @Override
        public void lastModifiedChanged(int n, VisDisplayData visDisplayData) {
            if (visDisplayData == null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ImpaxEEDicomInfoDialog.this.setCurrentView(null);
                    }
                });
            }
        }
    }

    private class DialogComponentListener
    implements ComponentListener {
        private DialogComponentListener() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
            ImpaxEEDicomInfoDialog.this.activeImageEventHandler = new ActiveImageEventHandler();
            TEventDispatch.addListener(ImpaxEEDicomInfoDialog.this.activeImageEventHandler);
            ImpaxEEDicomInfoDialog.this.dataSelectionListener = new DataSelectionListener();
            DataSelectionManager.getInstance().addSelectionListener(ImpaxEEDicomInfoDialog.this.dataSelectionListener);
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
            TEventDispatch.removeListener(ImpaxEEDicomInfoDialog.this.activeImageEventHandler);
            DataSelectionManager.getInstance().removeSelectionListener(ImpaxEEDicomInfoDialog.this.dataSelectionListener);
            ImpaxEEDicomInfoDialog.this.pinView(null, false);
            ImpaxEEDicomInfoDialog.this.currentView = null;
        }
    }

    private static class LazyHolder {
        private static final ImpaxEEDicomInfoDialog instance = new ImpaxEEDicomInfoDialog(null);

        private LazyHolder() {
        }
    }
}

