/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.cache;

import com.agfa.pacs.cache.CacheID;
import com.agfa.pacs.impaxee.cache.BufferedImageGroup;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.memcache.DataCache;
import com.agfa.pacs.memcache.ICachedObjectGroup;
import com.agfa.pacs.memcache.ICachedObjectHandler;
import java.awt.image.BufferedImage;

public class BufferedImageHandler
implements ICachedObjectHandler {
    private static final ALogger LOG = ALogger.getLogger(BufferedImageHandler.class);
    private String prefix;
    private DataCache cache;

    public void init(DataCache dataCache) {
        this.cache = dataCache;
        this.prefix = this.getClass().getName();
    }

    public Object getGroupID(CacheID cacheID, long l) {
        if (cacheID.getGroup() != null) {
            try {
                String string = cacheID.getGroup();
                String string2 = string.substring(0, string.indexOf(120));
                String string3 = string.substring(string2.length() + 1);
                int n = Integer.parseInt(string2);
                int n2 = Integer.parseInt(string3);
                if (n <= 0 || n2 <= 0) {
                    if (n <= 0) {
                        n = n2;
                    }
                    if (n2 <= 0) {
                        n2 = n;
                    }
                    return new BufferedImageGroup(this.cache, n, n2, cacheID);
                }
                return new BufferedImageGroup(this.cache, n, n2);
            }
            catch (Exception exception) {
                LOG.error("non recoverable group");
                return null;
            }
        }
        return this.prefix;
    }

    public Object getGroupID(CacheID cacheID, Object object) {
        return new GroupKey(((BufferedImage)object).getWidth(), ((BufferedImage)object).getHeight());
    }

    public ICachedObjectGroup createGroup(CacheID cacheID, long l) {
        if (cacheID.getGroup() != null) {
            try {
                String string = cacheID.getGroup();
                String string2 = string.substring(0, string.indexOf(120));
                String string3 = string.substring(string2.length() + 1);
                int n = Integer.parseInt(string2);
                int n2 = Integer.parseInt(string3);
                if (n <= 0 || n2 <= 0) {
                    if (n <= 0) {
                        n = n2;
                    }
                    if (n2 <= 0) {
                        n2 = n;
                    }
                    return new BufferedImageGroup(this.cache, n, n2, cacheID);
                }
                return new BufferedImageGroup(this.cache, n, n2);
            }
            catch (Exception exception) {
                LOG.error("non recoverable group");
                return null;
            }
        }
        return null;
    }

    public ICachedObjectGroup createGroup(Object object, Object[] objectArray) {
        int n = ((GroupKey)object).w;
        int n2 = ((GroupKey)object).h;
        if (n <= 0 || n2 <= 0) {
            return new BufferedImageGroup(this.cache, ((Number)objectArray[0]).intValue(), ((Number)objectArray[1]).intValue(), (CacheID)object);
        }
        return new BufferedImageGroup(this.cache, ((Number)objectArray[0]).intValue(), ((Number)objectArray[1]).intValue());
    }

    public ICachedObjectGroup createGroup(Object object, Object object2) {
        BufferedImage bufferedImage = (BufferedImage)object2;
        int n = ((GroupKey)object).w;
        int n2 = ((GroupKey)object).h;
        if (n <= 0 || n2 <= 0) {
            return new BufferedImageGroup(this.cache, bufferedImage.getWidth(), bufferedImage.getHeight(), (CacheID)object);
        }
        return new BufferedImageGroup(this.cache, bufferedImage.getWidth(), bufferedImage.getHeight());
    }

    public Object getGroupID(Object[] objectArray) {
        return new GroupKey((Integer)objectArray[0], (Integer)objectArray[1]);
    }

    class GroupKey {
        private final int w;
        private final int h;

        private GroupKey(int n, int n2) {
            this.w = n;
            this.h = n2;
        }

        public int hashCode() {
            return BufferedImageHandler.this.prefix.hashCode() + this.w * this.h;
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof GroupKey)) {
                return false;
            }
            GroupKey groupKey = (GroupKey)object;
            return this.w == groupKey.w && this.h == groupKey.h;
        }
    }
}

