/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.actions.ui.config;

import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.ui.config.ActionConfigTree;
import com.agfa.pacs.impaxee.actions.ui.config.IActionConfigItem;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Arrays;

public class ActionDnD {
    public static DataFlavor ActionFlavor = new DataFlavor(PAction.class, "ImpaxEE Action");
    public static DataFlavor ActionItemFlavor = new DataFlavor(IActionConfigItem.class, "ImpaxEE Action-Item");
    public static DataFlavor ActionNodeFlavor = new DataFlavor(ActionConfigTree.NodeObject.class, "ImpaxEE Action Node");

    public static class ActionItemTransferable
    implements Transferable {
        private IActionConfigItem item;

        public ActionItemTransferable(IActionConfigItem iActionConfigItem) {
            this.item = iActionConfigItem;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{ActionFlavor, ActionItemFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return dataFlavor != null && (dataFlavor.equals(ActionFlavor) || dataFlavor.equals(ActionItemFlavor));
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            if (ActionFlavor.equals(dataFlavor)) {
                return this.item.getAction();
            }
            if (ActionItemFlavor.equals(dataFlavor)) {
                return this.item;
            }
            throw new UnsupportedFlavorException(dataFlavor);
        }
    }

    public static class ActionNodeTransferable
    implements Transferable {
        private ActionConfigTree.NodeObject nodeObject;

        public ActionNodeTransferable(ActionConfigTree.NodeObject nodeObject) {
            this.nodeObject = nodeObject;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            if (this.nodeObject instanceof ActionConfigTree.ActionNodeObject) {
                return new DataFlavor[]{ActionFlavor, ActionNodeFlavor};
            }
            return new DataFlavor[]{ActionNodeFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            if (dataFlavor != null) {
                DataFlavor[] dataFlavorArray = this.getTransferDataFlavors();
                return Arrays.asList(dataFlavorArray).contains(dataFlavor);
            }
            return false;
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            if (this.isDataFlavorSupported(dataFlavor)) {
                if (ActionFlavor.equals(dataFlavor)) {
                    return ((ActionConfigTree.ActionNodeObject)this.nodeObject).getAction();
                }
                if (ActionNodeFlavor.equals(dataFlavor)) {
                    return this.nodeObject;
                }
            }
            throw new UnsupportedFlavorException(dataFlavor);
        }
    }
}

