/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.actions.ui;

import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.impl.SeparatorPAction;
import com.agfa.pacs.impaxee.actions.ui.ActionComponentFactory;
import com.agfa.pacs.impaxee.actions.ui.ActionUIScope;
import com.agfa.pacs.impaxee.actions.ui.ActionUIUtilities;
import com.agfa.pacs.impaxee.actions.ui.ButtonActionUI;
import com.agfa.pacs.impaxee.actions.ui.ButtonPopupMenuPanel;
import com.agfa.pacs.impaxee.actions.ui.IActionUI;
import com.agfa.pacs.logging.ALogger;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class DynamicActionPopupMenu
extends JPopupMenu {
    private static final ALogger log = ALogger.getLogger(DynamicActionPopupMenu.class);
    private ActionUIScope scope;
    private PAction parentAction;
    private Collection<IActionUI> actionUIs;
    private boolean menuBuilt = false;
    private final Map<PAction, AbstractButton> cachedComponents;

    public DynamicActionPopupMenu(ActionUIScope actionUIScope, PAction pAction) {
        this.scope = actionUIScope;
        this.parentAction = pAction;
        this.actionUIs = new ArrayList<IActionUI>();
        this.cachedComponents = new HashMap<PAction, AbstractButton>(4);
        this.setLightWeightPopupEnabled(false);
    }

    public Collection<PAction> getActions() {
        return Arrays.asList(this.parentAction.getSubactions());
    }

    @Override
    public void pack() {
        if (!this.menuBuilt) {
            this.buildMenu();
        }
        super.pack();
    }

    @Override
    public void setVisible(boolean bl) {
        if (!bl) {
            this.releaseMenu();
        } else if (!this.menuBuilt) {
            this.buildMenu();
        }
        super.setVisible(bl);
    }

    void cacheCurrentComponents() {
        PAction[] pActionArray = this.parentAction.getSubactions();
        if (pActionArray != null) {
            for (Map.Entry<Component, PAction> entry : ActionUIUtilities.createComponentActionMap(this, Arrays.asList(pActionArray)).entrySet()) {
                Component component = entry.getKey();
                if (!(component instanceof AbstractButton)) continue;
                this.cachedComponents.put(entry.getValue(), (AbstractButton)component);
            }
        }
    }

    private void buildMenu() {
        this.removeAll();
        ArrayList<PAction> arrayList = new ArrayList<PAction>();
        this.buildMenu(this.parentAction, arrayList);
        if (!arrayList.isEmpty()) {
            if (this.getComponentCount() > 0) {
                this.add((Component)ActionComponentFactory.createSeparatorImpl(new SeparatorPAction()), 0);
                this.add(Box.createVerticalStrut(GUI.getScaledDiagnosticInt((int)2)), 1);
            }
            this.add((Component)this.createButtonPopupMenuPanel(this, arrayList), 0);
        }
        this.menuBuilt = true;
    }

    private void buildMenu(PAction pAction, Collection<PAction> collection) {
        PAction[] pActionArray = pAction.getSubactions();
        if (pActionArray != null) {
            PAction[] pActionArray2 = pActionArray;
            int n = pActionArray.length;
            int n2 = 0;
            while (n2 < n) {
                PAction pAction2 = pActionArray2[n2];
                if (ActionUIUtilities.isIconButtonAction(pAction2)) {
                    collection.add(pAction2);
                } else if (!ActionUIUtilities.isExecutable(pAction2)) {
                    if (pAction2.isEnabled()) {
                        this.buildMenu(pAction2, collection);
                    }
                } else {
                    try {
                        Component component = this.cachedComponents.get(pAction2);
                        if (component == null) {
                            JMenuItem jMenuItem = ActionComponentFactory.createSubMenuItem(pAction, pAction2, this.scope);
                            ButtonActionUI buttonActionUI = new ButtonActionUI(pAction2, jMenuItem, this.scope, false);
                            component = buttonActionUI.getComponent();
                        }
                        this.add(component);
                    }
                    catch (Exception exception) {
                        log.warn("Can't create action-ui for action '" + pAction2.getID() + "'. Action is skipped!", (Throwable)exception);
                    }
                }
                ++n2;
            }
        }
    }

    private void releaseMenu() {
        this.removeAll();
        if (this.actionUIs != null) {
            for (IActionUI iActionUI : this.actionUIs) {
                iActionUI.release();
            }
            this.actionUIs.clear();
        }
        this.setPreferredSize(null);
        this.menuBuilt = false;
    }

    private ButtonPopupMenuPanel createButtonPopupMenuPanel(JPopupMenu jPopupMenu, Collection<PAction> collection) {
        ArrayList<AbstractButton> arrayList = new ArrayList<AbstractButton>();
        if (collection != null && !collection.isEmpty()) {
            for (PAction pAction : collection) {
                AbstractButton abstractButton;
                assert (ActionUIUtilities.isIconButtonAction(pAction)) : "create action icon-group button: action '" + pAction.getID() + "' is not icon-group action!";
                Component component = this.cachedComponents.get(pAction);
                if (component instanceof AbstractButton) {
                    abstractButton = (AbstractButton)component;
                } else {
                    abstractButton = ActionComponentFactory.createButtonImpl(pAction, this.scope);
                    ButtonActionUI buttonActionUI = new ButtonActionUI(pAction, abstractButton, this.scope);
                    this.actionUIs.add(buttonActionUI);
                }
                arrayList.add(abstractButton);
            }
        }
        return ButtonPopupMenuPanel.create(jPopupMenu, arrayList, 3, 5);
    }
}

