/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.actions.ui;

import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PActionListener;
import com.agfa.pacs.impaxee.actions.impl.AbstractPAction;
import com.agfa.pacs.impaxee.actions.ui.AbstractParentActionUI;
import com.agfa.pacs.impaxee.actions.ui.ActionUIScope;
import com.agfa.pacs.impaxee.actions.ui.ActionUIUtilities;
import com.agfa.pacs.impaxee.actions.ui.DropDownButton;
import com.agfa.pacs.impaxee.actions.ui.IActionUI;
import com.agfa.pacs.logging.ALogger;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JPopupMenu;

public class DropDownButtonActionUI
extends AbstractParentActionUI<DropDownButton> {
    private static final ALogger log = ALogger.getLogger(DropDownButtonActionUI.class);
    private PActionListener actionListener;
    private SubActionListener subActionListener;
    private ActionListener buttonListener;
    private PAction selectedAction;

    public DropDownButtonActionUI(PAction pAction, DropDownButton dropDownButton, ActionUIScope actionUIScope) {
        super(pAction, dropDownButton, actionUIScope);
        this.selectedAction = this.getSelectedSubAction(pAction);
        if (this.selectedAction == null && ActionUIUtilities.hasSubActions(pAction)) {
            this.selectedAction = pAction.getSubactions()[0];
        }
        this.bind();
    }

    @Override
    protected void registerListeners(PAction pAction, DropDownButton dropDownButton) {
        if (this.actionListener == null) {
            this.actionListener = this.createActionListener();
            pAction.addListener(this.actionListener);
        }
        if (this.buttonListener == null && this.getScope() != ActionUIScope.DisplayToolbar) {
            this.buttonListener = this.createButtonListener();
            dropDownButton.addActionListener(this.buttonListener);
        }
    }

    @Override
    protected void unregisterListeners(PAction pAction, DropDownButton dropDownButton) {
        if (this.actionListener != null) {
            pAction.removeListener(this.actionListener);
        }
        if (this.buttonListener != null) {
            dropDownButton.removeActionListener(this.buttonListener);
        }
    }

    @Override
    protected void updateComponent(PAction pAction, DropDownButton dropDownButton, ActionUIScope actionUIScope) {
        super.updateComponent(pAction, dropDownButton, actionUIScope);
        if (this.selectedAction == null) {
            dropDownButton.setText(null);
            dropDownButton.setToolTipText(null);
            dropDownButton.setIcon(null);
            dropDownButton.setRolloverIcon(null);
            dropDownButton.setDisabledIcon(null);
            dropDownButton.setBorder(null);
        } else {
            boolean bl;
            String string = this.selectedAction.getID();
            boolean bl2 = actionUIScope == ActionUIScope.VisMenu || actionUIScope == ActionUIScope.Other || actionUIScope == ActionUIScope.DisplayToolbar;
            Icon icon = this.selectedAction.getIcon(bl2);
            Icon icon2 = this.selectedAction.getPopupIcon(bl2);
            Icon icon3 = this.selectedAction.getDisabledIcon(bl2);
            boolean bl3 = bl = icon == null;
            if (!bl && (string.startsWith("VARIABLE_LAYOUT_CHOOSER") || string.startsWith("DISPLAY_LAYOUT_CHOOSER"))) {
                bl = actionUIScope.equals((Object)ActionUIScope.TopToolbar);
            }
            dropDownButton.setText(bl ? this.selectedAction.getCaption() : null);
            dropDownButton.setToolTipText(AbstractPAction.getTooltipTextWithShortcut(this.selectedAction));
            dropDownButton.setIcon(icon);
            dropDownButton.setDisabledIcon(icon3);
            dropDownButton.setRolloverIcon(icon2);
            dropDownButton.setRolloverSelectedIcon(icon2);
            dropDownButton.setBorder(null);
            dropDownButton.setEnabled(pAction.isEnabled());
            dropDownButton.revalidate();
            dropDownButton.repaint();
        }
    }

    @Override
    protected void bindSubActions() {
        super.bindSubActions();
        PAction[] pActionArray = this.getAction().getSubactions();
        int n = pActionArray.length;
        int n2 = 0;
        while (n2 < n) {
            PAction pAction = pActionArray[n2];
            if (this.subActionListener == null) {
                this.subActionListener = new SubActionListener();
            }
            pAction.addListener(this.subActionListener);
            ++n2;
        }
    }

    @Override
    protected void releaseSubActions() {
        super.releaseSubActions();
        PAction[] pActionArray = this.getAction().getSubactions();
        int n = pActionArray.length;
        int n2 = 0;
        while (n2 < n) {
            PAction pAction = pActionArray[n2];
            pAction.removeListener(this.subActionListener);
            ++n2;
        }
    }

    @Override
    protected void registerSubActionListener(PAction pAction, IActionUI iActionUI) {
        super.registerSubActionListener(pAction, iActionUI);
        if (this.subActionListener == null) {
            this.subActionListener = new SubActionListener();
        }
        if (iActionUI.getComponent() instanceof AbstractButton) {
            ((AbstractButton)iActionUI.getComponent()).addActionListener(this.subActionListener);
        }
    }

    @Override
    protected void unregisterSubActionListener(PAction pAction, IActionUI iActionUI) {
        super.unregisterSubActionListener(pAction, iActionUI);
        if (this.subActionListener != null && iActionUI.getComponent() instanceof AbstractButton) {
            ((AbstractButton)iActionUI.getComponent()).removeActionListener(this.subActionListener);
        }
    }

    @Override
    protected JPopupMenu getParentComponent() {
        return ((DropDownButton)this.getComponent()).getPopupMenu();
    }

    protected ActionListener createButtonListener() {
        return new DropDownButtonListener();
    }

    protected PActionListener createActionListener() {
        return new ParentActionListener();
    }

    private PAction getSelectedSubAction(PAction pAction) {
        PAction[] pActionArray = pAction.getSubactions();
        if (pActionArray != null) {
            PAction[] pActionArray2 = pAction.getSubactions();
            int n = pActionArray2.length;
            int n2 = 0;
            while (n2 < n) {
                PAction pAction2 = pActionArray2[n2];
                if (pAction2.isSelected()) {
                    return pAction2;
                }
                ++n2;
            }
        }
        return null;
    }

    private class DropDownButtonListener
    implements ActionListener {
        private DropDownButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PAction pAction = DropDownButtonActionUI.this.selectedAction;
            if (pAction != null) {
                log.debug("detected ui-trigger (button-click) to execute action " + pAction.getID());
                pAction.perform(ActionUIUtilities.getActionUIContext((DropDownButton)DropDownButtonActionUI.this.getComponent()));
            }
        }
    }

    private class ParentActionListener
    implements PActionListener {
        private ParentActionListener() {
        }

        @Override
        public void enabledStateChanged(boolean bl) {
            ((DropDownButton)DropDownButtonActionUI.this.getComponent()).setEnabled(bl);
        }

        @Override
        public void selectionStateChanged(boolean bl) {
            if (PAction.ActionType.SubmenuExclusive.equals((Object)DropDownButtonActionUI.this.getAction().getActionType())) {
                DropDownButtonActionUI.this.selectedAction = DropDownButtonActionUI.this.getSelectedSubAction(DropDownButtonActionUI.this.getAction());
                DropDownButtonActionUI.this.updateComponent();
            } else {
                DropDownButtonActionUI.this.updateComponent(DropDownButtonActionUI.this.getAction(), (DropDownButton)DropDownButtonActionUI.this.getComponent(), (ActionUIScope)null);
            }
        }

        @Override
        public void contentChanged(String string, String string2, boolean bl) {
            DropDownButtonActionUI.this.updateComponent();
        }
    }

    private class SubActionListener
    implements PActionListener,
    ActionListener {
        private SubActionListener() {
        }

        @Override
        public void enabledStateChanged(boolean bl) {
            DropDownButtonActionUI.this.updateComponent();
        }

        @Override
        public void selectionStateChanged(boolean bl) {
            if (bl && PAction.ActionType.SubmenuExclusive.equals((Object)DropDownButtonActionUI.this.getAction().getActionType())) {
                DropDownButtonActionUI.this.selectedAction = DropDownButtonActionUI.this.getSelectedSubAction(DropDownButtonActionUI.this.getAction());
                DropDownButtonActionUI.this.updateComponent();
            }
        }

        @Override
        public void contentChanged(String string, String string2, boolean bl) {
            DropDownButtonActionUI.this.updateComponent();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DropDownButtonActionUI.this.selectedAction = DropDownButtonActionUI.this.findSubActionForComponent((Component)actionEvent.getSource());
            DropDownButtonActionUI.this.updateComponent();
        }
    }
}

