/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.actions.ui;

import com.agfa.pacs.listtext.swingx.util.graphics.ColorUtils;
import com.tiani.gui.workarounds.multimonitor.MultiMonitorButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class DropDownButton
extends MultiMonitorButton {
    private JPopupMenu popupMenu;
    private Orientation orientation;
    private Icon icon;
    private Icon disabledIcon;
    private Icon rolloverIcon;
    private Icon rolloverSelectedIcon;
    private boolean crossfaded;
    private int iconGap;

    public DropDownButton(String string, Icon icon, JPopupMenu jPopupMenu, Orientation orientation) {
        this.popupMenu = jPopupMenu;
        this.orientation = orientation;
        this.iconGap = 1;
        this.icon = icon;
        this.setHorizontalTextPosition(2);
        this.setText(string);
        this.updateIcons();
        this.addActionListener(new PopupHandler());
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                DropDownButton.this.updateIcons();
                DropDownButton.this.repaint();
            }
        });
    }

    public DropDownButton(String string, Icon icon) {
        this(string, icon, null, Orientation.bottom);
    }

    public DropDownButton() {
        this(null, null, null, Orientation.bottom);
    }

    @Override
    public void setIcon(Icon icon) {
        if (this.icon != icon) {
            this.icon = icon;
            this.updateIcons();
            this.repaint();
        }
    }

    @Override
    public void setDisabledIcon(Icon icon) {
        if (this.disabledIcon != icon) {
            this.disabledIcon = icon;
            this.updateIcons();
            this.repaint();
        }
    }

    @Override
    public void setRolloverIcon(Icon icon) {
        if (this.rolloverIcon != icon) {
            this.rolloverIcon = icon;
            this.updateIcons();
            this.repaint();
        }
    }

    @Override
    public void setRolloverSelectedIcon(Icon icon) {
        if (this.rolloverSelectedIcon != icon) {
            this.rolloverSelectedIcon = icon;
            this.updateIcons();
            this.repaint();
        }
    }

    public JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    public void setPopupMenu(JPopupMenu jPopupMenu) {
        this.popupMenu = jPopupMenu;
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        if (this.orientation != orientation) {
            this.orientation = orientation;
            this.updateIcons();
            this.repaint();
        }
    }

    public boolean isCrossfaded() {
        return this.crossfaded;
    }

    public void setCrossfaded(boolean bl) {
        if (this.crossfaded != bl) {
            this.crossfaded = bl;
            this.updateIcons();
            this.repaint();
        }
    }

    private void showPopupMenu() {
        this.popupMenu.pack();
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.popupMenu.getPreferredSize();
        if (dimension2.width < dimension.width) {
            this.popupMenu.setPreferredSize(new Dimension(dimension.width, dimension2.height));
        }
        Point point = new Point(0, dimension.height);
        if (Orientation.left.equals((Object)this.orientation)) {
            point.x = 0 - dimension2.width;
            point.y = this.getHeight() / 2 - dimension2.height / 2;
        } else if (Orientation.top.equals((Object)this.orientation)) {
            point.y = 0 - dimension2.height;
        } else if (!Orientation.bottom.equals((Object)this.orientation) && Orientation.right.equals((Object)this.orientation)) {
            point.x = dimension.width;
            point.y = dimension.height / 2 - dimension2.height / 2;
        }
        DropDownButton dropDownButton = this.popupMenu.getInvoker() != null ? this.popupMenu.getInvoker() : this;
        Point point2 = SwingUtilities.convertPoint(this, point, dropDownButton);
        this.popupMenu.show(dropDownButton, point2.x, point2.y);
        this.popupMenu.pack();
    }

    private void updateIcons() {
        super.setIcon(this.createIcon());
        super.setDisabledIcon(this.createDisabledIcon());
        super.setRolloverIcon(this.createRolloverIcon());
        super.setRolloverSelectedIcon(this.createRolloverSelectedIcon());
    }

    private Icon createIcon() {
        if (this.icon != null) {
            Color color = this.getArrowColor(false, false);
            return this.crossfaded ? this.createCrossfadedArrowIcon(this.icon, color) : this.createMergedArrowIcon(this.icon, color);
        }
        return null;
    }

    private Icon createDisabledIcon() {
        if (this.disabledIcon != null) {
            Color color = this.getArrowColor(false, true);
            return this.crossfaded ? this.createCrossfadedArrowIcon(this.disabledIcon, color) : this.createMergedArrowIcon(this.disabledIcon, color);
        }
        return null;
    }

    private Icon createRolloverIcon() {
        if (this.rolloverIcon != null) {
            Color color = this.getArrowColor(true, false);
            return this.crossfaded ? this.createCrossfadedArrowIcon(this.rolloverIcon, color) : this.createMergedArrowIcon(this.rolloverIcon, color);
        }
        return null;
    }

    private Icon createRolloverSelectedIcon() {
        if (this.rolloverSelectedIcon != null) {
            Color color = this.getArrowColor(true, false);
            return this.crossfaded ? this.createCrossfadedArrowIcon(this.rolloverSelectedIcon, color) : this.createMergedArrowIcon(this.rolloverSelectedIcon, color);
        }
        return null;
    }

    private Icon createArrowIcon(Color color) {
        int n = this.getArrowIconWidth(this.orientation);
        int n2 = this.getArrowIconHeight(this.orientation);
        if (Orientation.left.equals((Object)this.orientation)) {
            return new LeftArrowIcon(color, n, n2);
        }
        if (Orientation.right.equals((Object)this.orientation)) {
            return new RightArrowIcon(color, n, n2);
        }
        if (Orientation.top.equals((Object)this.orientation)) {
            return new UpArrowIcon(color, n, n2);
        }
        return new DownArrowIcon(color, n, n2);
    }

    private Color getArrowColor(boolean bl, boolean bl2) {
        Color color = this.getBackground();
        boolean bl3 = ColorUtils.isBright((Color)color);
        if (bl2) {
            return bl3 ? ColorUtils.darker((Color)color, (float)0.9f) : ColorUtils.brighter((Color)color, (float)0.5f);
        }
        if (bl) {
            return bl3 ? ColorUtils.darker((Color)color, (float)0.9f) : ColorUtils.brighter((Color)color, (float)0.2f);
        }
        return bl3 ? ColorUtils.darker((Color)color, (float)0.75f) : ColorUtils.brighter((Color)color, (float)0.275f);
    }

    private ImageIcon createCrossfadedArrowIcon(Icon icon, Color color) {
        return this.crossfadeIcons(icon, this.createArrowIcon(color));
    }

    private ImageIcon createMergedArrowIcon(Icon icon, Color color) {
        Icon icon2 = this.createArrowIcon(color);
        if (Orientation.left.equals((Object)this.orientation)) {
            return this.mergeIcons(icon2, icon);
        }
        return this.mergeIcons(icon, icon2);
    }

    private ImageIcon mergeIcons(Icon icon, Icon icon2) {
        Image image;
        Image image2 = icon instanceof ImageIcon ? ((ImageIcon)icon).getImage() : null;
        Image image3 = image = icon2 instanceof ImageIcon ? ((ImageIcon)icon2).getImage() : null;
        if (icon != null && image2 == null && icon.getIconWidth() > 0 && icon.getIconHeight() > 0) {
            image2 = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
            icon.paintIcon(this, image2.getGraphics(), 0, 0);
        }
        if (icon2 != null && image == null && icon2.getIconWidth() > 0 && icon2.getIconHeight() > 0) {
            image = new BufferedImage(icon2.getIconWidth(), icon2.getIconHeight(), 2);
            icon2.paintIcon(this, image.getGraphics(), 0, 0);
        }
        if (image2 == null && image == null) {
            return new ImageIcon();
        }
        if (image2 == null) {
            return new ImageIcon(image);
        }
        if (image == null) {
            return new ImageIcon(image2);
        }
        BufferedImage bufferedImage = new BufferedImage(image2.getWidth(null) + image.getWidth(null) + this.iconGap, Math.max(image2.getHeight(null), image.getHeight(null)), 2);
        bufferedImage.getGraphics().drawImage(image2, 0, bufferedImage.getHeight() / 2 - image2.getHeight(null) / 2, null);
        bufferedImage.getGraphics().drawImage(image, image2.getWidth(null) + this.iconGap, bufferedImage.getHeight() / 2 - image.getHeight(null) / 2, null);
        return new ImageIcon(bufferedImage);
    }

    private ImageIcon crossfadeIcons(Icon icon, Icon icon2) {
        Image image;
        Image image2 = icon2 instanceof ImageIcon ? ((ImageIcon)icon2).getImage() : null;
        Image image3 = image = icon instanceof ImageIcon ? ((ImageIcon)icon).getImage() : null;
        if (icon2 != null && image2 == null && icon2.getIconWidth() > 0 && icon2.getIconHeight() > 0) {
            image2 = new BufferedImage(icon2.getIconWidth(), icon2.getIconHeight(), 2);
            icon2.paintIcon(this, image2.getGraphics(), 0, 0);
        }
        if (icon != null && image == null && icon.getIconWidth() > 0 && icon.getIconHeight() > 0) {
            image = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
            icon.paintIcon(this, image.getGraphics(), 0, 0);
        }
        if (image2 == null && image == null) {
            return new ImageIcon();
        }
        if (image2 == null) {
            return new ImageIcon(image);
        }
        if (image == null) {
            return new ImageIcon(image2);
        }
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        bufferedImage.getGraphics().drawImage(image, 0, 0, null);
        if (Orientation.left.equals((Object)this.orientation)) {
            bufferedImage.getGraphics().drawImage(image2, 0, 0, null);
        } else {
            bufferedImage.getGraphics().drawImage(image2, bufferedImage.getWidth() - image2.getWidth(null), 0, null);
        }
        return new ImageIcon(bufferedImage);
    }

    protected int getArrowIconWidth(Orientation orientation) {
        if (Orientation.left.equals((Object)orientation) || Orientation.right.equals((Object)orientation)) {
            return 4;
        }
        return 8;
    }

    protected int getArrowIconHeight(Orientation orientation) {
        if (Orientation.left.equals((Object)orientation) || Orientation.right.equals((Object)orientation)) {
            return 8;
        }
        return 4;
    }

    private int getMaxIconHeight() {
        int n = 0;
        if (this.icon != null) {
            n = Math.max(n, this.icon.getIconHeight());
        }
        if (this.disabledIcon != null) {
            n = Math.max(n, this.disabledIcon.getIconHeight());
        }
        if (this.rolloverIcon != null) {
            n = Math.max(n, this.rolloverIcon.getIconHeight());
        }
        if (this.rolloverSelectedIcon != null) {
            n = Math.max(n, this.rolloverSelectedIcon.getIconHeight());
        }
        return n;
    }

    private int getMaxIconWidth() {
        int n = 0;
        if (this.icon != null) {
            n = Math.max(n, this.icon.getIconWidth());
        }
        if (this.disabledIcon != null) {
            n = Math.max(n, this.disabledIcon.getIconWidth());
        }
        if (this.rolloverIcon != null) {
            n = Math.max(n, this.rolloverIcon.getIconWidth());
        }
        if (this.rolloverSelectedIcon != null) {
            n = Math.max(n, this.rolloverSelectedIcon.getIconWidth());
        }
        return n;
    }

    private static abstract class AbstractArrowIcon
    implements Icon {
        protected Color c;
        private int width;
        private int height;

        public AbstractArrowIcon(Color color, int n, int n2) {
            this.c = color;
            this.width = n;
            this.height = n2;
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }
    }

    private static class DownArrowIcon
    extends AbstractArrowIcon {
        public DownArrowIcon(Color color, int n, int n2) {
            super(color, n, n2);
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = graphics.getColor();
            int n3 = this.getIconWidth();
            int n4 = this.getIconHeight();
            graphics.setColor(this.c);
            graphics.fillPolygon(new int[]{n, n + n3 / 2, n + n3}, new int[]{n2, n2 + n4, n2}, 3);
            graphics.setColor(ColorUtils.darker((Color)this.c, (float)0.75f));
            graphics.drawLine(n + n3, n2, n + n3 / 2, n2 + n4);
            graphics.setColor(color);
        }
    }

    private static class LeftArrowIcon
    extends AbstractArrowIcon {
        public LeftArrowIcon(Color color, int n, int n2) {
            super(color, n, n2);
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = graphics.getColor();
            int n3 = this.getIconWidth();
            int n4 = this.getIconHeight();
            graphics.setColor(this.c);
            graphics.fillPolygon(new int[]{n += this.getIconWidth() - n3, n + n3, n + n3}, new int[]{(n2 += this.getIconHeight() - n4) + n4 / 2, n2, n2 + n4}, 3);
            graphics.setColor(ColorUtils.darker((Color)this.c, (float)0.75f));
            graphics.drawLine(n, n2 + n4 / 2, n + n3, n2 + n4);
            graphics.setColor(color);
        }
    }

    public static enum Orientation {
        top,
        left,
        bottom,
        right;

    }

    private class PopupHandler
    implements ActionListener {
        private PopupHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (DropDownButton.this.popupMenu != null && DropDownButton.this.isEnabled()) {
                DropDownButton.this.showPopupMenu();
            }
        }
    }

    private static class RightArrowIcon
    extends AbstractArrowIcon {
        public RightArrowIcon(Color color, int n, int n2) {
            super(color, n, n2);
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = graphics.getColor();
            int n3 = this.getIconWidth();
            int n4 = this.getIconHeight();
            graphics.setColor(this.c);
            graphics.fillPolygon(new int[]{n += this.getIconWidth() - n3, n + n3, n}, new int[]{n2 += this.getIconHeight() - n4, n2 + n4 / 2, n2 + n4}, 3);
            graphics.setColor(ColorUtils.darker((Color)this.c, (float)0.75f));
            graphics.drawLine(n + n3, n2 + n4 / 2, n, n2 + n4);
            graphics.setColor(color);
        }
    }

    private static class UpArrowIcon
    extends AbstractArrowIcon {
        public UpArrowIcon(Color color, int n, int n2) {
            super(color, n, n2);
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = graphics.getColor();
            int n3 = this.getIconWidth();
            int n4 = this.getIconHeight();
            graphics.setColor(this.c);
            graphics.fillPolygon(new int[]{n += this.getIconWidth() - n3, n + n3 / 2, n + n3}, new int[]{(n2 += this.getIconHeight() - n4) + n4, n2, n2 + n4}, 3);
            graphics.setColor(ColorUtils.darker((Color)this.c, (float)0.75f));
            graphics.drawLine(n + n3 / 2, n2, n + n3, n2 + n4);
            graphics.setColor(color);
        }
    }
}

