/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.actions.ui;

import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.ui.AbstractActionUI;
import com.agfa.pacs.impaxee.actions.ui.ActionUIFactory;
import com.agfa.pacs.impaxee.actions.ui.ActionUIScope;
import com.agfa.pacs.impaxee.actions.ui.ActionUIUtilities;
import com.agfa.pacs.impaxee.actions.ui.IActionUI;
import com.agfa.pacs.logging.ALogger;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JMenu;

public class AbstractParentActionUI<C extends JComponent>
extends AbstractActionUI<C> {
    private static final ALogger log = ALogger.getLogger(AbstractParentActionUI.class);
    private Collection<IActionUI> subActions;

    public AbstractParentActionUI(PAction pAction, C c, ActionUIScope actionUIScope) {
        super(pAction, c, actionUIScope);
        assert (ActionUIUtilities.hasSubActions(pAction)) : "create menu-action-ui error: action is leaf action!";
    }

    @Override
    protected void bindSubActions() {
        if (this.subActions == null) {
            this.subActions = new ArrayList<IActionUI>();
        } else {
            this.subActions.clear();
        }
        Container container = this.getParentComponent();
        PAction[] pActionArray = this.getAction().getSubactions();
        int n = pActionArray.length;
        int n2 = 0;
        while (n2 < n) {
            PAction pAction = pActionArray[n2];
            if (!"SEPARATOR".equals(pAction.getID())) {
                try {
                    IActionUI iActionUI;
                    Component component = this.findComponentForSubAction(container, pAction);
                    if (component != null && (iActionUI = ActionUIFactory.createUI(pAction, component, this.getScope())) != null) {
                        this.registerSubActionListener(iActionUI.getAction(), iActionUI);
                        this.subActions.add(iActionUI);
                    }
                }
                catch (Exception exception) {
                    log.error("Creating action-ui for sub-action '" + pAction.getID() + "' failed!", (Throwable)exception);
                }
            }
            ++n2;
        }
    }

    @Override
    protected void releaseSubActions() {
        if (this.subActions != null) {
            for (IActionUI iActionUI : this.subActions) {
                this.unregisterSubActionListener(iActionUI.getAction(), iActionUI);
                iActionUI.release();
            }
            this.subActions.clear();
        }
    }

    protected Container getParentComponent() {
        return this.getComponent();
    }

    protected void registerSubActionListener(PAction pAction, IActionUI iActionUI) {
    }

    protected void unregisterSubActionListener(PAction pAction, IActionUI iActionUI) {
    }

    protected final Component findComponentForSubAction(Container container, PAction pAction) {
        Component[] componentArray;
        Component[] componentArray2 = componentArray = container instanceof JMenu ? ((JMenu)container).getMenuComponents() : container.getComponents();
        if (componentArray != null) {
            Component[] componentArray3 = componentArray;
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component component;
                Component component2 = componentArray3[n2];
                if (component2.getName() != null && component2.getName().equals(pAction.getID())) {
                    return component2;
                }
                if (component2 instanceof Container && (component = this.findComponentForSubAction((Container)component2, pAction)) != null) {
                    return component;
                }
                ++n2;
            }
        }
        return null;
    }

    protected final PAction findSubActionForComponent(Component component) {
        if (this.subActions != null) {
            String string = component.getName();
            for (IActionUI iActionUI : this.subActions) {
                PAction pAction = iActionUI.getAction();
                if (string == null || !string.equals(pAction.getID())) continue;
                return pAction;
            }
        }
        return null;
    }
}

