/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.actions;

import com.agfa.pacs.base.swing.util.EventUtil;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PActionFactory;
import com.agfa.pacs.impaxee.actions.PActionProviderFactory;
import com.agfa.pacs.impaxee.actions.PDataAction;
import com.agfa.pacs.impaxee.actions.PDataActionFactory;
import com.agfa.pacs.impaxee.actions.PDataActionProviderFactory;
import com.agfa.pacs.impaxee.actions.PDataProvider;
import com.agfa.pacs.impaxee.actions.PDataScope;
import com.agfa.pacs.impaxee.actions.impl.ActionNotFoundException;
import com.agfa.pacs.impaxee.actions.impl.DummyPDataProvider;
import com.agfa.pacs.impaxee.actions.impl.DuplicateActionException;
import com.agfa.pacs.logging.ALogger;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class PActionRegistry {
    private static final ALogger log = ALogger.getLogger(PActionRegistry.class);
    private static Map<String, PAction> actions = new HashMap<String, PAction>();
    private static Map<String, PDataAction> dataActions = new HashMap<String, PDataAction>();
    public static final char ID_DELIMITER = '@';

    static {
        PActionRegistry.init();
    }

    public static PAction getAction(String string) {
        return PActionRegistry.getActionInt(string);
    }

    public static PAction getActionNoException(String string) {
        try {
            return PActionRegistry.getActionInt(string);
        }
        catch (ActionNotFoundException actionNotFoundException) {
            return null;
        }
    }

    public static PAction getAction(String string, PDataProvider pDataProvider) {
        if (pDataProvider != null && dataActions.containsKey(string)) {
            return PActionRegistry.getDataAction(string, pDataProvider);
        }
        return PActionRegistry.getActionInt(string);
    }

    public static void checkInit() {
    }

    public static List<PAction> getShortcutActions() {
        List<PAction> list = PActionRegistry.getAllActions(null);
        Iterator<PAction> iterator = list.iterator();
        while (iterator.hasNext()) {
            PAction pAction = iterator.next();
            if ("INTERNAL".equals(pAction.getGroupName()) && pAction.getDefaultShortcut() == null) {
                iterator.remove();
                continue;
            }
            if (pAction.getActionType() != PAction.ActionType.None) {
                iterator.remove();
                continue;
            }
            if (pAction.isAvailable()) continue;
            iterator.remove();
        }
        return list;
    }

    private static boolean isUsableForToolbar(PAction pAction, PDataProvider.ProviderType providerType) {
        if (!pAction.isUpdatingListeners()) {
            return pAction.getActionType().isGroup() && pAction.hasIcon();
        }
        if (pAction.getActionType() == PAction.ActionType.TextLabel && providerType == PDataProvider.ProviderType.Screen) {
            return true;
        }
        if (pAction.getActionType() == PAction.ActionType.None) {
            if (pAction.hasIcon()) {
                return true;
            }
            return providerType == PDataProvider.ProviderType.Screen && pAction.getCaption() != null && pAction.getCaption().length() <= 5;
        }
        return providerType == PDataProvider.ProviderType.Screen || pAction.getActionType() != PAction.ActionType.FlatGroup;
    }

    public static List<PAction> getAllUserConfigurableToolbarActions(PDataProvider.ProviderType providerType) {
        List<PAction> list = PActionRegistry.getAllUserConfigurableActions(providerType);
        Iterator<PAction> iterator = list.iterator();
        while (iterator.hasNext()) {
            PAction pAction = iterator.next();
            if (PActionRegistry.isUsableForToolbar(pAction, providerType)) continue;
            iterator.remove();
        }
        return list;
    }

    public static List<PAction> getAllUserConfigurableTextActions() {
        List<PAction> list = PActionRegistry.getAllUserConfigurableActions(null);
        Iterator<PAction> iterator = list.iterator();
        while (iterator.hasNext()) {
            PAction pAction = iterator.next();
            if (pAction.getCaption() != null) continue;
            iterator.remove();
        }
        return list;
    }

    private static List<PAction> getAllUserConfigurableActions(PDataProvider.ProviderType providerType) {
        List<PAction> list = PActionRegistry.getAllActions(providerType);
        Iterator<PAction> iterator = list.iterator();
        while (iterator.hasNext()) {
            PAction pAction = iterator.next();
            if ("INTERNAL".equals(pAction.getGroupName())) {
                iterator.remove();
                continue;
            }
            if (pAction.getScopes() != null) {
                iterator.remove();
                continue;
            }
            if (pAction.isAvailable()) continue;
            iterator.remove();
        }
        return list;
    }

    public static List<PAction> getAllActions(PDataProvider.ProviderType providerType) {
        ArrayList<PAction> arrayList = new ArrayList<PAction>(500);
        arrayList.addAll(actions.values());
        DummyPDataProvider dummyPDataProvider = null;
        if (providerType != null) {
            dummyPDataProvider = new DummyPDataProvider(providerType);
        }
        for (PDataAction pDataAction : dataActions.values()) {
            if (providerType != null && pDataAction.canHandleDataProvider(providerType)) {
                arrayList.add(PActionRegistry.createDataAction(pDataAction.getID(), dummyPDataProvider));
                continue;
            }
            PDataScope[] pDataScopeArray = pDataAction.getAvailableScopes();
            int n = pDataScopeArray.length;
            int n2 = 0;
            while (n2 < n) {
                PDataScope pDataScope = pDataScopeArray[n2];
                arrayList.add(pDataAction.getAction(pDataScope));
                ++n2;
            }
        }
        return arrayList;
    }

    public static PAction getDataAction(String string, PDataScope pDataScope) {
        if (pDataScope == null) {
            throw new ActionNotFoundException(string);
        }
        PDataAction pDataAction = dataActions.get(string);
        if (pDataAction == null) {
            throw new ActionNotFoundException(string, pDataScope);
        }
        return pDataAction.getAction(pDataScope);
    }

    public static void invokeActionInAWTThread(String string, final Component component) {
        final PAction pAction = PActionRegistry.getActionInt(string);
        if (pAction != null && pAction.isAvailable() && pAction.isEnabled()) {
            EventUtil.invokeSynchronous((Runnable)new Runnable(){

                @Override
                public void run() {
                    pAction.perform(component);
                }
            });
        }
    }

    public static PAction getDataAction(String string, PDataProvider pDataProvider) {
        if (pDataProvider != null) {
            PAction pAction = pDataProvider.getAction(string);
            if (pAction == null) {
                throw new ActionNotFoundException(string);
            }
            return pAction;
        }
        throw new ActionNotFoundException(string);
    }

    public static PAction createDataAction(String string, PDataProvider pDataProvider) {
        if (pDataProvider == null) {
            throw new IllegalArgumentException();
        }
        PDataAction pDataAction = dataActions.get(string);
        if (pDataAction == null) {
            return null;
        }
        return pDataAction.createAction(pDataProvider);
    }

    /*
     * WARNING - void declaration
     */
    private static void init() {
        void var0_20;
        for (PDataAction pDataAction : PDataActionProviderFactory.getDataActions()) {
            if (dataActions.containsKey(pDataAction.getID())) {
                throw new DuplicateActionException(pDataAction.getID());
            }
            dataActions.put(pDataAction.getID(), pDataAction);
        }
        for (PDataAction pDataAction : PDataActionFactory.getDataActions()) {
            if (dataActions.containsKey(pDataAction.getID())) {
                throw new DuplicateActionException(pDataAction.getID());
            }
            dataActions.put(pDataAction.getID(), pDataAction);
        }
        for (PDataAction pDataAction : PDataActionFactory.getCompoundDataActions()) {
            if (dataActions.containsKey(pDataAction.getID())) {
                throw new DuplicateActionException(pDataAction.getID());
            }
            dataActions.put(pDataAction.getID(), pDataAction);
        }
        log.info("Found " + dataActions.size() + " data actions on system");
        if (log.isDebugEnabled()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : dataActions.keySet()) {
                stringBuilder.append(string).append(',');
            }
            log.debug("Data actions:" + stringBuilder.toString());
        }
        for (PAction pAction : PActionProviderFactory.getActions()) {
            if (actions.containsKey(pAction.getID())) {
                log.error("Duplicate action found:" + pAction.getID());
                continue;
            }
            actions.put(pAction.getID(), pAction);
        }
        boolean bl = false;
        while (var0_20 <= 2) {
            for (PAction pAction : PActionFactory.getActions((int)var0_20)) {
                if (actions.containsKey(pAction.getID())) {
                    throw new DuplicateActionException(pAction.getID());
                }
                actions.put(pAction.getID(), pAction);
            }
            ++var0_20;
        }
        log.info("Found " + actions.size() + " actions on system");
        if (log.isDebugEnabled()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : actions.keySet()) {
                stringBuilder.append(string).append(',');
            }
            log.debug("Actions:" + stringBuilder.toString());
        }
    }

    private static PAction getActionInt(String string) {
        PAction pAction = actions.get(string);
        if (pAction != null) {
            return pAction;
        }
        if (string.indexOf(64) != -1) {
            String[] stringArray = StringUtils.split((String)string, (char)'@');
            if (stringArray.length != 2) {
                throw new ActionNotFoundException(string);
            }
            PDataAction pDataAction = dataActions.get(stringArray[0]);
            if (pDataAction == null) {
                throw new ActionNotFoundException(string);
            }
            try {
                PDataScope pDataScope = PDataScope.valueOf(stringArray[1]);
                return pDataAction.getAction(pDataScope);
            }
            catch (Exception exception) {
                throw new ActionNotFoundException(string);
            }
        }
        throw new ActionNotFoundException(string);
    }
}

