/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee;

import com.agfa.integration.IntegrationFrameworkFactory;
import com.agfa.pacs.data.dicom.RetrieveDeniedException;
import com.agfa.pacs.event.ActionInfo;
import com.agfa.pacs.event.EventEngineFactory;
import com.agfa.pacs.event.IEvent;
import com.agfa.pacs.event.IEventEngine;
import com.agfa.pacs.exceptionhandler.ExceptionHandlerFactory;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.data.fetcher.DataHandlerProviderFactory;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.listtext.swingx.controls.MessageDialog;
import com.agfa.pacs.logging.ALogger;
import com.tiani.gui.util.LocationUtil;
import com.tiani.util.message.Message;
import java.awt.Dimension;
import java.awt.Point;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.net.SocketException;
import java.net.UnknownHostException;

public class ImpaxEEUtils {
    private static final ALogger log = ALogger.getLogger(ImpaxEEUtils.class);
    private static String[] actorsSupportingReports = new String[]{"ISoftRIS", "MEDOS"};
    private static Object networkProblemLock = new Object();
    private static Long networkProblemTimestamp = null;
    private static final long TIME_TO_RETRIEVE_ALL_ERRORS = 7000L;

    public static boolean isActorSupportingReportsActive() {
        String[] stringArray = actorsSupportingReports;
        int n = actorsSupportingReports.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (IntegrationFrameworkFactory.getInstance().isActorRunning(string)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static void showFolder() {
        ImpaxEEUtils.showLTA("LIST");
    }

    private static void showLTA(String string) {
        IEventEngine iEventEngine = EventEngineFactory.getInstance();
        int n = iEventEngine.getEventID("LTA_AREA_VISIBILITY_REQUEST");
        IEvent iEvent = iEventEngine.createEvent(n, null, null, (Serializable)((Object)"LTA"), ActionInfo.SINGLE);
        iEvent.setDestination(null, "lta");
        iEvent.setPayload((Object)string);
        iEventEngine.sendEvent(iEvent);
        n = iEventEngine.getEventID("focus.FRAME_REQUEST_FOCUS");
        IEvent iEvent2 = iEventEngine.createEvent(n, null, null, (Serializable)((Object)"LTA"), ActionInfo.SINGLE);
        iEvent2.setDestination(null, "focus");
        iEventEngine.sendEvent(iEvent2);
    }

    public static void showTextArea() {
        ImpaxEEUtils.showLTA("TEXT");
    }

    public static Dimension horizontalXVertical2Dimension(String string) {
        Dimension dimension = new Dimension();
        String[] stringArray = string.split("[xX]");
        if (stringArray.length != 2) {
            return null;
        }
        try {
            dimension.width = Integer.parseInt(stringArray[0]);
        }
        catch (Exception exception) {
            log.warn(String.valueOf(stringArray[0]) + " is not a valid row count");
            return null;
        }
        try {
            dimension.height = Integer.parseInt(stringArray[1]);
        }
        catch (Exception exception) {
            log.warn(String.valueOf(stringArray[1]) + " is not a valid column count");
            return null;
        }
        return dimension;
    }

    public static boolean isIn(String[] stringArray, String string) {
        if (string == null) {
            return false;
        }
        if (stringArray == null) {
            return false;
        }
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray2[n2];
            if (string.equals(string2)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String fillZeroLeft(int n, int n2) {
        String string = "" + n;
        while (string.length() < n2) {
            string = "0" + string;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleLoadingProblem(String string, String string2, Throwable throwable) {
        ExceptionHandlerFactory.getInstance().handleException(throwable);
        if (throwable == null || throwable instanceof SocketException || throwable instanceof FileNotFoundException || throwable instanceof UnknownHostException || throwable instanceof RetrieveDeniedException) {
            if (networkProblemTimestamp != null && System.currentTimeMillis() - networkProblemTimestamp > 7000L) {
                networkProblemTimestamp = null;
            }
            if (networkProblemTimestamp == null) {
                Object object = networkProblemLock;
                synchronized (object) {
                    networkProblemTimestamp = System.currentTimeMillis();
                    boolean bl = throwable instanceof RetrieveDeniedException;
                    log.error("Due to {} all loading queues will be cleared. Image: {}", (Object)(bl ? "missing study permissions" : "a network problem"), (Object)string);
                    DataHandlerProviderFactory.getInstance().getDataHandlerProvider().getFetcher().clear();
                    String string3 = bl ? "RetrieveDenied" : "NetworkProblem";
                    ImpaxEEUtils.handleProblem(Messages.getString("ImpaxEEUtils.DialogTitle." + string3), Messages.getString("ImpaxEEUtils.DialogMessage." + string3), true);
                }
            }
        }
    }

    public static void handleProblem(final String string, final String string2, final boolean bl) {
        new Thread(){

            @Override
            public void run() {
                if (bl) {
                    DataManager.getInstance().clearAllData();
                }
                Message.error(string, (Object)string2);
            }
        }.start();
    }

    public static void handleDisplayProblem(String string, String string2, boolean bl) {
        log.error("Display problem with image:" + string + " " + string2);
        ImpaxEEUtils.handleProblem(Messages.getString("ImpaxEEUtils.DisplayProblem"), string2, false);
    }

    public static void handleDisplayProblem(String string, String string2) {
        ImpaxEEUtils.handleDisplayProblem(string, string2, false);
    }

    public static String showMessageDialogCenteredInWindow(MessageDialog messageDialog) {
        Point point = LocationUtil.getProposedDialogLocationCenter();
        Dimension dimension = messageDialog.getSize();
        messageDialog.setLocation(point.x - dimension.width / 2, point.y - dimension.height / 2);
        messageDialog.setVisible(true);
        return messageDialog.getSelectedOption();
    }
}

