/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee;

import com.agfa.pacs.base.swing.lists.models.GenericDataMutableListModel;
import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.config.IConfigurationList;
import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.impaxee.utils.Checksumm;
import com.agfa.pacs.impaxee.utils.StorageStamp;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.security.role.RoleManagerFactory;
import com.tiani.config.xml.minijaxb.AbstractXmlElement;
import com.tiani.config.xml.minijaxb.XmlSaveable;
import com.tiani.config.xml.minijaxb.XmlSaver;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractRegistry<T extends AbstractXmlElement>
extends GenericDataMutableListModel<T> {
    private static final ALogger log = ALogger.getLogger(AbstractRegistry.class);
    protected static final String CONTENT_KEY = "content";
    protected Map<T, StorageStamp> storageStamps = new HashMap<T, StorageStamp>();
    private volatile boolean isStored = false;

    public AbstractRegistry(List<T> list, Comparator<T> comparator) {
        super(list, comparator);
    }

    protected IConfigurationProvider getConfigurationProviderForEnterpriseLevel() {
        IConfigurationProvider iConfigurationProvider = ConfigurationProviderFactory.getConfig().isSupportingRoles() ? ConfigurationProviderFactory.getAdministrationFactory().getConfigForRole(RoleManagerFactory.getInstance().getEnterpriseRole().getFullPath()) : ConfigurationProviderFactory.getConfig();
        return iConfigurationProvider;
    }

    protected synchronized void writeToConfig(String string) {
        if (this.isStored) {
            log.warn("Double storage of the registry:" + (Object)((Object)this));
            return;
        }
        Map<T, StorageStamp> map = this.storageStamps;
        this.storageStamps = new HashMap<T, StorageStamp>();
        IConfigurationProvider iConfigurationProvider = this.getConfigurationProviderForEnterpriseLevel();
        IConfigurationList iConfigurationList = iConfigurationProvider.getList(string);
        for (AbstractXmlElement object : this.getAll()) {
            XmlSaver xmlSaver = new XmlSaver((XmlSaveable)object);
            try {
                IConfigurationProvider iConfigurationProvider2;
                String string2;
                String string3 = xmlSaver.toXmlString();
                long l = Checksumm.getChecksumm(string3);
                if (map.containsKey(object)) {
                    string2 = map.get((Object)object).configId;
                    if (l != map.get((Object)object).crc) {
                        iConfigurationProvider2 = (IConfigurationProvider)iConfigurationList.getChildrenItems().get(string2);
                        if (iConfigurationProvider2 != null) {
                            iConfigurationProvider2.setText(CONTENT_KEY, string3);
                        } else {
                            log.warn("Items already deleted, skipping.");
                        }
                    }
                } else {
                    iConfigurationProvider2 = iConfigurationList.appendItem();
                    string2 = iConfigurationList.getIdOfLastNewElement();
                    iConfigurationProvider2.setText(CONTENT_KEY, string3);
                }
                this.storageStamps.put(object, new StorageStamp(string2, l));
                map.remove(object);
            }
            catch (Exception exception) {
                log.error("Cannot generate XML representation for: " + object, (Throwable)exception);
            }
        }
        for (StorageStamp storageStamp : map.values()) {
            try {
                iConfigurationList.remove(storageStamp.configId);
            }
            catch (Exception exception) {
                log.warn("Could not remove element", (Throwable)exception);
            }
        }
        this.isStored = true;
    }

    protected void loadFromConfig(String string) {
        this.removeAll();
        this.storageStamps.clear();
        IConfigurationList iConfigurationList = ConfigurationProviderFactory.getConfig().getList(string);
        for (Map.Entry entry : iConfigurationList.getChildrenItems().entrySet()) {
            String string2;
            T t;
            IConfigurationProvider iConfigurationProvider = (IConfigurationProvider)entry.getValue();
            if (!iConfigurationProvider.exists(CONTENT_KEY) || (t = this.parseXML(string2 = iConfigurationProvider.getText(CONTENT_KEY))) == null) continue;
            this.addElement(t);
            this.storageStamps.put(t, new StorageStamp((String)entry.getKey(), Checksumm.getChecksumm(string2)));
        }
    }

    protected abstract T parseXML(String var1);
}

