/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.hw.manager;

import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.cache.IMemoryAlertListener;
import com.agfa.pacs.cache.MemoryAlertHandler;
import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.data.hw.cache.DicomCacheDicomRetrieverProvider;
import com.agfa.pacs.data.hw.manager.DicomDataRequest;
import com.agfa.pacs.data.hw.manager.InputStreamDicomDataReader;
import com.agfa.pacs.data.hw.manager.RequestQueue;
import com.agfa.pacs.data.shared.data.IDicomDataListener;
import com.agfa.pacs.data.shared.data.cache.DicomCacheFactory;
import com.agfa.pacs.data.shared.data.cache.IDicomCache;
import com.agfa.pacs.data.shared.hw.DicomRetrieverProviderFactory;
import com.agfa.pacs.data.shared.hw.IDicomDataRequest;
import com.agfa.pacs.data.shared.hw.IDicomDataRequester;
import com.agfa.pacs.data.shared.hw.IDicomParser;
import com.agfa.pacs.data.shared.hw.IDicomRetriever;
import com.agfa.pacs.data.shared.hw.IDicomRetrieverProvider;
import com.agfa.pacs.data.shared.hw.IRequestVisitor;
import com.agfa.pacs.data.shared.lw.ILoadableInfo;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.lw.impl.FrameSelectionInfo;
import com.agfa.pacs.exceptionhandler.ExceptionHandlerFactory;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.IRequestQueueVisitor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import javax.swing.Timer;

public class DicomDataManager4
implements IDicomDataRequester {
    private static final ALogger log = ALogger.getLogger(DicomDataManager4.class);
    private static final DicomRetrieverProviderFactory factory = DicomRetrieverProviderFactory.getInstance();
    public static final byte DEFAULT_PRIORITY = (byte)(RequestQueue.NUM_PRIORITIES - 1);
    private IDicomRetriever dicomCacheRetriever;
    private final IDicomCache dicomCache = DicomCacheFactory.getInstance().getDicomCache();
    private final RequestQueue<DicomDataRequest> queue = new RequestQueue();
    private final LinkedBlockingQueue<DicomDataRequest> exclusiveQueue = new LinkedBlockingQueue();
    private final ILoadableInfo[] requestsInWork;
    private final int threadCount;
    private List<IDicomDataListener> globalDicomListeners = null;

    public DicomDataManager4() {
        IConfigurationProvider iConfigurationProvider = ConfigurationProviderFactory.getConfig().getNode("listtext.hw");
        int n = 2;
        int n2 = 3;
        if (iConfigurationProvider.getBoolean("slowClient") || DicomDataManager4.isVeryLowMemSystem() || Product.hasReducedResources()) {
            n = 1;
            n2 = 1;
        } else if (DicomDataManager4.isLowMemSystem()) {
            n = 1;
            n2 = 2;
        }
        String string = iConfigurationProvider.getString("loadingConfiguration");
        if (!string.equalsIgnoreCase("auto")) {
            try {
                String[] stringArray = string.split(",");
                if (stringArray.length == 2) {
                    n = Integer.parseInt(stringArray[0]);
                    n2 = Integer.parseInt(stringArray[1]);
                }
            }
            catch (NumberFormatException numberFormatException) {
                log.error("Could not read configuration", (Throwable)numberFormatException);
            }
        }
        this.threadCount = n2 + n;
        if (iConfigurationProvider.getBoolean("autoSpeedReduction")) {
            MemoryAlertHandler.addMemoryAlertListener((IMemoryAlertListener)new MemoryAlerter());
        }
        log.info("Retrieving threads configuration:" + n + "," + n2);
        this.requestsInWork = new ILoadableInfo[this.threadCount];
        this.dicomCacheRetriever = DicomCacheDicomRetrieverProvider.getCacheRetriever();
        int n3 = 0;
        while (n3 < this.threadCount) {
            this.createRetrievingThread(n3, n3 < n);
            ++n3;
        }
        new ExclusiveRetrievingThread().start();
    }

    public static boolean isLowMemSystem() {
        return Runtime.getRuntime().maxMemory() < 1363148800L;
    }

    public static boolean isVeryLowMemSystem() {
        return Runtime.getRuntime().maxMemory() < 629145600L;
    }

    protected void createRetrievingThread(int n, boolean bl) {
        RetrievingThread retrievingThread = new RetrievingThread(n, bl);
        retrievingThread.start();
    }

    public int getSize() {
        return this.queue.getSize();
    }

    public byte getLowestPriority() {
        return DEFAULT_PRIORITY;
    }

    public DicomDataRequest initializeDicomRequest(DicomDataRequest dicomDataRequest) {
        ILoadableInfo iLoadableInfo = dicomDataRequest.getLoadableInfo();
        IDicomRetrieverProvider iDicomRetrieverProvider = factory.getProvider(iLoadableInfo.getInstanceInfo(), iLoadableInfo);
        if (iDicomRetrieverProvider != null) {
            dicomDataRequest.setRetriever(iDicomRetrieverProvider.createDicomRetriever());
            return dicomDataRequest;
        }
        log.error("No DicomRetriever for " + dicomDataRequest);
        dicomDataRequest.dicomDataError(null, "No retriever", new IllegalStateException("No Retriever"));
        return null;
    }

    private void addRequestInternal(DicomDataRequest dicomDataRequest) {
        if (dicomDataRequest.getDataProviderIdentifier().exclusiveRetrieval()) {
            this.exclusiveQueue.add(dicomDataRequest);
        } else {
            DicomDataRequest dicomDataRequest2 = this.queue.find(dicomDataRequest.getKey());
            if (dicomDataRequest2 == null) {
                this.queue.addAtTop(dicomDataRequest, dicomDataRequest.getPriority());
            } else if (!dicomDataRequest2.addListener((IDicomDataListener)dicomDataRequest)) {
                log.info("Duplicate cannot be added, retry");
                do {
                    try {
                        Thread.sleep(400L);
                    }
                    catch (InterruptedException interruptedException) {}
                } while (this.queue.find(dicomDataRequest.getKey()) != null);
                this.queue.addAtTop(dicomDataRequest, dicomDataRequest.getPriority());
            } else {
                this.queue.changePriority(dicomDataRequest, dicomDataRequest.getPriority());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRequest(IDicomDataRequest iDicomDataRequest) {
        DicomDataRequest dicomDataRequest = this.initializeDicomRequest((DicomDataRequest)iDicomDataRequest);
        if (dicomDataRequest != null) {
            RequestQueue<DicomDataRequest> requestQueue = this.queue;
            synchronized (requestQueue) {
                this.addRequestInternal(dicomDataRequest);
                this.queue.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRequests(Collection collection) {
        Object object2;
        Collection collection2 = collection;
        DicomDataRequest[] dicomDataRequestArray = new DicomDataRequest[collection.size()];
        int n = 0;
        for (Object object2 : collection2) {
            DicomDataRequest dicomDataRequest = this.initializeDicomRequest((DicomDataRequest)object2);
            if (dicomDataRequest != null) {
                dicomDataRequestArray[n] = dicomDataRequest;
            }
            ++n;
        }
        object2 = this.queue;
        synchronized (object2) {
            DicomDataRequest[] dicomDataRequestArray2 = dicomDataRequestArray;
            int n2 = dicomDataRequestArray.length;
            int n3 = 0;
            while (n3 < n2) {
                DicomDataRequest dicomDataRequest = dicomDataRequestArray2[n3];
                if (dicomDataRequest != null) {
                    this.addRequestInternal(dicomDataRequest);
                }
                ++n3;
            }
            this.queue.notifyAll();
        }
    }

    public synchronized void addGlobalListener(IDicomDataListener iDicomDataListener) {
        ArrayList<IDicomDataListener> arrayList = new ArrayList<IDicomDataListener>();
        if (this.globalDicomListeners != null) {
            arrayList.addAll(this.globalDicomListeners);
        }
        arrayList.add(iDicomDataListener);
        List<IDicomDataListener> list = this.globalDicomListeners;
        this.globalDicomListeners = arrayList;
        if (list != null) {
            list.clear();
        }
    }

    List<IDicomDataListener> getGlobalListeners() {
        return this.globalDicomListeners;
    }

    public synchronized void removeGlobalListener(IDicomDataListener iDicomDataListener) {
        ArrayList<IDicomDataListener> arrayList = new ArrayList<IDicomDataListener>();
        if (this.globalDicomListeners != null) {
            arrayList.addAll(this.globalDicomListeners);
        }
        arrayList.remove(iDicomDataListener);
        this.globalDicomListeners = arrayList.isEmpty() ? null : arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changePriority(Collection<ILoadableInfo> collection, byte by) {
        RequestQueue<DicomDataRequest> requestQueue = this.queue;
        synchronized (requestQueue) {
            for (ILoadableInfo iLoadableInfo : collection) {
                DicomDataRequest dicomDataRequest = this.queue.find(iLoadableInfo);
                if (dicomDataRequest == null) continue;
                this.queue.changePriority(dicomDataRequest, (int)by);
            }
            this.queue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean changePriorityToHigherAndAdvance(ILoadableInfo iLoadableInfo, byte by) {
        RequestQueue<DicomDataRequest> requestQueue = this.queue;
        synchronized (requestQueue) {
            String string = iLoadableInfo.getUID();
            int n = 0;
            while (true) {
                if (n >= this.threadCount) {
                    DicomDataRequest dicomDataRequest = this.queue.find(iLoadableInfo);
                    if (dicomDataRequest == null) break;
                    this.queue.raisePriority(dicomDataRequest, by);
                    this.queue.notify();
                    return true;
                }
                ILoadableInfo iLoadableInfo2 = this.requestsInWork[n];
                if (iLoadableInfo2 != null && iLoadableInfo2.getUID().equals(string)) {
                    return true;
                }
                ++n;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changePriorityToHigherAndAdvance(Collection<ILoadableInfo> collection, byte by) {
        RequestQueue<DicomDataRequest> requestQueue = this.queue;
        synchronized (requestQueue) {
            for (ILoadableInfo iLoadableInfo : collection) {
                DicomDataRequest dicomDataRequest = this.queue.find(iLoadableInfo);
                if (dicomDataRequest == null) continue;
                this.queue.raisePriority(dicomDataRequest, by);
            }
            this.queue.notifyAll();
        }
    }

    public void cancelRequests(Collection<IDicomDataRequest> collection) {
        ArrayList<ILoadableInfo> arrayList = new ArrayList<ILoadableInfo>(collection.size());
        for (IDicomDataRequest iDicomDataRequest : collection) {
            arrayList.add(iDicomDataRequest.getLoadableInfo());
        }
        this.cancelObjectRequests(arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelObjectRequests(Collection<? extends ILoadableInfo> collection) {
        RequestQueue<DicomDataRequest> requestQueue = this.queue;
        synchronized (requestQueue) {
            if (this.queue.getSize() == 0) {
                return;
            }
            if (collection != null) {
                for (ILoadableInfo iLoadableInfo : collection) {
                    DicomDataRequest dicomDataRequest = this.queue.find(iLoadableInfo);
                    if (dicomDataRequest == null) {
                        return;
                    }
                    switch (dicomDataRequest.getState()) {
                        case Initialized: {
                            this.queue.remove(dicomDataRequest);
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelRequest(IDicomDataRequest iDicomDataRequest) {
        RequestQueue<DicomDataRequest> requestQueue = this.queue;
        synchronized (requestQueue) {
            DicomDataRequest dicomDataRequest = this.queue.find(iDicomDataRequest.getLoadableInfo());
            if (dicomDataRequest == null) {
                return;
            }
            switch (dicomDataRequest.getState()) {
                case Initialized: {
                    this.queue.remove(dicomDataRequest);
                }
            }
        }
    }

    public void setIdleState(boolean bl) {
        this.queue.setIdle(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitRequests(IRequestVisitor iRequestVisitor) {
        RequestQueue<DicomDataRequest> requestQueue = this.queue;
        synchronized (requestQueue) {
            this.queue.visit((IRequestQueueVisitor<DicomDataRequest>)iRequestVisitor);
        }
    }

    public DicomDataRequest createDicomDataRequest(IObjectInfo iObjectInfo) {
        return new DicomDataRequest((ILoadableInfo)iObjectInfo, DEFAULT_PRIORITY, this.globalDicomListeners);
    }

    public DicomDataRequest createDicomDataRequest(ILoadableInfo iLoadableInfo, byte by) {
        return new DicomDataRequest(iLoadableInfo, by, this.globalDicomListeners);
    }

    public DicomDataRequest createDicomDataRequest(IObjectInfo iObjectInfo, byte by) {
        return new DicomDataRequest((ILoadableInfo)iObjectInfo, by, this.globalDicomListeners);
    }

    public void clearQueues(int n, int n2) {
        this.queue.resetQueues((byte)n, (byte)n2);
    }

    public void clearAllQueues() {
        this.queue.resetAllQueues();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DicomDataRequest findRequest(ILoadableInfo iLoadableInfo) {
        RequestQueue<DicomDataRequest> requestQueue = this.queue;
        synchronized (requestQueue) {
            return this.queue.find(iLoadableInfo);
        }
    }

    public int[] getRequestQueueState() {
        return this.queue.getQueueSizes();
    }

    public IDicomParser createParser(InputStream inputStream, String string, IDicomDataRequest iDicomDataRequest, IDicomDataListener iDicomDataListener) {
        boolean bl = false;
        if (iDicomDataRequest != null) {
            bl = ((DicomDataRequest)iDicomDataRequest).getPriority() != DEFAULT_PRIORITY;
        } else if (iDicomDataListener instanceof DicomDataRequest) {
            bl = ((DicomDataRequest)iDicomDataListener).getPriority() != DEFAULT_PRIORITY;
        }
        return new InputStreamDicomDataReader(inputStream, string, iDicomDataListener, bl);
    }

    public byte getDefaultPrority() {
        return DEFAULT_PRIORITY;
    }

    public IDicomDataRequest createPixelDataRequest(IObjectInfo iObjectInfo, int n, byte by) {
        FrameSelectionInfo frameSelectionInfo = new FrameSelectionInfo(iObjectInfo, n, n, 1);
        return this.createDicomDataRequest((ILoadableInfo)frameSelectionInfo, by);
    }

    static /* synthetic */ RequestQueue access$3(DicomDataManager4 dicomDataManager4) {
        return dicomDataManager4.queue;
    }

    static /* synthetic */ ILoadableInfo[] access$4(DicomDataManager4 dicomDataManager4) {
        return dicomDataManager4.requestsInWork;
    }

    private class ExclusiveRetrievingThread
    extends Thread {
        public ExclusiveRetrievingThread() {
            this.setName("ExclusiveRetrievingThread");
            this.setDaemon(true);
            this.setPriority(4);
        }

        @Override
        public void run() {
            IDicomRetriever iDicomRetriever = null;
            DicomDataRequest dicomDataRequest = null;
            String string = null;
            String string2 = null;
            while (true) {
                try {
                    while (true) {
                        if ((dicomDataRequest = (DicomDataRequest)DicomDataManager4.this.exclusiveQueue.take()).isFromCache()) {
                            ILoadableInfo iLoadableInfo = dicomDataRequest.getLoadableInfo();
                            string = iLoadableInfo.getSOPInstanceUID();
                            string2 = iLoadableInfo.getStudyUID();
                            if (!iLoadableInfo.isFrameSelection() && DicomDataManager4.this.dicomCache.hasInstance(string2, string, dicomDataRequest.getRequiredFrames())) {
                                dicomDataRequest.getDicomRetriever();
                                DicomDataManager4.this.dicomCacheRetriever.process((IDicomDataRequest)dicomDataRequest);
                                continue;
                            }
                        }
                        if ((iDicomRetriever = dicomDataRequest.getDicomRetriever()) != null) {
                            iDicomRetriever.process((IDicomDataRequest)dicomDataRequest);
                            continue;
                        }
                        log.warn("No retriever available");
                    }
                }
                catch (Throwable throwable) {
                    log.error("", throwable);
                    ExceptionHandlerFactory.getInstance().handleException(throwable);
                    continue;
                }
                break;
            }
        }
    }

    private class MemoryAlerter
    implements IMemoryAlertListener,
    ActionListener {
        private volatile Timer timer;

        private MemoryAlerter() {
        }

        public long memoryAlert(long l, boolean bl) {
            if (bl) {
                if (this.timer != null) {
                    this.timer.restart();
                } else {
                    Timer timer = new Timer(2000, this);
                    log.info("Reduce loading speed due to reduced memory");
                    timer.setRepeats(false);
                    timer.start();
                    this.timer = timer;
                }
                DicomDataManager4.this.setIdleState(false);
            }
            return 0L;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DicomDataManager4.this.setIdleState(true);
            log.info("Restore loading speed");
            this.timer = null;
        }
    }

    private class RetrievingThread
    extends Thread {
        private int maxPriority = RequestQueue.NUM_PRIORITIES;
        private final int number;

        public RetrievingThread(int n, boolean bl) {
            this.number = n;
            String string = "RetrievingThread-" + n;
            if (bl) {
                string = "Fast" + string;
            }
            this.setName(string);
            if (bl) {
                this.maxPriority = 1;
            }
            this.setDaemon(true);
            if (bl) {
                this.setPriority(Math.max(4, 2));
            } else {
                this.setPriority(1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            var1_1 = null;
            var2_2 = null;
            var3_3 = null;
            var5_4 = null;
            while (true) {
                try {
                    while (true) lbl-1000:
                    // 3 sources

                    {
                        var2_2 = null;
                        var1_1 = null;
                        try {
                            var6_6 = DicomDataManager4.access$3(DicomDataManager4.this);
                            synchronized (var6_6) {
                                var2_2 = (DicomDataRequest)DicomDataManager4.access$3(DicomDataManager4.this).peek(this.maxPriority);
                                if (var2_2 != null) {
                                    if (var2_2.isFromCache()) {
                                        var4_5 = var2_2.getLoadableInfo();
                                        var3_3 = var4_5.getSOPInstanceUID();
                                        var5_4 = var4_5.getStudyUID();
                                        if (!var4_5.isFrameSelection() && DicomDataManager4.access$5(DicomDataManager4.this).hasInstance(var5_4, var3_3, var2_2.getRequiredFrames())) {
                                            var2_2.getDicomRetriever();
                                            var1_1 = DicomDataManager4.access$6(DicomDataManager4.this);
                                        }
                                    }
                                    if (!DicomDataManager4.access$3(DicomDataManager4.this).remove(var2_2)) {
                                        DicomDataManager4.access$7().info("Wrong on queue remove");
                                    }
                                    DicomDataManager4.access$4((DicomDataManager4)DicomDataManager4.this)[this.number] = var2_2.getLoadableInfo();
                                } else {
                                    DicomDataManager4.access$3(DicomDataManager4.this).checkConsistency();
                                }
                            }
                            if (var2_2 != null) {
                                if (var1_1 == null) {
                                    var1_1 = var2_2.getDicomRetriever();
                                }
                                if (var1_1 != null) {
                                    var1_1.process((IDicomDataRequest)var2_2);
                                } else {
                                    DicomDataManager4.access$7().warn("No retriever available");
                                }
                            }
                        }
                        catch (Throwable var7_9) {
                            if (var2_2 != null) {
                                var8_8 = DicomDataManager4.access$3(DicomDataManager4.this);
                                synchronized (var8_8) {
                                    DicomDataManager4.access$4((DicomDataManager4)DicomDataManager4.this)[this.number] = null;
                                }
                            }
                            throw var7_9;
                        }
                        if (var2_2 == null) continue;
                        var8_8 = DicomDataManager4.access$3(DicomDataManager4.this);
                        synchronized (var8_8) {
                            DicomDataManager4.access$4((DicomDataManager4)DicomDataManager4.this)[this.number] = null;
                            continue;
                        }
                        break;
                    }
                }
                catch (Throwable var6_7) {
                    DicomDataManager4.access$7().error("", var6_7);
                    ExceptionHandlerFactory.getInstance().handleException(var6_7);
                    continue;
                }
                {
                    ** while (true)
                }
                break;
            }
        }
    }
}

