/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.hw.cache;

import com.agfa.pacs.base.util.DateTimeUtils;
import com.agfa.pacs.data.hw.manager.DicomDataRequest;
import com.agfa.pacs.data.shared.data.IDicomDataListener;
import com.agfa.pacs.data.shared.data.cache.DicomCacheFactory;
import com.agfa.pacs.data.shared.data.cache.IDicomCache;
import com.agfa.pacs.data.shared.dicom.UIDType;
import com.agfa.pacs.data.shared.dicom.UIDUtilities;
import com.agfa.pacs.data.shared.hw.AbstractDicomRetriever;
import com.agfa.pacs.data.shared.hw.DicomDataRequester;
import com.agfa.pacs.data.shared.hw.IDicomDataRequest;
import com.agfa.pacs.data.shared.lw.ILoadableInfo;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.pixel.IPixelDataInfo;
import com.agfa.pacs.logging.ALogger;
import java.util.Date;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.DatePrecision;

public class DicomCacheDicomRetriever
extends AbstractDicomRetriever {
    private static final IDicomCache dicomCache = DicomCacheFactory.getInstance().getDicomCache();
    private static final ALogger log = ALogger.getLogger(DicomCacheDicomRetriever.class);
    private static final DatePrecision PERFECT_PRECISION = new DatePrecision();

    private Date fetchTimestamp(Attributes attributes) {
        try {
            return attributes.getDate("dcm4che/archive", 4390934);
        }
        catch (Exception exception) {
            log.error("Could not read timestamp", (Throwable)exception);
            return null;
        }
    }

    protected void processImpl(IDicomDataRequest iDicomDataRequest) {
        Date date;
        IDicomDataRequest iDicomDataRequest2 = iDicomDataRequest;
        IObjectInfo iObjectInfo = iDicomDataRequest.getObjectInfo();
        Date date2 = this.fetchTimestamp(iObjectInfo.getAttributes());
        String string = iObjectInfo.getSOPInstanceUID();
        String string2 = iObjectInfo.getStudyUID();
        if (date2 != null && (date = dicomCache.getCacheTimestamp(string)) != null && date2.after(date)) {
            log.warn("Detected changed cache timestamp removing instance from cache:" + string + " Server:" + DateTimeUtils.dateTime2String((Date)date2) + " Cache:" + DateTimeUtils.dateTime2String((Date)date));
            IDicomCache iDicomCache = DicomCacheFactory.getInstance().getDicomCache();
            int n = iObjectInfo.getAttributes().getInt(0x280008, 1);
            iDicomCache.removeInstance(string2, string, n);
            DicomDataRequest dicomDataRequest = new DicomDataRequest((ILoadableInfo)iObjectInfo, 0, null);
            dicomDataRequest.setListener((IDicomDataListener)iDicomDataRequest);
            DicomDataRequester.getInstance().addRequest((IDicomDataRequest)dicomDataRequest);
            return;
        }
        int n = 1;
        try {
            try {
                Attributes attributes = dicomCache.getDataset(string2, string);
                boolean bl = UIDUtilities.isType((String)attributes.getString(524310), (UIDType)UIDType.Image) || attributes.getString(524310).equals("1.2.840.10008.5.1.4.1.1.481.2");
                iDicomDataRequest2.dicomDataAvailable(string, attributes, bl);
                if (bl) {
                    if (attributes.containsValue(0x280008)) {
                        n = attributes.getInt(0x280008, 0);
                    }
                    int n2 = 0;
                    while (n2 < n) {
                        IPixelDataInfo iPixelDataInfo = dicomCache.getPixelDataInfo(string2, string, n2, attributes);
                        iDicomDataRequest2.pixelDataAvailable(string, iPixelDataInfo, n2);
                        ++n2;
                    }
                }
            }
            catch (Exception exception) {
                iDicomDataRequest2.dicomDataError(string, "notify cached object", (Throwable)exception);
                iDicomDataRequest2.dicomDataFinished(string, IDicomDataListener.Status.Success, null);
            }
        }
        finally {
            iDicomDataRequest2.dicomDataFinished(string, IDicomDataListener.Status.Success, null);
        }
    }
}

