/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.glue.script;

import com.agfa.integration.IScriptHelperCreator;
import com.agfa.integration.ObjectID;
import com.agfa.pacs.base.swing.util.EventUtil;
import com.agfa.pacs.base.util.DicomUtils;
import com.agfa.pacs.data.shared.dicom.IDicomNode;
import com.agfa.pacs.data.shared.lw.IDataInfoSource;
import com.agfa.pacs.data.shared.lw.IDataProviderIdentifier;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PActionRegistry;
import com.agfa.pacs.impaxee.actions.PDataScope;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.glue.data.AbstractImageObjectData;
import com.agfa.pacs.impaxee.glue.script.AutoTestCapture;
import com.agfa.pacs.impaxee.glue.script.AutoTestLatch;
import com.agfa.pacs.impaxee.glue.script.ImageAreaScriptUtil;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.IHanging;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.impaxee.hanging.model.enums.MainLayoutType;
import com.agfa.pacs.impaxee.splitsort.model.ManualSplitAndSortPresets;
import com.agfa.pacs.impaxee.splitsort.model.ManualSplitAndSortPresetsType;
import com.agfa.pacs.impaxee.splitsort.model.xml.SplitAndSort;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.CompareUtils;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.base.data.IImageObjectData;
import com.tiani.base.data.IPatientData;
import com.tiani.base.data.IStudyData;
import com.tiani.jvision.event.TEvent;
import com.tiani.jvision.event.TEventDispatch;
import com.tiani.jvision.event.ZoomParameter;
import com.tiani.jvision.image.WindowValue;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.patinfo.DataSelectionManager;
import com.tiani.jvision.toptoolbar.FilterActions;
import com.tiani.jvision.toptoolbar.PluginActions;
import com.tiani.jvision.vis.ActivationMode;
import com.tiani.jvision.vis.Vis2;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplay2;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.Pair;
import org.dcm4che3.data.Attributes;

public class ImageAreaScriptHelper
implements IScriptHelperCreator {
    private static final ALogger log = ALogger.getLogger(ImageAreaScriptHelper.class);

    public Object createHelper() {
        return this;
    }

    public ObjectID getSelectedStudy() {
        IFrameObjectData iFrameObjectData = this.getSelectedData();
        if (iFrameObjectData == null) {
            return null;
        }
        IStudyData iStudyData = iFrameObjectData.getParent().getParent();
        IPatientData iPatientData = iStudyData.getParent();
        Attributes attributes = iStudyData.getDicomObject();
        Attributes attributes2 = iPatientData.getDicomObject();
        ObjectID objectID = ObjectID.forStudyUID((String)iStudyData.getStudyInstanceUID());
        objectID.setPatientID(attributes2.getString(0x100020));
        objectID.setIssuerOfPatientID(attributes2.getString(0x100021));
        objectID.setAccessionNr(attributes.getString(524368));
        objectID.setModalityInStudy(DicomUtils.getString((Attributes)attributes, (int)524385));
        return objectID;
    }

    public String getSelectedSeries() {
        IFrameObjectData iFrameObjectData = this.getSelectedData();
        if (iFrameObjectData == null) {
            return null;
        }
        return iFrameObjectData.getParent().getSeriesInstanceUID();
    }

    public IDicomNode getNodeOfSelectedData() {
        IDataProviderIdentifier iDataProviderIdentifier;
        IDataInfoSource iDataInfoSource;
        IImageObjectData iImageObjectData;
        IFrameObjectData iFrameObjectData = this.getSelectedData();
        if (iFrameObjectData != null && (iImageObjectData = iFrameObjectData.getMainFrame()) instanceof AbstractImageObjectData && (iDataInfoSource = ((AbstractImageObjectData)iImageObjectData).getFullDataInfo().getSource()) != null && (iDataProviderIdentifier = iDataInfoSource.getIdentifier()) instanceof IDicomNode) {
            return (IDicomNode)iDataProviderIdentifier;
        }
        return null;
    }

    public String getDicomTagValue(int n) {
        IFrameObjectData iFrameObjectData = this.getSelectedData();
        if (iFrameObjectData == null) {
            return null;
        }
        return iFrameObjectData.resolveString(n);
    }

    public String[] getDicomTagValues(int n) {
        IFrameObjectData iFrameObjectData = this.getSelectedData();
        if (iFrameObjectData == null) {
            return null;
        }
        return iFrameObjectData.resolveStrings(n);
    }

    public IFrameObjectData getSelectedData() {
        IDisplaySet iDisplaySet;
        VisDisplay2 visDisplay2 = JVision2.getMainFrame().getLastModifiedDisplay();
        if (visDisplay2 != null && (iDisplaySet = visDisplay2.getData().getDisplaySet()) != null) {
            return iDisplaySet.getOneObject();
        }
        return null;
    }

    public Attributes[] getSelectedImages(boolean bl) {
        VisDisplay2 visDisplay2 = JVision2.getMainFrame().getLastModifiedDisplay();
        if (visDisplay2 != null) {
            ArrayList<Attributes> arrayList = new ArrayList<Attributes>(visDisplay2.getVisCount());
            for (VisData visData : visDisplay2.getVis()) {
                if (!visData.isSelected()) continue;
                Attributes attributes = visData.getFrameData().getDicomObject();
                if (bl) {
                    attributes = new Attributes(attributes);
                    visData.getFrameData().getRawDataContainer().storeToDicom(attributes);
                }
                arrayList.add(attributes);
            }
            return arrayList.toArray(new Attributes[arrayList.size()]);
        }
        return null;
    }

    public String getDisplaySetIdentifier(int n) {
        IDisplaySet iDisplaySet;
        VisDisplay2 visDisplay2 = (VisDisplay2)JVision2.getMainFrame().getDisplays().get(n);
        if (visDisplay2.hasData() && (iDisplaySet = visDisplay2.getData().getDisplaySet()) != null) {
            return this.getFirstSOPInstanceUID(iDisplaySet);
        }
        return null;
    }

    @Deprecated
    public void startHangingListener() {
        AutoTestLatch.getInstance().startHangingListener();
    }

    @Deprecated
    public void stopHangingListener() {
        AutoTestLatch.getInstance().stopHangingListener();
    }

    @Deprecated
    public boolean waitForLoadedStudy(String string, long l) {
        return AutoTestLatch.getInstance().awaitStudyLoad(string, l);
    }

    public boolean startPlugin(String string, long l) {
        this.performAction(this.getPluginActionID(string));
        if (AutoTestLatch.getInstance().awaitPlugin(this.getPositionOfLastModifiedDisplay(), l)) {
            return true;
        }
        this.performAction(this.getPluginActionID(null));
        return false;
    }

    private String getPluginActionID(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(PluginActions.getPluginActionID((String)string));
        stringBuilder.append('@');
        stringBuilder.append(PDataScope.CurrentDisplay.name());
        return stringBuilder.toString();
    }

    private int getPositionOfLastModifiedDisplay() {
        VisDisplay2 visDisplay2 = JVision2.getMainFrame().getLastModifiedDisplay();
        if (visDisplay2 != null) {
            List list = JVision2.getMainFrame().getDisplays();
            int n = 0;
            while (n < list.size()) {
                if (visDisplay2.equals(list.get(n))) {
                    return n;
                }
                ++n;
            }
        }
        return 0;
    }

    @Deprecated
    public void waitForAllInitializedPlugins(long l) {
        AutoTestLatch.getInstance().awaitPlugins(l);
    }

    @Deprecated
    public boolean waitForInitializedPlugin(int n, long l) {
        return AutoTestLatch.getInstance().awaitPlugin(n, l);
    }

    public boolean isPluginReady(int n) {
        return ImageAreaScriptUtil.isPluginReady((VisDisplay2)JVision2.getMainFrame().getDisplays().get(n));
    }

    @Deprecated
    public boolean waitForActiveHanging(String string, long l) {
        return AutoTestLatch.getInstance().awaitHanging(string, l);
    }

    @Deprecated
    public void waitForAllAvailableImages(long l) {
        AutoTestLatch.getInstance().awaitImages(l);
    }

    @Deprecated
    public boolean waitForAvailableImage(int n, long l) {
        return AutoTestLatch.getInstance().awaitImage(n, l);
    }

    @Deprecated
    public Iterable<BufferedImage> createAllImages() {
        return AutoTestCapture.getInstance().createAllImages();
    }

    @Deprecated
    public BufferedImage createImage(int n) {
        return AutoTestCapture.getInstance().createImage(n);
    }

    @Deprecated
    public BufferedImage createCombinedImage() {
        return AutoTestCapture.getInstance().createCombinedImage();
    }

    @Deprecated
    public BufferedImage createSeriesThumbnails(int n) {
        return AutoTestCapture.getInstance().createSeriesThumbnails(n);
    }

    @Deprecated
    public String exportImageAreaToXml() {
        return AutoTestCapture.getInstance().exportImageAreaToXml();
    }

    @Deprecated
    public String exportMainFrameToXml() {
        return AutoTestCapture.getInstance().exportMainFrameToXml();
    }

    @Deprecated
    public String exportLoadedDataToXml() {
        return AutoTestCapture.getInstance().exportLoadedDataToXml();
    }

    @Deprecated
    public String exportActiveHangingToXml() {
        return AutoTestCapture.getInstance().exportActiveHangingToXml();
    }

    public void setDisplayLayout(int n, int n2) {
        JVision2.getMainFrame().setLytMode(MainLayoutType.variable, n, n2, true);
    }

    public void resetImages() {
        this.sendEventToAll(66, null);
    }

    public boolean setActiveHanging(String string) {
        Pair<IPatientRepresentation, IHanging> pair = ImageAreaScriptUtil.findHanging(string);
        if (pair == null) {
            log.warn("Hanging '{}' not found among available hangings.", (Object)string);
            return false;
        }
        DataSelectionManager.getInstance().setActiveHanging((IPatientRepresentation)pair.left, (IHanging)pair.right, true, false);
        return true;
    }

    public boolean setActivePatient(String string) {
        IPatientRepresentation iPatientRepresentation = DataManager.getInstance().getPatientRepresentation(string);
        if (iPatientRepresentation == null) {
            log.warn("Patient not found: " + string);
            return false;
        }
        return DataSelectionManager.getInstance().setCurrentPatient(iPatientRepresentation);
    }

    public void activateManualSplitAndSortPreset(String string, String string2) {
        this.activateManualSplitAndSortPreset(ManualSplitAndSortPresetsType.FULL, string, null, string2);
    }

    public void activateManualSplitAndSortPreset(final ManualSplitAndSortPresetsType manualSplitAndSortPresetsType, String string, String string2, String string3) {
        final IDisplaySet iDisplaySet = this.findDisplaySet(string, string2);
        if (iDisplaySet != null) {
            final SplitAndSort splitAndSort = new ManualSplitAndSortPresets(manualSplitAndSortPresetsType).loadPreset(string3);
            EventUtil.invokeSynchronous((Runnable)new Runnable(){

                @Override
                public void run() {
                    manualSplitAndSortPresetsType.applyManualSplitAndSort(iDisplaySet, splitAndSort);
                }
            });
        }
    }

    public void filterImages(String string) {
        this.performAction(PActionRegistry.getDataAction((String)FilterActions.getFilterActionID((FilterActions.FilterType)FilterActions.FilterType.valueOf((String)string)), (PDataScope)PDataScope.CurrentDisplay));
    }

    public void windowImages(int n, int n2) {
        this.windowImages(n, n2, false);
    }

    public void windowImages(double d, double d2) {
        this.windowImages(d, d2, true);
    }

    private void windowImages(double d, double d2, boolean bl) {
        this.sendEventToAll(63, new WindowValue(d, d2, bl));
    }

    public void windowCurrentDisplay(int n, int n2) {
        this.sendEventToCurrentDisplay(63, new WindowValue((double)n, (double)n2, false));
    }

    public void showDisplaySet(int n, String string) {
        final IDisplaySet iDisplaySet = this.findDisplaySet(null, string);
        if (iDisplaySet == null) {
            return;
        }
        final VisDisplay2 visDisplay2 = (VisDisplay2)JVision2.getMainFrame().getDisplays().get(n);
        EventUtil.invokeSynchronous((Runnable)new Runnable(){

            @Override
            public void run() {
                visDisplay2.initVisDisplay(iDisplaySet, null, true, ActivationMode.MANUAL);
            }
        });
    }

    public boolean selectDisplaySet(int n) {
        final VisDisplay2 visDisplay2 = (VisDisplay2)JVision2.getMainFrame().getDisplays().get(n);
        if (!visDisplay2.hasData()) {
            return false;
        }
        EventUtil.invokeSynchronous((Runnable)new Runnable(){

            @Override
            public void run() {
                visDisplay2.getFirstVis().makeTheLastModified();
            }
        });
        return true;
    }

    private IDisplaySet findDisplaySet(String string, String string2) {
        IPatientRepresentation iPatientRepresentation = DataSelectionManager.getInstance().getCurrentPatient();
        if (iPatientRepresentation == null) {
            log.warn("No display set found: No patient loaded.");
            return null;
        }
        IDisplaySet[] iDisplaySetArray = iPatientRepresentation.getDecompositionRuntime().getDisplaySets();
        int n = iDisplaySetArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDisplaySet iDisplaySet = iDisplaySetArray[n2];
            if (CompareUtils.equals((Object)string, (Object)iDisplaySet.getStudyUID()) || CompareUtils.equals((Object)this.getFirstSOPInstanceUID(iDisplaySet), (Object)string2)) {
                return iDisplaySet;
            }
            ++n2;
        }
        log.warn("No display set found for study instance UID {} and/or for SOP instance UID {}.", (Object)string, (Object)string2);
        return null;
    }

    private String getFirstSOPInstanceUID(IDisplaySet iDisplaySet) {
        IFrameObjectData[] iFrameObjectDataArray = iDisplaySet.getObjects();
        if (iFrameObjectDataArray != null && iFrameObjectDataArray.length > 0) {
            return iFrameObjectDataArray[0].getSOPInstanceUID();
        }
        return null;
    }

    public void removeAllDisplaySetsOfStudy(String string) {
        IStudyData iStudyData = DataManager.getInstance().getStudy(string);
        if (iStudyData == null) {
            log.warn("Study with UID " + string + " not found.");
            return;
        }
        IPatientRepresentation iPatientRepresentation = DataManager.getInstance().getPatientRepresentation(iStudyData.getParent().getKey());
        if (iPatientRepresentation == null) {
            log.warn("No patient for study with UID " + string + '.');
            return;
        }
        ArrayList<IDisplaySet> arrayList = new ArrayList<IDisplaySet>();
        IDisplaySet[] iDisplaySetArray = iPatientRepresentation.getDecompositionRuntime().getDisplaySets();
        int n = iDisplaySetArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDisplaySet iDisplaySet = iDisplaySetArray[n2];
            if (iStudyData.getKey().equals(iDisplaySet.getStudy().getKey())) {
                arrayList.add(iDisplaySet);
            }
            ++n2;
        }
        DataManager.getInstance().removeDisplaySet(arrayList.toArray(new IDisplaySet[arrayList.size()]), true);
    }

    public void performAction(String string) {
        this.performAction(PActionRegistry.getAction((String)string));
    }

    public void performAction(String string, int n) {
        PAction pAction = PActionRegistry.getAction((String)string);
        this.performAction(pAction.getSubactions()[n]);
    }

    public boolean isActionSelected(String string) {
        try {
            PAction pAction = PActionRegistry.getAction((String)string);
            if (pAction != null && pAction.isSelectable()) {
                return pAction.isSelected();
            }
        }
        catch (Exception exception) {
            log.warn("Determining selection status for action '" + string + "' failed.", (Throwable)exception);
        }
        return false;
    }

    private void performAction(final PAction pAction) {
        if (pAction == null || !pAction.isAvailable() || !pAction.isEnabled()) {
            if (log.isDebugEnabled()) {
                if (pAction == null) {
                    log.debug("No action given.");
                } else if (!pAction.isAvailable()) {
                    log.debug("Action is unavailable: " + pAction.getID());
                } else {
                    log.debug("Action is disabled: " + pAction.getID());
                }
            }
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                pAction.perform(null);
            }
        };
        try {
            EventUtil.invokeSynchronous((Runnable)runnable);
        }
        catch (Exception exception) {
            log.error("Unknown", (Throwable)exception);
        }
    }

    private void sendEventToAll(final int n, final Object object) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                TEvent tEvent = new TEvent(n);
                tEvent.interactionModifier = 2;
                TEventDispatch.sendEvent((TEvent)tEvent, (Object)object, (int)(TEventDispatch.ALL_DISPLAYS | TEventDispatch.ALL_VISUALS));
                for (Vis2 vis2 : JVision2.getMainFrame().getAllVis()) {
                    vis2.repaint();
                }
            }
        };
        try {
            EventUtil.invokeSynchronous((Runnable)runnable);
        }
        catch (Exception exception) {
            log.error("Unknown", (Throwable)exception);
        }
    }

    private void sendEventToCurrentDisplay(final int n, final Object object) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                TEventDispatch.sendEvent((TEvent)new TEvent(n), (Object)object);
                VisData visData = VisData.getLastModified();
                if (visData != null) {
                    for (Vis2 vis2 : visData.getParent().getVisDisplay().getVisViews()) {
                        vis2.repaint();
                    }
                }
            }
        };
        try {
            EventUtil.invokeSynchronous((Runnable)runnable);
        }
        catch (Exception exception) {
            log.error("Sending event to current display failed.", (Throwable)exception);
        }
    }

    public void zoomImages(double d) {
        this.sendEventToAll(2, new ZoomParameter(d));
    }

    public void trueSizeZoom() {
        PActionRegistry.getDataAction((String)"ZOOM_TRUE_SIZE", (PDataScope)PDataScope.CurrentDisplay).perform(null);
    }
}

