/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.glue.script;

import com.agfa.pacs.impaxee.PerformanceProfiler;
import com.agfa.pacs.impaxee.glue.script.ImageAreaScriptUtil;
import com.agfa.pacs.impaxee.hanging.IHanging;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.impaxee.hanging.impl.HangingCaseDisplay;
import com.agfa.pacs.listtext.lta.progress.ProgressManagerFactory;
import com.agfa.pacs.listtext.lta.util.WaitingUtil;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IStudyData;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.patinfo.DataSelectionListenerAdapter;
import com.tiani.jvision.patinfo.DataSelectionManager;
import com.tiani.jvision.patinfo.IDataSelectionListener;
import com.tiani.jvision.vis.Vis2;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.jvision.vis.VisScreen2;
import java.util.ConcurrentModificationException;
import java.util.List;

public class AutoTestLatch {
    private static final ALogger log = ALogger.getLogger(AutoTestLatch.class);
    private static final AutoTestLatch INSTANCE = new AutoTestLatch();
    private HangingListener listener;

    private AutoTestLatch() {
    }

    public static AutoTestLatch getInstance() {
        return INSTANCE;
    }

    public void awaitBackgroundTasks(long l) {
        WaitingUtil.waitFor((WaitingUtil.IWaitingHandler)new WaitingUtil.IWaitingHandler(){

            public boolean isWaiting() {
                return ProgressManagerFactory.getManager().hasRunningJobs();
            }
        }, (WaitingUtil.WaitingType)WaitingUtil.WaitingType.BACKGROUND_TASK, (long)l);
    }

    public void startHangingListener() {
        if (this.listener == null) {
            this.listener = new HangingListener();
            DataSelectionManager.getInstance().addListener((IDataSelectionListener)this.listener);
        }
    }

    public void stopHangingListener() {
        if (this.listener != null) {
            DataSelectionManager.getInstance().removeListener((IDataSelectionListener)this.listener);
            this.listener = null;
        }
    }

    public boolean awaitStudyLoad(final String string, long l) {
        try {
            PerformanceProfiler.getInstance().awaitStudyLoad(string, l);
        }
        catch (InterruptedException interruptedException) {
            log.warn("Waiting for loaded study interrupted.", (Throwable)interruptedException);
        }
        return WaitingUtil.waitFor((WaitingUtil.IWaitingHandler)new WaitingUtil.IWaitingHandler(){

            public boolean isWaiting() {
                return !AutoTestLatch.this.isStudyLoaded(string);
            }
        }, (WaitingUtil.WaitingType)WaitingUtil.WaitingType.STUDY_LOAD, (long)l);
    }

    boolean isStudyLoaded(String string) {
        IPatientRepresentation iPatientRepresentation = DataSelectionManager.getInstance().getCurrentPatient();
        if (iPatientRepresentation == null) {
            return false;
        }
        IStudyData iStudyData = iPatientRepresentation.getPatientData().getStudy(string);
        if (iStudyData == null) {
            return false;
        }
        return iStudyData.isStudyLoaded();
    }

    public void awaitPlugins(long l) {
        long l2 = System.currentTimeMillis();
        List list = JVision2.getMainFrame().getScreens();
        for (VisScreen2 visScreen2 : list) {
            List list2 = visScreen2.getDisplays();
            for (VisDisplay2 visDisplay2 : list2) {
                this.awaitPlugin(visDisplay2, WaitingUtil.getRemainingWaitingTime((long)l2, (long)l));
            }
        }
    }

    public boolean awaitPlugin(int n, long l) {
        return this.awaitPlugin((VisDisplay2)JVision2.getMainFrame().getDisplays().get(n), l);
    }

    private boolean awaitPlugin(final VisDisplay2 visDisplay2, long l) {
        return WaitingUtil.waitFor((WaitingUtil.IWaitingHandler)new WaitingUtil.IWaitingHandler(){

            public boolean isWaiting() {
                return !ImageAreaScriptUtil.isPluginReady(visDisplay2);
            }
        }, (WaitingUtil.WaitingType)WaitingUtil.WaitingType.PLUGIN_INIT, (long)l);
    }

    public boolean awaitHPEvaluation(final String string, long l) {
        if (string == null) {
            return true;
        }
        return WaitingUtil.waitFor((WaitingUtil.IWaitingHandler)new WaitingUtil.IWaitingHandler(){

            public boolean isWaiting() {
                boolean bl = ImageAreaScriptUtil.findHanging(string) == null;
                return bl;
            }
        }, (WaitingUtil.WaitingType)WaitingUtil.WaitingType.HP_EVALUATION, (long)l);
    }

    public boolean awaitHanging(final String string, long l) {
        if (string == null) {
            return true;
        }
        long l2 = System.currentTimeMillis();
        HangingCaseDisplay.waitForHP((long)l);
        return WaitingUtil.waitFor((WaitingUtil.IWaitingHandler)new WaitingUtil.IWaitingHandler(){

            public boolean isWaiting() {
                return !ImageAreaScriptUtil.isMatchingHanging(AutoTestLatch.this.getActiveHanging(), string);
            }
        }, (WaitingUtil.WaitingType)WaitingUtil.WaitingType.HANGING_APPLICATION, (long)WaitingUtil.getRemainingWaitingTime((long)l2, (long)l));
    }

    IHanging getActiveHanging() {
        if (this.listener == null) {
            return DataSelectionManager.getInstance().getActiveHanging();
        }
        return this.listener.getActiveHanging();
    }

    public void awaitImages(long l) {
        try {
            this.awaitImagesImpl(l);
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            log.warn("Layout change while waiting for available images, repeating ...", (Throwable)concurrentModificationException);
            WaitingUtil.sleep((WaitingUtil.WaitingType)WaitingUtil.WaitingType.OTHER, (long)500L);
            try {
                this.awaitImagesImpl(l);
            }
            catch (ConcurrentModificationException concurrentModificationException2) {
                log.warn("Layout change again while waiting for available images, aborting ...", (Throwable)concurrentModificationException2);
                WaitingUtil.sleep((WaitingUtil.WaitingType)WaitingUtil.WaitingType.OTHER, (long)l);
            }
        }
    }

    private void awaitImagesImpl(long l) throws ConcurrentModificationException {
        long l2 = System.currentTimeMillis();
        IHanging iHanging = DataSelectionManager.getInstance().getActiveHanging();
        if (iHanging != null) {
            this.awaitDisplayWithData(l);
        }
        for (VisDisplay2 visDisplay2 : JVision2.getMainFrame().getDisplays()) {
            if (!visDisplay2.hasData()) continue;
            List list = visDisplay2.getVisViews();
            for (Vis2 vis2 : list) {
                if (!vis2.hasData()) continue;
                this.awaitImage(vis2, WaitingUtil.getRemainingWaitingTime((long)l2, (long)l));
            }
        }
    }

    private boolean awaitDisplayWithData(long l) {
        return WaitingUtil.waitFor((WaitingUtil.IWaitingHandler)new WaitingUtil.IWaitingHandler(){

            public boolean isWaiting() {
                return AutoTestLatch.this.areAllDisplaysEmpty();
            }
        }, (WaitingUtil.WaitingType)WaitingUtil.WaitingType.DISPLAY_INIT, (long)l);
    }

    boolean areAllDisplaysEmpty() {
        for (VisDisplay2 visDisplay2 : JVision2.getMainFrame().getDisplays()) {
            if (!visDisplay2.hasData()) continue;
            List list = visDisplay2.getVisViews();
            for (Vis2 vis2 : list) {
                if (!vis2.hasData()) continue;
                return false;
            }
        }
        return true;
    }

    public boolean awaitImage(int n, long l) {
        return this.awaitImage(ImageAreaScriptUtil.getActiveVisViewAt(n), l);
    }

    private boolean awaitImage(final Vis2 vis2, long l) {
        return WaitingUtil.waitFor((WaitingUtil.IWaitingHandler)new WaitingUtil.IWaitingHandler(){

            public boolean isWaiting() {
                return vis2.getData() == null || !vis2.getData().isImageAvailable();
            }
        }, (WaitingUtil.WaitingType)WaitingUtil.WaitingType.IMAGE_DISPLAY, (long)l);
    }

    private static class HangingListener
    extends DataSelectionListenerAdapter {
        private IHanging activeHanging = DataSelectionManager.getInstance().getActiveHanging();

        private HangingListener() {
        }

        public void newPatientSelected(DataSelectionManager dataSelectionManager, IPatientRepresentation iPatientRepresentation, IPatientRepresentation iPatientRepresentation2, IPatientRepresentation iPatientRepresentation3) {
            this.activeHanging = iPatientRepresentation2 == null ? null : iPatientRepresentation2.getActiveHanging();
        }

        public void newHangingCaseSelected(IPatientRepresentation iPatientRepresentation, IHanging iHanging, IHanging iHanging2, boolean bl) {
            this.activeHanging = iHanging2;
        }

        protected IHanging getActiveHanging() {
            return this.activeHanging;
        }
    }
}

