/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.glue.script;

import com.agfa.pacs.base.swing.util.EventUtil;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.glue.script.ImageAreaScriptUtil;
import com.agfa.pacs.impaxee.glue.script.PatientComparator;
import com.agfa.pacs.impaxee.glue.script.StudyComparator;
import com.agfa.pacs.impaxee.hanging.IHanging;
import com.agfa.pacs.impaxee.hanging.snapshot.AbstractSnapshotRuntime;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IPatientData;
import com.tiani.base.data.IStudyData;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.patinfo.DataSelectionManager;
import com.tiani.jvision.patinfo.DisplaySetLabel;
import com.tiani.jvision.vis.Vis2;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.jvision.vis.VisScreen2;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.dcm4che3.data.Attributes;

public class AutoTestCapture {
    private static final ALogger log = ALogger.getLogger(AutoTestCapture.class);
    private static final AutoTestCapture INSTANCE = new AutoTestCapture();

    private AutoTestCapture() {
    }

    public static AutoTestCapture getInstance() {
        return INSTANCE;
    }

    public Iterable<BufferedImage> createAllImages() {
        ArrayList<BufferedImage> arrayList = new ArrayList<BufferedImage>();
        List list = JVision2.getMainFrame().getScreens();
        for (VisScreen2 visScreen2 : list) {
            List list2 = visScreen2.getDisplays();
            for (VisDisplay2 visDisplay2 : list2) {
                List list3 = visDisplay2.getVisViews();
                for (Vis2 vis2 : list3) {
                    arrayList.add(this.createImage(vis2));
                }
            }
        }
        return arrayList;
    }

    public BufferedImage createImage(int n) {
        return this.createImage(ImageAreaScriptUtil.getActiveVisViewAt(n));
    }

    private BufferedImage createImage(final Vis2 vis2) {
        if (vis2.getData() == null || vis2.getView() == null) {
            log.warn("No image loaded");
            return null;
        }
        final BufferedImage bufferedImage = new BufferedImage(vis2.getView().getcwidth(), vis2.getView().getcheight(), 2);
        EventUtil.invokeSynchronous((Runnable)new Runnable(){

            @Override
            public void run() {
                BufferedImage bufferedImage2 = vis2.getData().captureImage();
                bufferedImage.createGraphics().drawImage((Image)bufferedImage2, 0, 0, null);
            }
        });
        return bufferedImage;
    }

    public BufferedImage createCombinedImage() {
        Rectangle rectangle = JVision2.getMainFrame().getBounds();
        BufferedImage bufferedImage = new BufferedImage(rectangle.width, rectangle.height, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        List list = JVision2.getMainFrame().getScreens();
        for (VisScreen2 visScreen2 : list) {
            List list2 = visScreen2.getDisplays();
            for (VisDisplay2 visDisplay2 : list2) {
                List list3 = visDisplay2.getVisViews();
                for (Vis2 vis2 : list3) {
                    Point point = vis2.getLocationOnScreen();
                    this.paintToImage(vis2, graphics2D, point.x - rectangle.x, point.y - rectangle.y);
                }
            }
        }
        return bufferedImage;
    }

    private void paintToImage(final Vis2 vis2, final Graphics graphics, final int n, final int n2) {
        if (vis2.getData() == null || vis2.getView() == null) {
            return;
        }
        EventUtil.invokeSynchronous((Runnable)new Runnable(){

            @Override
            public void run() {
                BufferedImage bufferedImage = vis2.getData().captureImage();
                graphics.drawImage(bufferedImage, n, n2, null);
            }
        });
    }

    public BufferedImage createSeriesThumbnails(int n) {
        try {
            DisplaySetLabel displaySetLabel = (DisplaySetLabel)JVision2.getMainFrame().getToolBar(0).getSeqPanel().getSeqPane().getDisplaySetLabels().get(n);
            BufferedImage bufferedImage = new BufferedImage(displaySetLabel.getWidth(), displaySetLabel.getHeight(), 2);
            displaySetLabel.paint((Graphics)bufferedImage.createGraphics());
            return bufferedImage;
        }
        catch (Exception exception) {
            log.warn("Error on creating thumbnail capture.", (Throwable)exception);
            return null;
        }
    }

    public String exportImageAreaToXml() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<ImageArea>");
        stringBuilder.append('\n');
        this.exportLoadedDataToXml(stringBuilder);
        stringBuilder.append('\n');
        this.exportActiveHangingToXml(stringBuilder);
        stringBuilder.append('\n');
        stringBuilder.append("</ImageArea>");
        return stringBuilder.toString();
    }

    public String exportMainFrameToXml() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<MainFrame>");
        if (JVision2.getMainFrame() != null) {
            stringBuilder.append("<state>");
            stringBuilder.append(JVision2.getMainFrame().getState());
            stringBuilder.append("</state>");
        }
        stringBuilder.append("</MainFrame>");
        return stringBuilder.toString();
    }

    public String exportLoadedDataToXml() {
        StringBuilder stringBuilder = new StringBuilder();
        this.exportLoadedDataToXml(stringBuilder);
        return stringBuilder.toString();
    }

    private void exportLoadedDataToXml(StringBuilder stringBuilder) {
        stringBuilder.append("<data>");
        stringBuilder.append('\n');
        List list = DataManager.getInstance().getPatientDatas();
        Collections.sort(list, PatientComparator.getInstance());
        for (IPatientData iPatientData : list) {
            Attributes attributes = iPatientData.getDicomObject();
            stringBuilder.append("<patient>");
            stringBuilder.append('\n');
            stringBuilder.append("<name>");
            String string = attributes.getString(0x100010);
            if (string.endsWith("^^^")) {
                string = string.substring(0, string.length() - 3);
            }
            stringBuilder.append(string);
            stringBuilder.append("</name>");
            stringBuilder.append('\n');
            stringBuilder.append("<id>");
            stringBuilder.append(attributes.getString(0x100020));
            String string2 = attributes.getString(0x100021);
            if (string2 != null) {
                stringBuilder.append('@');
                stringBuilder.append(string2);
            }
            stringBuilder.append("</id>");
            stringBuilder.append('\n');
            stringBuilder.append("<studies>");
            stringBuilder.append('\n');
            ArrayList arrayList = new ArrayList(iPatientData.getStudies());
            Collections.sort(arrayList, StudyComparator.getInstance());
            for (IStudyData iStudyData : arrayList) {
                stringBuilder.append("<uid>");
                stringBuilder.append(iStudyData.getStudyInstanceUID());
                stringBuilder.append("</uid>");
                stringBuilder.append('\n');
            }
            stringBuilder.append("</studies>");
            stringBuilder.append('\n');
            stringBuilder.append("</patient>");
            stringBuilder.append('\n');
        }
        stringBuilder.append("</data>");
    }

    public String exportActiveHangingToXml() {
        StringBuilder stringBuilder = new StringBuilder();
        this.exportActiveHangingToXml(stringBuilder);
        return stringBuilder.toString();
    }

    private void exportActiveHangingToXml(StringBuilder stringBuilder) {
        AbstractSnapshotRuntime abstractSnapshotRuntime;
        stringBuilder.append("<hanging>");
        IHanging iHanging = DataSelectionManager.getInstance().getActiveHanging();
        if (iHanging != null) {
            stringBuilder.append("<name>");
            stringBuilder.append(iHanging.getVisibleName());
            stringBuilder.append("</name>");
        }
        if ((abstractSnapshotRuntime = DataSelectionManager.getInstance().getActiveSnapshot(iHanging)) != null) {
            stringBuilder.append("<snapshot>");
            stringBuilder.append(abstractSnapshotRuntime.getName());
            stringBuilder.append("</snapshot>");
        }
        List list = JVision2.getMainFrame() == null ? Collections.emptyList() : JVision2.getMainFrame().getScreens();
        for (VisScreen2 visScreen2 : list) {
            stringBuilder.append("<screen>");
            List list2 = visScreen2.getDisplays();
            for (VisDisplay2 visDisplay2 : list2) {
                stringBuilder.append("<display>");
                List list3 = visDisplay2.getVisViews();
                for (Vis2 vis2 : list3) {
                    stringBuilder.append("<view>");
                    VisData visData = vis2.getData();
                    if (visData != null && visData.getImageInformation() != null) {
                        stringBuilder.append(visData.getImageInformation().getSOPInstanceUID());
                    }
                    stringBuilder.append("</view>");
                }
                stringBuilder.append("</display>");
            }
            stringBuilder.append("</screen>");
        }
        stringBuilder.append("</hanging>");
    }
}

