/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.glue.monitoring;

import com.agfa.pacs.data.shared.lw.IDataInfoSource;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.data.shared.node.IDataInfoNode;
import com.agfa.pacs.data.shared.properties.PropertiesOwner;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.impaxee.hanging.IStudyContainer;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.base.data.IStudyData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.Pair;

class AutomaticStudyMonitoringDataMap {
    private static final long ONE_MINUTE = 60000L;
    private final Set<String> enabledArchives;
    private final Set<IDataInfoSource> sources;
    private final Map<String, IDataInfoNode> thinSources;
    private final Set<IStudyInfo> studies;
    private final Map<String, Pair<Date, List<IDisplaySet>>> displaySets;
    private int displaySetCountOfBaseStudy = 0;
    private Date initialLoad = new Date(0L);

    AutomaticStudyMonitoringDataMap(Set<String> set, IPatientRepresentation iPatientRepresentation) {
        this.enabledArchives = set;
        this.sources = new HashSet<IDataInfoSource>();
        this.thinSources = new HashMap<String, IDataInfoNode>();
        this.studies = new HashSet<IStudyInfo>();
        this.displaySets = new HashMap<String, Pair<Date, List<IDisplaySet>>>(256);
        HashSet<IStudyData> hashSet = new HashSet<IStudyData>();
        for (IStudyContainer object2 : iPatientRepresentation.getStudyContainers()) {
            if (!object2.getBaseStudy().includeInStudyMonitoring()) continue;
            hashSet.add(object2.getBaseStudy());
        }
        for (IStudyData iStudyData : hashSet) {
            Date date = (Date)iStudyData.getQueryObject().getTreeParent().getTreeParent().getAttributes().getProperty("CREATION_TIMESTAMP", null);
            if (date == null || !date.after(this.initialLoad)) continue;
            this.initialLoad = date;
        }
        this.initialLoad = new Date(this.initialLoad.getTime() - 60000L);
        Object object2 = iPatientRepresentation.getDecompositionRuntime().getDisplaySets();
        int n = ((IDisplaySet[])object2).length;
        int n2 = 0;
        while (n2 < n) {
            IDisplaySet iDisplaySet = object2[n2];
            if (hashSet.contains(iDisplaySet.getStudy())) {
                ++this.displaySetCountOfBaseStudy;
                IFrameObjectData[] iFrameObjectDataArray = iDisplaySet.getObjects();
                int n3 = iFrameObjectDataArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IFrameObjectData iFrameObjectData = iFrameObjectDataArray[n4];
                    this.put(iFrameObjectData, iDisplaySet);
                    ++n4;
                }
            }
            ++n2;
        }
        HashSet<IDisplaySet[]> hashSet2 = new HashSet<IDisplaySet[]>();
        for (IDataInfoSource iDataInfoSource : this.sources) {
            object2 = this.getNameOfThinSliceArchive(iDataInfoSource);
            if (object2 == null) continue;
            hashSet2.add((IDisplaySet[])object2);
        }
        block5: for (String string : hashSet2) {
            for (Object object2 : this.sources) {
                if (!object2.getIdentifier().getName().equals(string) || !(object2 instanceof IDataInfoNode)) continue;
                this.thinSources.put(string, (IDataInfoNode)object2);
                this.sources.remove(object2);
                continue block5;
            }
        }
    }

    private String getNameOfThinSliceArchive(IDataInfoSource iDataInfoSource) {
        PropertiesOwner propertiesOwner = iDataInfoSource.getIdentifier().getPropertiesOwner();
        return propertiesOwner.properties().getProperty("thinSliceArchive");
    }

    public Date getInitialLoad() {
        return this.initialLoad;
    }

    public int getDisplaySetCountOfBaseStudy() {
        return this.displaySetCountOfBaseStudy;
    }

    private boolean isStudyMonitoringEnabled(IDataInfoSource iDataInfoSource) {
        return iDataInfoSource instanceof IDataInfoNode && this.enabledArchives.contains(((IDataInfoNode)iDataInfoSource).getName());
    }

    void put(IFrameObjectData iFrameObjectData, IDisplaySet iDisplaySet) {
        IDataInfoSource iDataInfoSource = iFrameObjectData.getMainFrame().getQueryObject().getSource();
        if (this.isStudyMonitoringEnabled(iDataInfoSource)) {
            this.sources.add(iDataInfoSource);
            this.studies.add((IStudyInfo)iFrameObjectData.getMainFrame().getQueryObject().getTreeParent().getTreeParent());
            Pair pair = this.displaySets.get(iFrameObjectData.getSOPInstanceUID());
            if (pair == null) {
                long l = iFrameObjectData.getMainFrame().getObjectUpdateTimestamp();
                pair = new Pair((Object)(l > 0L ? new Date(l) : null), new ArrayList(2));
                this.displaySets.put(iFrameObjectData.getSOPInstanceUID(), (Pair<Date, List<IDisplaySet>>)pair);
            }
            ((List)pair.right).add(iDisplaySet);
        }
    }

    Pair<Date, List<IDisplaySet>> remove(String string) {
        return this.displaySets.remove(string);
    }

    List<IDataInfoSource> getSources() {
        return new ArrayList<IDataInfoSource>(this.sources);
    }

    boolean hasThickSliceArchives() {
        return !this.thinSources.isEmpty();
    }

    IDataInfoNode getThinSliceArchive(IStudyInfo iStudyInfo) {
        String string = this.getNameOfThinSliceArchive(iStudyInfo.getSource());
        if (string == null) {
            return null;
        }
        return this.thinSources.get(string);
    }

    Iterable<IStudyInfo> getStudyInfos() {
        return this.studies;
    }

    Set<String> getSOPInstanceUIDs() {
        return this.displaySets.keySet();
    }

    Set<IDisplaySet> getDisplaySets() {
        HashSet<IDisplaySet> hashSet = new HashSet<IDisplaySet>();
        for (Pair<Date, List<IDisplaySet>> pair : this.displaySets.values()) {
            hashSet.addAll((Collection)pair.right);
        }
        return hashSet;
    }

    boolean isEmpty() {
        return this.displaySets.isEmpty();
    }
}

