/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.glue.monitoring;

import com.agfa.pacs.base.swing.util.EventUtil;
import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.data.shared.dicom.Level;
import com.agfa.pacs.data.shared.dicom.UIDType;
import com.agfa.pacs.data.shared.dicom.UIDUtilities;
import com.agfa.pacs.data.shared.lw.DataInfoUtilities;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.data.shared.node.IDataInfoNode;
import com.agfa.pacs.impaxee.glue.cycling.ImpaxEECycleListProvider;
import com.agfa.pacs.impaxee.glue.cycling.LoadRequest;
import com.agfa.pacs.impaxee.glue.cycling.Messages;
import com.agfa.pacs.impaxee.glue.monitoring.AdditionalSeries;
import com.agfa.pacs.impaxee.glue.monitoring.AutomaticStudyMonitoringDataMap;
import com.agfa.pacs.impaxee.glue.monitoring.DataReloader;
import com.agfa.pacs.impaxee.glue.monitoring.IModifiedSeries;
import com.agfa.pacs.impaxee.glue.monitoring.ModifiedDisplaySet;
import com.agfa.pacs.impaxee.glue.monitoring.ModifiedSeriesDialog;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.listtext.base.Base;
import com.agfa.pacs.listtext.cycling.CycleListProviderFactory;
import com.agfa.pacs.listtext.lta.filter.FilterHelper;
import com.agfa.pacs.listtext.lta.filter.FilterUtilities;
import com.agfa.pacs.listtext.lta.filter.IPersistantFilter;
import com.agfa.pacs.listtext.lta.filter.SimpleFilter;
import com.agfa.pacs.logging.ALogger;
import com.tiani.jvision.patinfo.DataSelectionListenerAdapter;
import com.tiani.jvision.patinfo.DataSelectionManager;
import com.tiani.jvision.patinfo.IDataSelectionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.lang3.Pair;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.DatePrecision;
import org.dcm4che3.data.VR;
import org.dcm4che3.util.DateUtils;

public class AutomaticStudyMonitoring
extends DataSelectionListenerAdapter {
    private static final ALogger LOGGER = ALogger.getLogger(AutomaticStudyMonitoring.class);
    private static final long MONITORING_PERIOD = ConfigurationProviderFactory.getConfig().getLong("listtext.datanode.automaticStudyMonitoringPeriod") * 60000L;
    private static final boolean IS_UPDATE_DETECTION_ENABLED = ConfigurationProviderFactory.getConfig().getBoolean("listtext.datanode.automaticStudyMonitoringUpdateDetectionEnabled");
    static final boolean IS_REHANGUP_ENABLED = ConfigurationProviderFactory.getConfig().getBoolean("listtext.datanode.automaticStudyMonitoringRehangupEnabled");
    private static final DatePrecision PERFECT_PRECISION = new DatePrecision();
    private static boolean isInitialized;
    private final Timer timer = new Timer("AutomaticStudyMonitoring", true);
    private TimerTask task;

    private AutomaticStudyMonitoring() {
    }

    private static Set<String> collectArchives() {
        HashSet<String> hashSet = new HashSet<String>();
        for (IDataInfoNode iDataInfoNode : Base.getDataInfoNodes()) {
            if (!iDataInfoNode.getType().equals("AGFADICOMWADO") || !Boolean.parseBoolean(iDataInfoNode.getIdentifier().getPropertiesOwner().properties().getProperty("automaticStudyMonitoring"))) continue;
            hashSet.add(iDataInfoNode.getName());
        }
        return hashSet;
    }

    public static synchronized void init() {
        if (!isInitialized) {
            LOGGER.debug("Initializing automatic study monitoring");
            DataSelectionManager.getInstance().addListener((IDataSelectionListener)new AutomaticStudyMonitoring());
            isInitialized = true;
        }
    }

    private void cancel() {
        if (this.task != null) {
            this.task.cancel();
            this.task = null;
        }
    }

    private void schedule(long l) {
        this.cancel();
        this.task = new AutomaticStudyMonitoringTask();
        this.timer.schedule(this.task, l, MONITORING_PERIOD);
    }

    public void newPatientSelected(DataSelectionManager dataSelectionManager, IPatientRepresentation iPatientRepresentation, IPatientRepresentation iPatientRepresentation2, IPatientRepresentation iPatientRepresentation3) {
        this.cancel();
        if (iPatientRepresentation2 != null) {
            this.schedule(iPatientRepresentation == null ? MONITORING_PERIOD : 0L);
        }
    }

    void checkDataOfCurrentPatient() {
        Object object2;
        IStudyInfo iStudyInfo2;
        IPatientRepresentation iPatientRepresentation = DataSelectionManager.getInstance().getCurrentPatient();
        if (iPatientRepresentation == null) {
            return;
        }
        Set<String> set = AutomaticStudyMonitoring.collectArchives();
        if (set.isEmpty()) {
            return;
        }
        if (CycleListProviderFactory.getInstance().getCycleListProvider().getCycleListPreferences().isPreferredLoadingEnabled()) {
            LOGGER.warn("Automatic study monitoring disabled while preferably loading key images is enabled.");
            return;
        }
        AutomaticStudyMonitoringDataMap automaticStudyMonitoringDataMap = new AutomaticStudyMonitoringDataMap(set, iPatientRepresentation);
        if (automaticStudyMonitoringDataMap.isEmpty()) {
            LOGGER.debug("Automatic study monitoring not applicable to any loaded object.");
            return;
        }
        ArrayList<IObjectInfo> arrayList = new ArrayList<IObjectInfo>();
        HashSet<IDisplaySet> hashSet = new HashSet<IDisplaySet>();
        SimpleFilter simpleFilter = FilterUtilities.getStudies(automaticStudyMonitoringDataMap.getStudyInfos());
        simpleFilter.setMinLevel(Level.Object);
        IDataInfo iDataInfo = FilterHelper.performSyncSearch((IPersistantFilter)simpleFilter, automaticStudyMonitoringDataMap.getSources());
        if (automaticStudyMonitoringDataMap.hasThickSliceArchives()) {
            for (IStudyInfo iStudyInfo2 : DataInfoUtilities.getLevel((IDataInfo)iDataInfo, IStudyInfo.class)) {
                ImpaxEECycleListProvider.expandThinSliceArchive(iStudyInfo2, automaticStudyMonitoringDataMap.getThinSliceArchive(iStudyInfo2));
            }
        }
        iStudyInfo2 = new HashMap(256);
        for (Object object2 : DataInfoUtilities.getLevel((IDataInfo)iDataInfo, IObjectInfo.class)) {
            String string = object2.getSOPInstanceUID();
            if (iStudyInfo2.containsKey(string)) continue;
            iStudyInfo2.put(string, object2);
            Pair<Date, List<IDisplaySet>> pair = automaticStudyMonitoringDataMap.remove(string);
            if (!AutomaticStudyMonitoring.isSupported((IObjectInfo)object2)) continue;
            if (pair == null) {
                if (!this.isCreatedAfterSearch((IObjectInfo)object2, automaticStudyMonitoringDataMap.getInitialLoad())) continue;
                arrayList.add((IObjectInfo)object2);
                continue;
            }
            if (!IS_UPDATE_DETECTION_ENABLED || !this.isChanged((IObjectInfo)object2, (Date)pair.left)) continue;
            hashSet.addAll((Collection)pair.right);
        }
        object2 = automaticStudyMonitoringDataMap.getDisplaySets();
        if (!arrayList.isEmpty() && object2.isEmpty() && hashSet.isEmpty()) {
            LOGGER.info("Automatically loading {} objects ...", (Object)arrayList.size());
            new LoadRequest(false).simpleLoad(arrayList, false);
            CycleListProviderFactory.getInstance().getCycleListProvider().showMessagePopup(Messages.getString("AutomaticStudyMonitoring.AdditionalDataAvailable.Message"), Integer.valueOf(7));
            if (IS_REHANGUP_ENABLED) {
                DataSelectionManager.getInstance().reHangup();
            }
        } else if (!object2.isEmpty() || !hashSet.isEmpty()) {
            ArrayList<IModifiedSeries> arrayList2;
            if (LOGGER.isInfoEnabled()) {
                arrayList2 = new StringBuilder();
                ((StringBuilder)((Object)arrayList2)).append("Some modified data found: ");
                if (!arrayList.isEmpty()) {
                    ((StringBuilder)((Object)arrayList2)).append(arrayList.size());
                    ((StringBuilder)((Object)arrayList2)).append(" additional objects, ");
                }
                if (!hashSet.isEmpty()) {
                    ((StringBuilder)((Object)arrayList2)).append(hashSet.size());
                    ((StringBuilder)((Object)arrayList2)).append(" display sets with changed data, ");
                }
                if (!object2.isEmpty()) {
                    ((StringBuilder)((Object)arrayList2)).append(object2.size());
                    ((StringBuilder)((Object)arrayList2)).append(" display sets with removed data");
                }
                LOGGER.info(((StringBuilder)((Object)arrayList2)).toString());
            }
            this.cancel();
            arrayList2 = new ArrayList<IModifiedSeries>();
            arrayList2.addAll(AdditionalSeries.createList(arrayList));
            arrayList2.addAll(ModifiedDisplaySet.createList(hashSet, (Collection<IDisplaySet>)object2));
            EventUtil.invoke((Runnable)new Runnable((Map)iStudyInfo2, automaticStudyMonitoringDataMap, hashSet, (Set)object2, arrayList){
                private final /* synthetic */ Map val$newObjects;
                private final /* synthetic */ AutomaticStudyMonitoringDataMap val$loadedObjects;
                private final /* synthetic */ Set val$changedDisplaySets;
                private final /* synthetic */ Set val$removedDisplaySets;
                private final /* synthetic */ List val$additionalObjects;
                {
                    this.val$newObjects = map;
                    this.val$loadedObjects = automaticStudyMonitoringDataMap;
                    this.val$changedDisplaySets = set;
                    this.val$removedDisplaySets = set2;
                    this.val$additionalObjects = list2;
                }

                @Override
                public void run() {
                    ModifiedSeriesDialog modifiedSeriesDialog = new ModifiedSeriesDialog(arrayList2);
                    modifiedSeriesDialog.setVisible(true);
                    int n = modifiedSeriesDialog.getDialogResult();
                    if (n == 0) {
                        try {
                            DataReloader dataReloader = new DataReloader(this.val$newObjects, this.val$loadedObjects.getDisplaySetCountOfBaseStudy());
                            dataReloader.addModifiedDisplaySets(this.val$changedDisplaySets);
                            dataReloader.addModifiedDisplaySets(this.val$removedDisplaySets);
                            dataReloader.addAdditionalObjectInfos(this.val$additionalObjects);
                            dataReloader.reload();
                        }
                        catch (Exception exception) {
                            LOGGER.error("Reloading modified data failed.", (Throwable)exception);
                        }
                    } else {
                        LOGGER.info("Reloading modified data declined by user.");
                    }
                    if (n == 1) {
                        LOGGER.info("Disabling automatic study monitoring for current patient (on user request).");
                    } else {
                        AutomaticStudyMonitoring.this.schedule(MONITORING_PERIOD);
                    }
                }
            });
        } else {
            LOGGER.debug("No modified objects found.");
        }
    }

    private boolean isCreatedAfterSearch(IObjectInfo iObjectInfo, Date date) {
        Date date2 = AutomaticStudyMonitoring.getUpdateTimestamp(iObjectInfo.getAttributes());
        return date2 != null && date2.after(date);
    }

    private static boolean isSupported(IObjectInfo iObjectInfo) {
        String string = iObjectInfo.getSOPClassUID();
        return UIDUtilities.isViewableType((String)string) && !UIDUtilities.isType((String)string, (UIDType)UIDType.ForProcessing);
    }

    private boolean isChanged(IObjectInfo iObjectInfo, Date date) {
        Date date2 = AutomaticStudyMonitoring.getUpdateTimestamp(iObjectInfo.getAttributes());
        if (date2 != null) {
            return date != null && date2.after(date);
        }
        return false;
    }

    static Date getUpdateTimestamp(Attributes attributes) {
        String string = attributes.getString("dcm4che/archive", 4390934, VR.SH, null);
        if (string == null) {
            return null;
        }
        return DateUtils.parseDT(null, (String)string, (boolean)false, (DatePrecision)PERFECT_PRECISION);
    }

    private class AutomaticStudyMonitoringTask
    extends TimerTask {
        private AutomaticStudyMonitoringTask() {
        }

        @Override
        public void run() {
            try {
                AutomaticStudyMonitoring.this.checkDataOfCurrentPatient();
            }
            catch (Exception exception) {
                LOGGER.error("Automatic study monitoring failed.", (Throwable)exception);
            }
        }
    }
}

