/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.glue.dicomobjectrenderer;

import com.agfa.pacs.base.util.DicomUtils;
import com.agfa.pacs.data.lw.datainfo.impl.PatientInfo;
import com.agfa.pacs.data.lw.datainfo.impl.RootInfo;
import com.agfa.pacs.data.shared.dicom.UIDType;
import com.agfa.pacs.data.shared.dicom.UIDUtilities;
import com.agfa.pacs.data.shared.instanceinfo.AbstractInstanceInfo;
import com.agfa.pacs.data.shared.instanceinfo.IInstanceInfo;
import com.agfa.pacs.data.shared.lw.DataInfoUtilities;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.lw.IPatientInfo;
import com.agfa.pacs.data.shared.lw.ISeriesInfo;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.data.shared.pixel.IPixelDataFrame;
import com.agfa.pacs.impaxee.cache.BufferedImageHolder;
import com.agfa.pacs.impaxee.cache.RGBBufferedImageHolder;
import com.agfa.pacs.impaxee.glue.data.AbstractImageObjectData;
import com.agfa.pacs.impaxee.glue.data.ImpaxEEPatientData;
import com.agfa.pacs.impaxee.glue.data.ImpaxEESeriesData;
import com.agfa.pacs.impaxee.glue.data.ImpaxEEStudyData;
import com.agfa.pacs.impaxee.glue.datainfo.ImpaxEEObjectInfo;
import com.agfa.pacs.impaxee.glue.datainfo.ImpaxEESeriesInfo;
import com.agfa.pacs.impaxee.glue.datainfo.ImpaxEEStudyInfo;
import com.agfa.pacs.impaxee.glue.dicomobjectrenderer.OrientationReader;
import com.agfa.pacs.impaxee.glue.dicomobjectrenderer.RendererEvaluableData;
import com.agfa.pacs.impaxee.hanging.model.enums.ZoomMode;
import com.agfa.pacs.listtext.dicomobject.module.ps.PresentationSizeMode;
import com.agfa.pacs.listtext.dicomobject.presentation.IFramePresentationState;
import com.agfa.pacs.listtext.dicomobject.presentation.rendering.PresentationRenderContext;
import com.agfa.pacs.listtext.dicomobject.renderer.IDicomObjectRenderer;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.jvision.image.OutputDeviceMetric;
import com.tiani.jvision.image.fithandler.AreaFitHandler;
import com.tiani.jvision.image.fithandler.FullVisualFitHandler;
import com.tiani.jvision.image.fithandler.TrueSizeFitHandler;
import com.tiani.jvision.info.ImageState;
import com.tiani.jvision.overlay.Overlay;
import com.tiani.jvision.overlay.OverlayBitmap;
import com.tiani.jvision.overlay.PresentationObject;
import com.tiani.jvision.overlay.RulerMapping;
import com.tiani.jvision.overlay.demographics.Mapping;
import com.tiani.jvision.overlay.demographics.MappingFactory;
import com.tiani.jvision.renderer.IRDCRenderer;
import com.tiani.jvision.renderer.RDCRenderer;
import com.tiani.jvision.vis.Vis2;
import com.tiani.util.expressions.EvaluationContext;
import com.tiani.util.expressions.IEvaluableData;
import com.tiani.util.expressions.IEvaluablePrivateData;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.List;
import org.dcm4che3.data.Attributes;

public class ImpaxEEDicomObjectRenderer
implements IDicomObjectRenderer {
    private IFrameObjectData frameObjectData;
    private IRDCRenderer renderer;
    private Mapping mapping;
    private boolean lossless;
    private static IInstanceInfo iinfo = new NullInstanceInfo();

    public ImpaxEEDicomObjectRenderer(Attributes attributes, IPixelDataFrame<?> iPixelDataFrame, int n, Object object) {
        this.lossless = ImpaxEEDicomObjectRenderer.isLossless(attributes);
        this.init(attributes, object, iPixelDataFrame, n);
    }

    private void init(Attributes attributes, Object object, IPixelDataFrame<?> iPixelDataFrame, int n) {
        if (object != null && object instanceof IFrameObjectData) {
            this.frameObjectData = (IFrameObjectData)object;
        } else {
            String string = attributes.getString(524312);
            String string2 = attributes.getString(0x20000E);
            String string3 = attributes.getString(0x20000D);
            String string4 = DataInfoUtilities.compilePatientKey((Attributes)attributes);
            RootInfo rootInfo = new RootInfo();
            PatientInfo patientInfo = new PatientInfo((IDataInfo)rootInfo, string4);
            ImpaxEEStudyInfo impaxEEStudyInfo = new ImpaxEEStudyInfo((IDataInfo)patientInfo, string3);
            impaxEEStudyInfo.setUID(string3);
            ImpaxEESeriesInfo impaxEESeriesInfo = new ImpaxEESeriesInfo(impaxEEStudyInfo, string2);
            impaxEESeriesInfo.setUID(string2);
            ImpaxEEObjectInfo impaxEEObjectInfo = new ImpaxEEObjectInfo(impaxEESeriesInfo, string);
            impaxEEObjectInfo.setUID(string);
            impaxEEObjectInfo.setInstanceInfo(iinfo);
            impaxEEObjectInfo.getAttributes().addAll(attributes);
            ImpaxEEPatientData impaxEEPatientData = new ImpaxEEPatientData((IPatientInfo)patientInfo);
            ImpaxEEStudyData impaxEEStudyData = new ImpaxEEStudyData((IStudyInfo)impaxEEStudyInfo, false);
            impaxEEStudyData.setParent(impaxEEPatientData);
            ImpaxEESeriesData impaxEESeriesData = new ImpaxEESeriesData((ISeriesInfo)impaxEESeriesInfo, false);
            impaxEESeriesData.setParent(impaxEEStudyData);
            AbstractImageObjectData abstractImageObjectData = AbstractImageObjectData.createObjectData((IObjectInfo)impaxEEObjectInfo);
            abstractImageObjectData.setParent(impaxEESeriesData);
            abstractImageObjectData.initFromDicomObject(attributes);
            abstractImageObjectData.setFrame(iPixelDataFrame, n);
            this.frameObjectData = abstractImageObjectData.getFrame(n);
        }
    }

    public int getHeight() {
        return this.frameObjectData.getRows();
    }

    public int getWidth() {
        return this.frameObjectData.getColumns();
    }

    public int getBitsPerPixel() {
        return 8;
    }

    public boolean isRGB() {
        return true;
    }

    public void setPresentationState(IFramePresentationState iFramePresentationState) {
        this.update(null);
        if (iFramePresentationState != null) {
            this.renderer.applyPresentationState(iFramePresentationState);
        }
    }

    private static boolean isLossless(Attributes attributes) {
        if ("01".equals(attributes.getString(2629904))) {
            return false;
        }
        return !UIDUtilities.isTransferSyntaxType((String)attributes.getString(131088), (UIDType)UIDType.Lossy);
    }

    private boolean isSecondaryCapture() {
        return DicomUtils.isSecondaryCapture((String)this.frameObjectData.getSOPClassUID());
    }

    public void screenToImage(double[] dArray, double[] dArray2) {
        this.renderer.screenToImage(dArray, dArray2);
    }

    public void imageToScreen(double[] dArray, double[] dArray2) {
        this.renderer.imageToScreen(dArray, dArray2);
    }

    public void renderTo(PresentationRenderContext presentationRenderContext) {
        PresentationObject presentationObject;
        List list;
        RGBBufferedImageHolder rGBBufferedImageHolder = null;
        boolean bl = true;
        if (presentationRenderContext.getImage() != null && presentationRenderContext.getImage().getType() == 1) {
            rGBBufferedImageHolder = new RGBBufferedImageHolder(presentationRenderContext.getImage());
            bl = false;
        } else {
            rGBBufferedImageHolder = new RGBBufferedImageHolder(presentationRenderContext.getWidth(), presentationRenderContext.getHeight());
        }
        this.update(presentationRenderContext);
        this.renderer.paint(rGBBufferedImageHolder, rGBBufferedImageHolder.width, rGBBufferedImageHolder.height, rGBBufferedImageHolder.iofs, rGBBufferedImageHolder.iline, false);
        if (presentationRenderContext.getDevice().equalsIgnoreCase("PRINT")) {
            Object object;
            list = this.renderer.getOverlays();
            boolean bl2 = false;
            presentationObject = list.iterator();
            while (presentationObject.hasNext()) {
                object = (Overlay)presentationObject.next();
                if (!(object instanceof RulerMapping)) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                object = new NoViewRulerMapping();
                object.setMaxRulerLength(rGBBufferedImageHolder.height / 15);
                object.setSize(rGBBufferedImageHolder.width, rGBBufferedImageHolder.height, this.renderer.getImageState());
                object.setPrintFont((Graphics)rGBBufferedImageHolder.graphics, new Rectangle(rGBBufferedImageHolder.width, rGBBufferedImageHolder.height), presentationRenderContext.getDPI());
                object.paint((BufferedImageHolder)rGBBufferedImageHolder);
            }
        }
        list = this.renderer.getOverlays();
        for (Overlay overlay : list) {
            if (overlay instanceof OverlayBitmap && !presentationRenderContext.applyOverlays() || overlay instanceof PresentationObject && ((presentationObject = (PresentationObject)overlay).isROI() && !presentationRenderContext.applyGraphicAnnotations() || presentationObject.isShutter() && !presentationRenderContext.applyShutter())) continue;
            overlay.paint((BufferedImageHolder)rGBBufferedImageHolder);
        }
        if (presentationRenderContext.applyMapping()) {
            AffineTransform affineTransform = presentationRenderContext.getGraphics().getTransform();
            if (presentationRenderContext.isDisplayedAreaMapping()) {
                this.mapping.setSize(presentationRenderContext.getWidth(), presentationRenderContext.getHeight(), null);
            } else {
                presentationRenderContext.setWidth(presentationRenderContext.getGraphicsWidth());
                presentationRenderContext.setHeight(presentationRenderContext.getGraphicsHeight());
                this.mapping.setSize(presentationRenderContext.getGraphicsWidth(), presentationRenderContext.getGraphicsHeight(), null);
            }
            this.mapping.setPrintFont((Graphics)rGBBufferedImageHolder.graphics, new Rectangle(presentationRenderContext.getGraphicsWidth(), presentationRenderContext.getGraphicsHeight()), presentationRenderContext.getDPI());
            this.mapping.paint((BufferedImageHolder)rGBBufferedImageHolder);
            this.mapping.resetPrintFont();
            presentationRenderContext.getGraphics().setTransform(affineTransform);
        }
        ArrayList<Image> arrayList = new ArrayList<Image>();
        if (!this.lossless) {
            arrayList.add(Vis2.ICON_JPEGLOSSY_ORIGINAL.getImage());
        }
        if (this.isSecondaryCapture()) {
            arrayList.add(Vis2.ICON_SECONDARYCAPTURE_ORIGINAL.getImage());
        }
        if (presentationRenderContext.applyIndicators() && arrayList.size() > 0) {
            double d = 5.0;
            int n = 32;
            int n2 = 32;
            if (presentationRenderContext.getPixelSpacing() != null) {
                n = (int)(d / presentationRenderContext.getPixelSpacing()[0]);
                n2 = (int)(d / presentationRenderContext.getPixelSpacing()[1]);
            }
            int n3 = (presentationRenderContext.getGraphicsWidth() - arrayList.size() * n) / 2;
            int n4 = presentationRenderContext.getGraphicsHeight() - n2;
            for (Image image : arrayList) {
                rGBBufferedImageHolder.graphics.drawImage(image, n3, n4, n, n2, null);
                n3 += n;
            }
        }
        if (bl) {
            presentationRenderContext.getGraphics().drawImage(rGBBufferedImageHolder.image, 0, 0, presentationRenderContext.getWidth(), presentationRenderContext.getHeight(), null);
        }
        rGBBufferedImageHolder.release();
    }

    private void update(PresentationRenderContext presentationRenderContext) {
        Object object;
        if (this.renderer == null) {
            this.renderer = RDCRenderer.createRenderer((IFrameObjectData)this.frameObjectData, (boolean)true, (ZoomMode)ZoomMode.NORMAL);
        }
        EvaluationContext evaluationContext = new EvaluationContext((IEvaluableData)this.frameObjectData, (IEvaluablePrivateData)new RendererEvaluableData(this.renderer, presentationRenderContext));
        try {
            object = OrientationReader.flipMappings(this.frameObjectData.getDicomObject());
            this.mapping = MappingFactory.getMapping((EvaluationContext)evaluationContext, (boolean)(object == null ? false : (Boolean)object));
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        if (this.mapping != null && presentationRenderContext != null && presentationRenderContext.isPreviewMode()) {
            this.mapping.setMinimumSize(1);
        }
        if (presentationRenderContext != null && presentationRenderContext.getSizeMode() == PresentationSizeMode.TrueSize && presentationRenderContext.getPixelSpacing() != null) {
            object = presentationRenderContext.getPixelSpacing();
            TrueSizeFitHandler trueSizeFitHandler = new TrueSizeFitHandler(new OutputDeviceMetric((double)object[0], (double)object[1]));
            this.renderer.setAreaFitHandler((AreaFitHandler)trueSizeFitHandler);
        } else {
            object = new FullVisualFitHandler(OutputDeviceMetric.neutral);
            this.renderer.setAreaFitHandler((AreaFitHandler)object);
        }
    }

    private static class NoViewRulerMapping
    extends RulerMapping {
        private ImageState imageState;

        private NoViewRulerMapping() {
        }

        public ImageState getImageState() {
            return this.imageState;
        }

        public void setImageState(ImageState imageState) {
            this.imageState = imageState;
        }

        public void setSize(int n, int n2, ImageState imageState) {
            super.setSize(n, n2, imageState);
            this.imageState = imageState;
        }
    }

    private static class NullInstanceInfo
    extends AbstractInstanceInfo {
        public String getType() {
            return "";
        }
    }
}

