/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.glue.dicomobjectrenderer;

import com.agfa.pacs.data.export.ImageObject;
import com.agfa.pacs.data.shared.export.ProcessingException;
import com.agfa.pacs.data.shared.export.ProcessingProperty;
import com.agfa.pacs.data.shared.pixel.IPixelDataFrame;
import com.agfa.pacs.data.shared.pixel.IPixelDataFrameProvider;
import com.agfa.pacs.data.shared.pixel.IPixelDataInfo;
import com.agfa.pacs.data.shared.pixel.PixelDataFrameUtilities;
import com.agfa.pacs.listtext.dicom.exporter.image.IExportImageRenderer;
import com.agfa.pacs.listtext.dicom.exporter.image.Image;
import com.agfa.pacs.listtext.dicomobject.renderer.DicomObjectRendererFactory;
import com.agfa.pacs.listtext.dicomobject.renderer.DicomObjectRendererUtils;
import com.agfa.pacs.listtext.dicomobject.renderer.IDicomObjectRenderer;
import com.agfa.pacs.listtext.dicomobject.renderer.IRenderableObject;
import com.agfa.pacs.logging.ALogger;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class ImageRenderer
implements IExportImageRenderer {
    private static final ALogger log = ALogger.getLogger(ImageRenderer.class);
    private boolean includeDemographics = false;
    private Integer scalingPercentage;
    private Integer maxWidth;
    private Integer maxHeight;

    public void prepareProcessing(Properties properties, List<? extends Object> list) throws ProcessingException {
        if (properties.containsKey("INCLUDE_DEMOGRAPHICS")) {
            this.includeDemographics = (Boolean)properties.get("INCLUDE_DEMOGRAPHICS");
        }
        if (properties.containsKey("SCALING_PERCENTAGE")) {
            this.scalingPercentage = (Integer)properties.get("SCALING_PERCENTAGE");
        }
        if (properties.containsKey("RENDER_MAX_HEIGHT")) {
            this.maxHeight = (Integer)properties.get("RENDER_MAX_HEIGHT");
        }
        if (properties.containsKey("RENDER_MAX_WIDTH")) {
            this.maxWidth = (Integer)properties.get("RENDER_MAX_WIDTH");
        }
    }

    public void finishProcessing() throws ProcessingException {
    }

    public void cleanUp() {
    }

    private int[] computeScaling(int n, int n2) {
        float f;
        int[] nArray = new int[]{n, n2};
        float f2 = 1.0f;
        if (this.scalingPercentage != null) {
            f2 = (float)this.scalingPercentage.intValue() / 100.0f;
        }
        if (this.maxWidth != null) {
            f = (float)this.maxWidth.intValue() / (float)n;
            float f3 = f2 = f2 == 1.0f ? f : Math.min(f, f2);
        }
        if (this.maxHeight != null) {
            f = (float)this.maxHeight.intValue() / (float)n2;
            float f4 = f2 = f2 == 1.0f ? f : Math.min(f, f2);
        }
        if (f2 != 1.0f) {
            nArray[0] = Math.round(f2 * (float)nArray[0]);
            nArray[1] = Math.round(f2 * (float)nArray[1]);
        }
        return nArray;
    }

    public Object process(Object object) throws ProcessingException {
        if (object instanceof IRenderableObject) {
            IRenderableObject iRenderableObject = (IRenderableObject)object;
            try {
                int[] nArray = this.computeScaling(iRenderableObject.getWidth(), iRenderableObject.getHeight());
                BufferedImage bufferedImage = DicomObjectRendererUtils.toBufferedImage((IDicomObjectRenderer)iRenderableObject, (boolean)true, (int)nArray[0], (int)nArray[1], (int)1, null, (boolean)this.includeDemographics);
                Image image = new Image(bufferedImage, iRenderableObject.getAttributes(), iRenderableObject.getContainedFrames()[0]);
                return image;
            }
            catch (Exception exception) {
                log.error("Couldn't create image", (Throwable)exception);
                throw new ProcessingException("Unknown rendering error");
            }
        }
        if (object instanceof ImageObject) {
            ArrayList<Image> arrayList = new ArrayList<Image>(2);
            ImageObject imageObject = (ImageObject)object;
            int n = 0;
            while (n < imageObject.getFrameCount()) {
                try {
                    BufferedImage bufferedImage = this.renderImage(imageObject, n);
                    if (bufferedImage != null) {
                        arrayList.add(new Image(bufferedImage, imageObject.getDataset(), n));
                    }
                }
                catch (Exception exception) {
                    log.error("Couldn't create image", (Throwable)exception);
                }
                ++n;
            }
            return arrayList.isEmpty() ? null : arrayList.toArray();
        }
        throw new IllegalArgumentException("Incompatible types");
    }

    public ProcessingProperty[] queryProperties() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public boolean supportsConcurrentProcessing() {
        return true;
    }

    public BufferedImage renderImage(ImageObject imageObject, int n) throws ProcessingException {
        IPixelDataInfo iPixelDataInfo = imageObject.getFrame(n);
        IPixelDataFrame iPixelDataFrame = PixelDataFrameUtilities.createPixelDataFrame((IPixelDataFrameProvider)PixelDataFrameUtilities.DefaultPixelDataFrameProvider, (IPixelDataInfo)iPixelDataInfo, (String)imageObject.getDataset().getString(524312));
        IDicomObjectRenderer iDicomObjectRenderer = DicomObjectRendererFactory.getInstance().createDicomObjectRenderer(imageObject.getDataset(), iPixelDataFrame, n, null);
        if (iDicomObjectRenderer == null) {
            return null;
        }
        try {
            int[] nArray = this.computeScaling(iPixelDataFrame.getWidth(), iPixelDataFrame.getHeight());
            return DicomObjectRendererUtils.toBufferedImage((IDicomObjectRenderer)iDicomObjectRenderer, (boolean)true, (int)nArray[0], (int)nArray[1], (int)1, null, (boolean)this.includeDemographics);
        }
        catch (Exception exception) {
            log.error("Couldn't create image", (Throwable)exception);
            return null;
        }
    }
}

