/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.glue.datahandler;

import com.agfa.pacs.background.IBackgroundTask;
import com.agfa.pacs.base.ProgressState;
import com.agfa.pacs.data.hw.manager.DicomDataManager4;
import com.agfa.pacs.data.hw.manager.DicomDataRequest;
import com.agfa.pacs.data.shared.data.IDicomDataListener;
import com.agfa.pacs.data.shared.dicom.UIDConfiguration;
import com.agfa.pacs.data.shared.dicom.UIDType;
import com.agfa.pacs.data.shared.export.BackgroundProcessingTask;
import com.agfa.pacs.data.shared.hw.DicomDataRequester;
import com.agfa.pacs.data.shared.hw.IDicomDataRequest;
import com.agfa.pacs.data.shared.lw.ILoadableInfo;
import com.agfa.pacs.impaxee.data.fetcher.IFetchable;
import com.agfa.pacs.impaxee.data.fetcher.IFetcher;
import com.agfa.pacs.impaxee.glue.data.DataObjectUtilities;
import com.agfa.pacs.impaxee.glue.datahandler.IdleListener;
import com.agfa.pacs.listtext.lta.util.job.JobControl;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.base.data.IImageObjectData;
import com.tiani.base.data.IObjectData;
import com.tiani.base.data.IObjectListener;
import com.tiani.jvision.main.GuiUsageListener;
import com.tiani.jvision.main.MouseIdleChecker;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class DataFetcherManager
implements IFetcher {
    private static final ALogger log = ALogger.getLogger(DataFetcherManager.class);
    private static final boolean logging = false;
    private DicomDataManager4 requester = (DicomDataManager4)DicomDataRequester.getInstance();
    private IdleListener idleListener;
    private static final Set<String> ignoredSOPClassUIDs = new HashSet<String>();

    DataFetcherManager() {
        ignoredSOPClassUIDs.add("1.2.840.10008.5.1.4.1.1.4.2");
        ignoredSOPClassUIDs.addAll(UIDConfiguration.getInstance().getSOPClassUIDs(UIDType.Video));
        this.idleListener = new IdleListener();
        MouseIdleChecker.getInstance().registerGuiUsageListener((GuiUsageListener)this.idleListener);
    }

    public void resetState() {
        this.requester.clearQueues(0, 6);
    }

    public void clear() {
        this.requester.clearAllQueues();
    }

    public void appendData(List<? extends IFetchable> list, byte by) {
        ArrayList<DicomDataRequest> arrayList = new ArrayList<DicomDataRequest>(list.size());
        DicomDataRequest dicomDataRequest = null;
        for (IFetchable iFetchable : list) {
            DicomDataRequest dicomDataRequest2 = this.requester.findRequest(iFetchable.getLoadableDataInfo());
            if (dicomDataRequest2 != null) {
                if (dicomDataRequest2.addListener(iFetchable.getDataListener())) continue;
                log.info("Object request not usable");
            }
            dicomDataRequest = this.requester.createDicomDataRequest(iFetchable.getLoadableDataInfo(), by);
            dicomDataRequest.setListener(iFetchable.getDataListener());
            arrayList.add(dicomDataRequest);
        }
        if (!arrayList.isEmpty()) {
            if (arrayList.size() == 1) {
                this.requester.addRequest((IDicomDataRequest)arrayList.get(0));
            } else {
                this.requester.addRequests(arrayList);
            }
        }
    }

    public void removeDatas(List<? extends IFetchable> list) {
        ArrayList<ILoadableInfo> arrayList = new ArrayList<ILoadableInfo>(list.size());
        for (IFetchable iFetchable : list) {
            arrayList.add(iFetchable.getLoadableDataInfo());
        }
        this.requester.cancelObjectRequests(arrayList);
    }

    public void changeToHigherPriorityIfExists(Collection<? extends IFetchable> collection, byte by) {
        ArrayList<ILoadableInfo> arrayList = new ArrayList<ILoadableInfo>(collection.size());
        for (IFetchable iFetchable : collection) {
            arrayList.add(iFetchable.getLoadableDataInfo());
        }
        this.requester.changePriorityToHigherAndAdvance(arrayList, by);
    }

    public void changeToHigherPriorityIfExists(IFetchable iFetchable, byte by) {
        this.requester.changePriorityToHigherAndAdvance(iFetchable.getLoadableDataInfo(), by);
    }

    public void changePriorityIfExists(List<? extends IFetchable> list, byte by) {
        ArrayList<ILoadableInfo> arrayList = new ArrayList<ILoadableInfo>(list.size());
        for (IFetchable iFetchable : list) {
            arrayList.add(iFetchable.getLoadableDataInfo());
        }
        this.requester.changePriority(arrayList, by);
    }

    private IDicomDataRequest changeToHigherPriorityInt(IFetchable iFetchable, byte by) {
        boolean bl = this.requester.changePriorityToHigherAndAdvance(iFetchable.getLoadableDataInfo(), by);
        if (!bl) {
            if (iFetchable.isStartedBeingLoaded()) {
                return null;
            }
            log.debug("Need to recreate Request");
            DicomDataRequest dicomDataRequest = this.requester.createDicomDataRequest(iFetchable.getLoadableDataInfo(), by);
            dicomDataRequest.setListener(iFetchable.getDataListener());
            this.requester.addRequest((IDicomDataRequest)dicomDataRequest);
            return dicomDataRequest;
        }
        return null;
    }

    public void cancelRequest(ILoadableInfo iLoadableInfo) {
        DicomDataRequest dicomDataRequest = this.requester.findRequest(iLoadableInfo);
        if (dicomDataRequest != null) {
            this.requester.cancelRequest((IDicomDataRequest)dicomDataRequest);
        }
    }

    public void changeToHigherPriority(IFetchable iFetchable, byte by) {
        this.changeToHigherPriorityInt(iFetchable, by);
    }

    public void fetchImmediatly(IFetchable iFetchable) {
        DicomDataRequest dicomDataRequest = this.requester.createDicomDataRequest(iFetchable.getLoadableDataInfo(), (byte)0);
        dicomDataRequest.setListener(iFetchable.getDataListener());
        this.requester.addRequest((IDicomDataRequest)dicomDataRequest);
        dicomDataRequest.waitUntilFinished();
    }

    public void preFetch(List<IFrameObjectData> list, byte by, IDicomDataListener iDicomDataListener, IObjectListener iObjectListener) {
        HashSet<IImageObjectData> hashSet = new HashSet<IImageObjectData>();
        for (IFrameObjectData iFrameObjectData : list) {
            hashSet.add(iFrameObjectData.getMainFrame());
        }
        for (IImageObjectData iImageObjectData : hashSet) {
            if (iImageObjectData.isFullyLoaded()) {
                iDicomDataListener.dicomDataFinished(iImageObjectData.getSOPInstanceUID(), IDicomDataListener.Status.Success, null);
                continue;
            }
            iImageObjectData.addListener(iObjectListener);
        }
    }

    public boolean isIgnoredSOPClass(String string) {
        return ignoredSOPClassUIDs.contains(string);
    }

    public void exportDicomObjects(List<IObjectData> list, File file, boolean bl, ProgressState progressState) {
        BackgroundProcessingTask backgroundProcessingTask = new BackgroundProcessingTask("Retrieve->Transcode->DicomFile");
        Properties properties = new Properties();
        properties.put("CREATE_DICOM_DIR", (Object)bl);
        properties.put("DICOM_DIRECTORY", file);
        properties.put("ALLOWED_TRANSFER_SYNTAXES", Collections.singleton("1.2.840.10008.1.2"));
        IBackgroundTask iBackgroundTask = backgroundProcessingTask.createTask(DataObjectUtilities.createObjectInfos(list), properties, (PropertyChangeListener)new ExportImagesFinishedListener(progressState));
        JobControl jobControl = new JobControl(iBackgroundTask.getInfo(), "");
        jobControl.addTask(iBackgroundTask);
        Thread thread = new Thread((Runnable)jobControl, "Export for third-party");
        thread.setPriority(1);
        thread.start();
    }

    private static class ExportImagesFinishedListener
    implements PropertyChangeListener {
        private ProgressState ps;

        public ExportImagesFinishedListener(ProgressState progressState) {
            this.ps = progressState;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equalsIgnoreCase("RUNNING_STATE") && !((Boolean)propertyChangeEvent.getNewValue()).booleanValue()) {
                this.ps.everythingDone(true);
            }
        }
    }
}

