/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.glue.data;

import com.agfa.pacs.base.util.DicomUtils;
import com.agfa.pacs.data.shared.data.IDicomDataListener;
import com.agfa.pacs.data.shared.dicom.UIDType;
import com.agfa.pacs.data.shared.dicom.UIDUtilities;
import com.agfa.pacs.data.shared.icon.IIconInfo;
import com.agfa.pacs.data.shared.icon.impl.ImageIconInfo;
import com.agfa.pacs.data.shared.instanceinfo.IInstanceInfo;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IDataInfoSource;
import com.agfa.pacs.data.shared.lw.ILoadableInfo;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.lw.ISeriesInfo;
import com.agfa.pacs.data.shared.pixel.IPixelDataInfo;
import com.agfa.pacs.impaxee.attributefilter.AttributeFilterRegistry;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.glue.data.AbstractImageObjectData;
import com.agfa.pacs.impaxee.glue.data.ImpaxEEDataObject;
import com.agfa.pacs.impaxee.glue.data.ImpaxEEKeyObjectData;
import com.agfa.pacs.impaxee.glue.data.ImpaxEENonLeafDataObject;
import com.agfa.pacs.impaxee.glue.data.ImpaxEEObjectData;
import com.agfa.pacs.impaxee.glue.data.ImpaxEEPresentationStateObjectData;
import com.agfa.pacs.impaxee.glue.datainfo.ImpaxEEInstanceInfo;
import com.agfa.pacs.impaxee.glue.datainfo.ImpaxEEObjectInfo;
import com.agfa.pacs.impaxee.glue.datanode.ImpaxEEDataInfoNodeProvider;
import com.agfa.pacs.impaxee.setlive.SetLiveUtil;
import com.agfa.pacs.listtext.lta.base.tagdictionary.DicomTag;
import com.agfa.pacs.listtext.lta.base.tagdictionary.PrivateTagDictionary;
import com.tiani.base.data.IImageObjectData;
import com.tiani.base.data.IKeyObjectData;
import com.tiani.base.data.IObjectData;
import com.tiani.base.data.IPresentationStateObjectData;
import com.tiani.base.data.ISeriesData;
import com.tiani.base.data.IStudyData;
import java.awt.Image;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;
import org.dcm4che3.util.UIDUtils;

public class ImpaxEESeriesData
extends ImpaxEENonLeafDataObject<ISeriesInfo>
implements ISeriesData,
IDicomDataListener {
    private static final int[] seriesTags = DicomTag.extractTags((List)AttributeFilterRegistry.getInstance().getSeriesDicomTags());
    private Map<String, AbstractImageObjectData> objects;
    private IStudyData parent;
    private boolean containsDerivedImages;
    private boolean secondaryCaptureSaved = false;
    private boolean secondaryCapture = false;
    private boolean setLiveSC = false;
    private Integer numberOfFramesCached = null;
    private String modality;
    private String description;
    private boolean startedBeingLoaded = false;
    private final AtomicInteger numberOfLoadedImages = new AtomicInteger(0);

    public ImpaxEESeriesData(ISeriesInfo iSeriesInfo, boolean bl) {
        super(iSeriesInfo);
        this.containsDerivedImages = bl;
        this.modality = ImpaxEESeriesData.getStringToUpperCase(iSeriesInfo.getAttributes(), 524384);
        this.description = ImpaxEESeriesData.getStringToUpperCase(iSeriesInfo.getAttributes(), 528446);
        this.init();
    }

    private static String getStringToUpperCase(Attributes attributes, int n) {
        String string = attributes.getString(n);
        if (string != null) {
            string = string.toUpperCase();
        }
        return string;
    }

    public String getSeriesInstanceUID() {
        return this.getDicomObject().getString(0x20000E);
    }

    protected void init() {
        this.objects = new HashMap<String, AbstractImageObjectData>(64);
        this.numberOfFramesCached = null;
    }

    public IImageObjectData addObject(IImageObjectData iImageObjectData) {
        if (this.objects.containsKey(iImageObjectData.getKey())) {
            return this.objects.get(iImageObjectData.getKey());
        }
        iImageObjectData.setParent((ISeriesData)this);
        if (!(iImageObjectData instanceof AbstractImageObjectData)) {
            log.error("Internal Error,wrong instance");
            return null;
        }
        AbstractImageObjectData abstractImageObjectData = (AbstractImageObjectData)iImageObjectData;
        if (!this.secondaryCapture && DicomUtils.isSecondaryCapture((String)iImageObjectData.getSOPClassUID())) {
            this.secondaryCapture = true;
            String string = ((IObjectInfo)abstractImageObjectData.getDataInfo()).getSource().getIdentifier().getType();
            this.secondaryCaptureSaved = !string.equals("SINGLE_FILE_NOT_SAVED") && !string.equals("IMPAXEE");
            if (SetLiveUtil.isSetLiveSecondaryCapture((Attributes)iImageObjectData.getDicomObject())) {
                this.setLiveSC = true;
            }
        }
        this.objects.put(abstractImageObjectData.getKey(), abstractImageObjectData);
        this.numberOfFramesCached = null;
        return iImageObjectData;
    }

    public IImageObjectData removeObject(String string) {
        AbstractImageObjectData abstractImageObjectData = this.objects.remove(string);
        if (abstractImageObjectData != null) {
            abstractImageObjectData.cleanUp();
        }
        if (this.objects.size() == 0) {
            this.getParent().removeSeries((ISeriesData)this);
        }
        this.numberOfFramesCached = null;
        return abstractImageObjectData;
    }

    public IImageObjectData getObjectsByUID(String string) {
        return this.objects.get(string);
    }

    public void setParent(IStudyData iStudyData) {
        this.parent = iStudyData;
    }

    public IStudyData getParent() {
        return this.parent;
    }

    public List<IImageObjectData> getObjects() {
        return new ArrayList<IImageObjectData>(this.objects.values());
    }

    public int getObjectCount() {
        return this.objects.size();
    }

    public IImageObjectData getFirstObject() {
        if (this.objects.isEmpty()) {
            return null;
        }
        return this.objects.entrySet().iterator().next().getValue();
    }

    public <U extends IObjectData> U createObjectData(Class<U> clazz, String string, String string2) {
        return this.createObjectData(clazz, string, string2, UIDUtils.createUID(), null, 1);
    }

    public <U extends IObjectData> U createObjectData(Class<U> clazz, String string, String string2, Image image, int n) {
        return this.createObjectData(clazz, string, string2, UIDUtils.createUID(), image, n);
    }

    public <U extends IObjectData> U createObjectData(Class<U> clazz, String string, String string2, String string3, int n) {
        return this.createObjectData(clazz, string, string2, string3, null, n);
    }

    private <U extends IObjectData> U createObjectData(Class<U> clazz, String string, String string2, String string3, Image image, int n) {
        ImpaxEEObjectData impaxEEObjectData = null;
        Object u = this.getDataInfo();
        Date date = new Date();
        ImpaxEEObjectInfo impaxEEObjectInfo = new ImpaxEEObjectInfo((IDataInfo)u, string3);
        impaxEEObjectInfo.setSource((IDataInfoSource)ImpaxEEDataInfoNodeProvider.getInstance());
        if (image != null) {
            impaxEEObjectInfo.getSource().getIconProvider().getIconCache().putIcon(impaxEEObjectInfo.getSOPInstanceUID(), (IIconInfo)new ImageIconInfo(image, false));
        }
        Attributes attributes = impaxEEObjectInfo.getAttributes();
        attributes.addAll(this.getParent().getParent().getDicomObject());
        attributes.addAll(this.getParent().getDicomObject());
        attributes.addAll(this.getDicomObject());
        attributes.setString(524310, VR.UI, string);
        attributes.setString(524312, VR.UI, string3);
        attributes.setInt(2097171, VR.IS, new int[]{this.objects.size() + 1});
        attributes.setString(131088, VR.UI, string2);
        attributes.setDate(524306, VR.DA, new Date[]{date});
        attributes.setDate(524307, VR.TM, new Date[]{date});
        if (n > 1) {
            impaxEEObjectInfo.getAttributes().setInt(0x280008, VR.IS, new int[]{n});
        }
        u.addChild((IDataInfo)impaxEEObjectInfo);
        if (IImageObjectData.class == clazz) {
            impaxEEObjectData = AbstractImageObjectData.createObjectData((IObjectInfo)impaxEEObjectInfo);
        }
        if (IKeyObjectData.class == clazz) {
            impaxEEObjectData = new ImpaxEEKeyObjectData((IObjectInfo)impaxEEObjectInfo);
        }
        if (IPresentationStateObjectData.class == clazz) {
            impaxEEObjectData = new ImpaxEEPresentationStateObjectData((IObjectInfo)impaxEEObjectInfo);
        }
        if (impaxEEObjectData != null) {
            ((ImpaxEEDataObject)impaxEEObjectData).setDicomObject(new Attributes(impaxEEObjectInfo.getAttributes()));
            if (impaxEEObjectData instanceof AbstractImageObjectData) {
                this.addObject((IImageObjectData)impaxEEObjectData);
            }
        }
        impaxEEObjectInfo.setInstanceInfo((IInstanceInfo)new ImpaxEEInstanceInfo(impaxEEObjectData));
        return (U)impaxEEObjectData;
    }

    public boolean isLossyData() {
        return false;
    }

    public boolean containsDerivedImages() {
        return this.containsDerivedImages;
    }

    public boolean isSecondaryCaptureSaved() {
        if (!this.secondaryCapture) {
            return true;
        }
        return this.secondaryCaptureSaved;
    }

    public void setSecondaryCaptureSaved(boolean bl) {
        if (this.secondaryCapture) {
            this.secondaryCaptureSaved = bl;
        }
    }

    public boolean isSecondaryCapture() {
        return this.secondaryCapture;
    }

    public void setSecondaryCapture() {
        this.secondaryCapture = true;
    }

    public boolean isSetLiveSecondaryCapture() {
        return this.setLiveSC;
    }

    public void setSetLiveSecondaryCapture() {
        this.setSecondaryCapture();
        this.setLiveSC = true;
    }

    @Override
    public String resolveString(int n) {
        if (PrivateTagDictionary.isPrivateTag((int)n)) {
            if (PrivateTagDictionary.seriesNumberOfImagesTag == n) {
                return this.isImageSeries() ? Integer.toString(this.getNumberOfFrames()) : "0";
            }
            return this.getParent().resolveString(n);
        }
        return super.resolveString(n);
    }

    public int getNumberOfFrames() {
        if (this.isImageSeries()) {
            if (this.numberOfFramesCached != null) {
                return this.numberOfFramesCached;
            }
            int n = 0;
            for (AbstractImageObjectData abstractImageObjectData : this.objects.values()) {
                n += abstractImageObjectData.getFrameCount();
            }
            this.numberOfFramesCached = n;
            return n;
        }
        return 0;
    }

    public boolean isImageSeries() {
        String string = this.getDicomObject().getString(524310);
        return !UIDUtilities.isType((String)string, (UIDType)UIDType.Presentation) && !UIDUtilities.isType((String)string, (UIDType)UIDType.KeyObject) && !UIDUtilities.isType((String)string, (UIDType)UIDType.StructuredReport);
    }

    public void cleanUp() {
        if (log.isTraceEnabled()) {
            log.trace("Cleaning up references in instance of " + this.getClass().getName() + ": " + this.getKey());
        }
        for (AbstractImageObjectData abstractImageObjectData : this.objects.values()) {
            abstractImageObjectData.cleanUp();
        }
        this.objects = new HashMap<String, AbstractImageObjectData>(1);
    }

    public IDicomDataListener getDataListener() {
        return this;
    }

    public String getUID() {
        return this.getSeriesInstanceUID();
    }

    public void dicomDataAvailable(String string, Attributes attributes, boolean bl) {
        AbstractImageObjectData abstractImageObjectData;
        this.startedBeingLoaded = true;
        if (!this.headerComplete) {
            this.setDicomObject(attributes);
        }
        if ((abstractImageObjectData = this.objects.get(string)) != null) {
            abstractImageObjectData.dicomDataAvailable(string, attributes, bl);
        }
    }

    public void dicomDataError(String string, String string2, Throwable throwable) {
        AbstractImageObjectData abstractImageObjectData = this.objects.get(string);
        if (abstractImageObjectData != null) {
            abstractImageObjectData.dicomDataError(string, string2, throwable);
        }
    }

    public void dicomDataFinished(String string, IDicomDataListener.Status status, Attributes attributes) {
        AbstractImageObjectData abstractImageObjectData = this.objects.get(string);
        if (abstractImageObjectData != null) {
            abstractImageObjectData.dicomDataFinished(string, status, attributes);
        }
    }

    public void pixelDataAvailable(String string, IPixelDataInfo iPixelDataInfo, int n) {
        AbstractImageObjectData abstractImageObjectData = this.objects.get(string);
        if (abstractImageObjectData != null) {
            abstractImageObjectData.pixelDataAvailable(string, iPixelDataInfo, n);
        }
    }

    public ILoadableInfo getLoadableDataInfo() {
        return (ILoadableInfo)this.dataInfo;
    }

    @Override
    public void setDicomObject(Attributes attributes) {
        Attributes attributes2;
        if (!this.headerComplete) {
            if (!this.secondaryCaptureSaved && this.secondaryCapture) {
                return;
            }
            attributes2 = new Attributes();
            attributes2.addSelected(attributes, seriesTags);
            attributes2.addAll(this.dicomObject);
            this.dicomObject = attributes2;
            this.headerComplete = true;
        }
        if (!this.parent.isHeaderComplete()) {
            this.parent.setDicomObject(attributes);
            attributes2 = this.parent.getParent();
            if (!attributes2.isHeaderComplete()) {
                attributes2.setDicomObject(attributes);
            }
        }
    }

    public String getModality() {
        return this.modality;
    }

    public String getSeriesDescription() {
        return this.description;
    }

    public void resetLoadedFlag() {
        this.headerComplete = false;
        this.startedBeingLoaded = false;
    }

    public boolean isStartedBeingLoaded() {
        return this.startedBeingLoaded;
    }

    public void notifyObjectLoaded() {
        if (this.numberOfLoadedImages.incrementAndGet() >= this.objects.size()) {
            this.parent.notifySeriesLoaded();
            if (DataManager.RETRIEVE_LOSSY && !this.hasLossyPrefetchedImages()) {
                DataManager.getInstance().notifyRepaintDisplaySets();
            }
        }
    }

    public boolean isSeriesLoaded() {
        return this.numberOfLoadedImages.get() >= this.objects.size();
    }

    public void decreaseLoadedObjectCount() {
        this.numberOfLoadedImages.decrementAndGet();
    }

    public boolean isLoadedFromThinSliceArchive() {
        return Boolean.TRUE.equals(this.getQueryObject().getAttributes().getProperty("ThinArchive", null));
    }

    private boolean hasLossyPrefetchedImages() {
        if (this.getParent().getParent().isPrefetchingLossyImagesEnabled()) {
            for (IImageObjectData iImageObjectData : this.objects.values()) {
                if (!iImageObjectData.isPrefetchingLossyImageEnabled()) continue;
                return true;
            }
        }
        return false;
    }
}

