/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.glue.data;

import com.agfa.pacs.data.shared.lw.DataInfoUtilities;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.impaxee.glue.data.AbstractImageObjectData;
import com.agfa.pacs.impaxee.glue.data.ImpaxEEDataObject;
import com.agfa.pacs.impaxee.glue.data.ImpaxEEFrameObjectData;
import com.agfa.pacs.impaxee.glue.data.ImpaxEEImageObjectData;
import com.agfa.pacs.impaxee.glue.data.ImpaxEEObjectData;
import com.agfa.pacs.impaxee.glue.data.ImpaxEESingleFrameData;
import com.agfa.pacs.impaxee.glue.data.ImpaxEEVisObjectData;
import com.tiani.base.data.IDataObject;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.base.data.IImageObjectData;
import com.tiani.base.data.IObjectData;
import com.tiani.base.data.ISeriesData;
import com.tiani.base.data.IStudyData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DataObjectUtilities {
    public static List<IObjectInfo> createObjectInfos(Collection<? extends IDataObject> collection) {
        return DataObjectUtilities.createObjectInfos(collection, false);
    }

    public static List<IObjectInfo> createObjectInfosForPrinting(Collection<? extends IDataObject> collection) {
        return DataObjectUtilities.createObjectInfos(collection, true);
    }

    private static List<IObjectInfo> createObjectInfos(Collection<? extends IDataObject> collection, boolean bl) {
        return DataObjectUtilities.createObjectInfos(collection.toArray(new IDataObject[collection.size()]), bl);
    }

    public static Map<IObjectInfo, IObjectInfo> createObjectInfoMap(Collection<? extends IDataObject> collection) {
        return DataObjectUtilities.createObjectInfoMap(collection.toArray(new IDataObject[collection.size()]), false);
    }

    public static List<IObjectInfo> createObjectInfos(IDataObject[] iDataObjectArray) {
        return DataObjectUtilities.createObjectInfos(iDataObjectArray, false);
    }

    private static List<IObjectInfo> createObjectInfos(IDataObject[] iDataObjectArray, boolean bl) {
        Map<IObjectInfo, IObjectInfo> map = DataObjectUtilities.createObjectInfoMap(iDataObjectArray, bl);
        if (map != null) {
            return new ArrayList<IObjectInfo>(map.keySet());
        }
        return Collections.emptyList();
    }

    private static Map<IObjectInfo, IObjectInfo> createObjectInfoMap(IDataObject[] iDataObjectArray, boolean bl) {
        if (iDataObjectArray == null || iDataObjectArray.length == 0) {
            return Collections.emptyMap();
        }
        LinkedHashMap<IObjectInfo, IObjectInfo> linkedHashMap = new LinkedHashMap<IObjectInfo, IObjectInfo>(iDataObjectArray.length);
        HashMap<String, IDataInfo> hashMap = new HashMap<String, IDataInfo>();
        HashMap<String, IDataInfo> hashMap2 = new HashMap<String, IDataInfo>();
        HashMap<String, IDataInfo> hashMap3 = new HashMap<String, IDataInfo>();
        HashMap<String, IDataInfo> hashMap4 = new HashMap<String, IDataInfo>();
        HashSet<String> hashSet = new HashSet<String>();
        IDataObject[] iDataObjectArray2 = iDataObjectArray;
        int n = iDataObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object2;
            IImageObjectData iImageObjectData;
            IDataObject iDataObject = iDataObjectArray2[n2];
            if (iDataObject instanceof IStudyData) {
                iImageObjectData = new HashSet(256);
                for (Object object2 : ((IStudyData)iDataObject).getSeries()) {
                    for (IImageObjectData iImageObjectData2 : object2.getObjects()) {
                        linkedHashMap.put(((AbstractImageObjectData)iImageObjectData2).getFullDataInfo(), (IObjectInfo)((AbstractImageObjectData)iImageObjectData2).getDataInfo());
                        iImageObjectData.add(iImageObjectData2.getSOPInstanceUID());
                    }
                }
                for (Object object2 : DataInfoUtilities.getLevel((IDataInfo)((IStudyData)iDataObject).getQueryObject(), IObjectInfo.class)) {
                    if (iImageObjectData.contains(object2.getKey())) continue;
                    linkedHashMap.put((IObjectInfo)object2, (IObjectInfo)object2);
                }
            } else if (iDataObject instanceof IFrameObjectData) {
                iImageObjectData = ((IFrameObjectData)iDataObject).getMainFrame();
                object2 = ((ImpaxEEFrameObjectData)iDataObject).getDataInfo();
                if (iImageObjectData.getFrameCount() == 1 || !hashSet.contains(object2.getSOPInstanceUID())) {
                    linkedHashMap.put(((ImpaxEEFrameObjectData)iDataObject).getFullDataInfo(), (IObjectInfo)object2);
                    hashSet.add(object2.getSOPInstanceUID());
                }
            } else if (iDataObject instanceof IObjectData) {
                iImageObjectData = (IObjectData)iDataObject;
                object2 = null;
                if (iImageObjectData instanceof AbstractImageObjectData) {
                    object2 = (IObjectInfo)((AbstractImageObjectData)iImageObjectData).getDataInfo();
                }
                if (object2 != null && !linkedHashMap.containsKey(object2)) {
                    IDataInfo iDataInfo = object2.copy(true);
                    linkedHashMap.put((IObjectInfo)iDataInfo, (IObjectInfo)object2);
                }
            } else if (iDataObject instanceof ImpaxEEVisObjectData) {
                iImageObjectData = ((ImpaxEEVisObjectData)iDataObject).createObjectInfo(bl, hashMap, hashMap2, hashMap3, hashMap4);
                if (iImageObjectData != null) {
                    linkedHashMap.put((IObjectInfo)iImageObjectData, (IObjectInfo)iImageObjectData);
                }
            } else if (iDataObject instanceof ISeriesData) {
                object2 = ((ISeriesData)iDataObject).getObjects().iterator();
                while (object2.hasNext()) {
                    iImageObjectData = (IImageObjectData)object2.next();
                    linkedHashMap.put(((AbstractImageObjectData)iImageObjectData).getFullDataInfo(), (IObjectInfo)((AbstractImageObjectData)iImageObjectData).getDataInfo());
                }
            } else {
                throw new IllegalArgumentException("Incompatible type");
            }
            ++n2;
        }
        return linkedHashMap;
    }

    public static List<? extends IDataInfo> createDataInfosForWorklist(Collection<? extends IDataObject> collection) {
        ArrayList<IObjectInfo> arrayList = new ArrayList<IObjectInfo>(collection.size());
        for (IDataObject iDataObject : collection) {
            Object object;
            if (iDataObject instanceof ImpaxEEObjectData) {
                object = (IObjectInfo)((ImpaxEEObjectData)iDataObject).getDataInfo();
                if (arrayList.contains(object)) continue;
                arrayList.add((IObjectInfo)object);
                continue;
            }
            if (iDataObject instanceof ImpaxEEFrameObjectData) {
                object = ((IFrameObjectData)iDataObject).getMainFrame();
                IObjectInfo iObjectInfo = null;
                if (object instanceof ImpaxEESingleFrameData) {
                    iObjectInfo = (IObjectInfo)((ImpaxEESingleFrameData)object).getDataInfo();
                } else if (object instanceof ImpaxEEImageObjectData) {
                    iObjectInfo = (IObjectInfo)((ImpaxEEImageObjectData)object).getDataInfo();
                }
                if (iObjectInfo == null || arrayList.contains(iObjectInfo)) continue;
                arrayList.add(iObjectInfo);
                continue;
            }
            if (!(iDataObject instanceof ImpaxEEDataObject) || arrayList.contains(object = ((ImpaxEEDataObject)iDataObject).getDataInfo())) continue;
            arrayList.add((IObjectInfo)object);
        }
        return arrayList;
    }
}

