/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.math;

import com.agfa.pacs.math.GeomUtil;
import com.agfa.pacs.math.IBoundingBox;
import com.agfa.pacs.math.Plane;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class AxisAlignedBoundingBox
implements IBoundingBox {
    protected static final double numeric = 1.0E-15;
    protected Point3d min;
    protected Point3d max;
    protected Point3d corner00;
    protected Point3d corner01;
    protected Point3d corner02;
    protected Point3d corner03;
    protected Point3d corner10;
    protected Point3d corner11;
    protected Point3d corner12;
    protected Point3d corner13;

    public AxisAlignedBoundingBox() {
        this.min = new Point3d(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
        this.max = new Point3d(-1.7976931348623157E308, -1.7976931348623157E308, -1.7976931348623157E308);
    }

    public void addEnclosedPoint(Point3d point3d) {
        if (point3d.x < this.min.x) {
            this.min.x = point3d.x;
        }
        if (point3d.y < this.min.y) {
            this.min.y = point3d.y;
        }
        if (point3d.z < this.min.z) {
            this.min.z = point3d.z;
        }
        if (point3d.x > this.max.x) {
            this.max.x = point3d.x;
        }
        if (point3d.y > this.max.y) {
            this.max.y = point3d.y;
        }
        if (point3d.z > this.max.z) {
            this.max.z = point3d.z;
        }
        this.corner00 = null;
    }

    public AxisAlignedBoundingBox(Point3d point3d, Point3d point3d2) {
        this.min = point3d;
        this.max = point3d2;
    }

    protected IBoundingBox create(Point3d point3d, Point3d point3d2) {
        return new AxisAlignedBoundingBox(point3d, point3d2);
    }

    @Override
    public IBoundingBox[] splitAlignedX(double d) {
        Point3d point3d = new Point3d(this.min.x, this.min.y, this.min.z);
        Point3d point3d2 = new Point3d(this.min.x + (this.max.x - this.min.x) * d, this.max.y, this.max.z);
        Point3d point3d3 = new Point3d(this.min.x + (this.max.x - this.min.x) * d, this.min.y, this.min.z);
        Point3d point3d4 = new Point3d(this.max.x, this.max.y, this.max.z);
        IBoundingBox[] iBoundingBoxArray = new AxisAlignedBoundingBox[]{this.create(point3d, point3d2), this.create(point3d3, point3d4)};
        return iBoundingBoxArray;
    }

    @Override
    public IBoundingBox[] splitAlignedY(double d) {
        Point3d point3d = new Point3d(this.min.x, this.min.y, this.min.z);
        Point3d point3d2 = new Point3d(this.max.x, this.min.y + (this.max.y - this.min.y) * d, this.max.z);
        Point3d point3d3 = new Point3d(this.min.x, this.min.y + (this.max.y - this.min.y) * d, this.min.z);
        Point3d point3d4 = new Point3d(this.max.x, this.max.y, this.max.z);
        IBoundingBox[] iBoundingBoxArray = new AxisAlignedBoundingBox[]{this.create(point3d, point3d2), this.create(point3d3, point3d4)};
        return iBoundingBoxArray;
    }

    @Override
    public IBoundingBox[] splitAlignedZ(double d) {
        Point3d point3d = new Point3d(this.min.x, this.min.y, this.min.z);
        Point3d point3d2 = new Point3d(this.max.x, this.max.y, this.min.z + (this.max.z - this.min.z) * d);
        Point3d point3d3 = new Point3d(this.min.x, this.min.y, this.min.z + (this.max.z - this.min.z) * d);
        Point3d point3d4 = new Point3d(this.max.x, this.max.y, this.max.z);
        IBoundingBox[] iBoundingBoxArray = new AxisAlignedBoundingBox[]{this.create(point3d, point3d2), this.create(point3d3, point3d4)};
        return iBoundingBoxArray;
    }

    @Override
    public boolean intersects(Plane plane) {
        Vector3d vector3d;
        if (this.corner00 == null) {
            this.corner00 = new Point3d(this.min.x, this.min.y, this.min.z);
            this.corner01 = new Point3d(this.max.x, this.min.y, this.min.z);
            this.corner02 = new Point3d(this.max.x, this.max.y, this.min.z);
            this.corner03 = new Point3d(this.min.x, this.max.y, this.min.z);
            this.corner10 = new Point3d(this.min.x, this.min.y, this.min.z);
            this.corner11 = new Point3d(this.max.x, this.min.y, this.max.z);
            this.corner12 = new Point3d(this.max.x, this.max.y, this.max.z);
            this.corner13 = new Point3d(this.min.x, this.max.y, this.max.z);
        }
        if ((vector3d = GeomUtil.intersectLineAndPlane(plane.p, plane.n, this.corner00, this.corner12)) != null && this.isInside((Tuple3d)vector3d)) {
            return true;
        }
        vector3d = GeomUtil.intersectLineAndPlane(plane.p, plane.n, this.corner01, this.corner13);
        if (vector3d != null && this.isInside((Tuple3d)vector3d)) {
            return true;
        }
        vector3d = GeomUtil.intersectLineAndPlane(plane.p, plane.n, this.corner02, this.corner10);
        if (vector3d != null && this.isInside((Tuple3d)vector3d)) {
            return true;
        }
        vector3d = GeomUtil.intersectLineAndPlane(plane.p, plane.n, this.corner03, this.corner11);
        return vector3d != null && this.isInside((Tuple3d)vector3d);
    }

    @Override
    public boolean isInside(Tuple3d tuple3d) {
        if (tuple3d.x < this.min.x - 1.0E-15 || tuple3d.x > this.max.x + 1.0E-15) {
            return false;
        }
        if (tuple3d.y < this.min.y - 1.0E-15 || tuple3d.y > this.max.y + 1.0E-15) {
            return false;
        }
        return !(tuple3d.z < this.min.z - 1.0E-15) && !(tuple3d.z > this.max.z + 1.0E-15);
    }

    @Override
    public void addConstantBorder(double d) {
        this.min.x -= d;
        this.min.y -= d;
        this.min.z -= d;
        this.max.x += d;
        this.max.y += d;
        this.max.z += d;
    }

    public String toString() {
        return "(BBox: " + this.min + "/" + this.max + ")";
    }
}

