/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.hap.geometry.impl.twod;

import com.agfa.hap.geometry.api.twod.ILine2d;
import com.agfa.hap.geometry.api.twod.IPolygon2d;
import com.agfa.hap.geometry.impl.twod.AlignedRectangle2d;
import com.agfa.hap.geometry.impl.twod.Line2d;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Point2d;
import javax.vecmath.Vector2d;

public class Polygon2d
implements IPolygon2d {
    protected List<Point2d> points = null;
    protected AlignedRectangle2d boundingBox = null;

    public Polygon2d(List<Point2d> list) {
        if (list == null) {
            throw new IllegalArgumentException("points is NULL.");
        }
        if (list.size() < 3) {
            throw new IllegalArgumentException("points list contains only " + list.size() + " points.");
        }
        this.points = new ArrayList<Point2d>(list.size());
        for (Point2d point2d : list) {
            this.points.add(point2d);
        }
        this.removeCircular();
    }

    private void removeCircular() {
        Point2d point2d = this.points.get(0);
        Point2d point2d2 = this.points.get(this.points.size() - 1);
        if (point2d.x == point2d2.x && point2d.y == point2d2.y) {
            this.points.remove(this.points.size() - 1);
        }
        if (this.points.size() < 3) {
            throw new IllegalArgumentException("points list contains only " + this.points.size() + " points.");
        }
    }

    protected Polygon2d() {
    }

    @Override
    public List<Point2d> getPoints() {
        return this.points;
    }

    @Override
    public AlignedRectangle2d getBoundingBox() {
        if (this.boundingBox == null) {
            this.boundingBox = this.computeBoundingBox();
        }
        return this.boundingBox;
    }

    private AlignedRectangle2d computeBoundingBox() {
        double d = Double.MAX_VALUE;
        double d2 = -d;
        double d3 = Double.MAX_VALUE;
        double d4 = -d3;
        for (Point2d point2d : this.points) {
            if (point2d.x < d) {
                d = point2d.x;
            }
            if (point2d.x > d2) {
                d2 = point2d.x;
            }
            if (point2d.y < d3) {
                d3 = point2d.y;
            }
            if (!(point2d.y > d4)) continue;
            d4 = point2d.y;
        }
        return new AlignedRectangle2d(new Point2d(d, d3), new Vector2d(d2 - d, d4 - d3));
    }

    protected boolean intersectsBoundingBox(ILine2d iLine2d) {
        AlignedRectangle2d alignedRectangle2d = this.getBoundingBox();
        return alignedRectangle2d.intersect(iLine2d) != null;
    }

    @Override
    public List<Point2d> intersect(ILine2d iLine2d) {
        if (!this.intersectsBoundingBox(iLine2d)) {
            return null;
        }
        ArrayList<Point2d> arrayList = new ArrayList<Point2d>();
        int n = this.points.size();
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2 % n;
            int n4 = (n2 + 1) % n;
            Line2d line2d = new Line2d(this.points.get(n3), this.points.get(n4), true, true, false);
            Point2d point2d = iLine2d.intersect(line2d);
            if (point2d != null) {
                arrayList.add(point2d);
            }
            ++n2;
        }
        if (arrayList.size() > 0) {
            return arrayList;
        }
        return null;
    }
}

