/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.hap.geometry.impl.twod;

import com.agfa.hap.geometry.api.twod.ILine2d;
import com.agfa.hap.mathematics.MathExtended;
import javax.vecmath.Point2d;
import javax.vecmath.Tuple2d;
import javax.vecmath.Vector2d;

public class Line2d
implements ILine2d {
    public Point2d point0 = null;
    public Point2d point1 = null;
    public Vector2d direction = null;
    public boolean lineSegment = false;
    public boolean includePoint0 = true;
    public boolean includePoint1 = true;

    public Line2d(Point2d point2d, Point2d point2d2) {
        this(point2d, point2d2, false);
    }

    public Line2d(Point2d point2d, Point2d point2d2, boolean bl) {
        this(point2d, point2d2, bl, true, true);
    }

    public Line2d(Point2d point2d, Point2d point2d2, boolean bl, boolean bl2, boolean bl3) {
        this.point0 = new Point2d(point2d);
        this.point1 = new Point2d(point2d2);
        this.direction = new Vector2d((Tuple2d)point2d2);
        this.direction.sub((Tuple2d)point2d);
        this.lineSegment = bl;
        this.includePoint0 = bl2;
        this.includePoint1 = bl3;
    }

    @Override
    public boolean isLineSegment() {
        return this.lineSegment;
    }

    @Override
    public boolean isPoint0Included() {
        return this.includePoint0;
    }

    @Override
    public boolean isPoint1Included() {
        return this.includePoint1;
    }

    @Override
    public Point2d getPoint0() {
        return this.point0;
    }

    @Override
    public Point2d getPoint1() {
        return this.point1;
    }

    @Override
    public Point2d getPoint(double d) {
        Vector2d vector2d = new Vector2d(this.direction);
        vector2d.scale(d);
        vector2d.add((Tuple2d)this.point0);
        return new Point2d((Tuple2d)vector2d);
    }

    @Override
    public Vector2d getDirection() {
        return this.direction;
    }

    @Override
    public double distanceToPoint(Point2d point2d) {
        Vector2d vector2d = new Vector2d(this.direction.y, -this.direction.x);
        vector2d.normalize();
        Vector2d vector2d2 = new Vector2d((Tuple2d)point2d);
        vector2d2.sub((Tuple2d)this.point0);
        return vector2d.dot(vector2d2);
    }

    @Override
    public Point2d intersect(ILine2d iLine2d) {
        Point2d point2d = iLine2d.getPoint0();
        Vector2d vector2d = iLine2d.getDirection();
        double[] dArray = new double[]{this.direction.x, -vector2d.x, this.direction.y, -vector2d.y};
        double[] dArray2 = new double[]{point2d.x - this.point0.x, point2d.y - this.point0.y};
        double[] dArray3 = MathExtended.solveLinaerSystem2by2(dArray, dArray2);
        if (dArray3 != null && this.isInSegment(this, dArray3[0]) && this.isInSegment(iLine2d, dArray3[1])) {
            return this.getPoint(dArray3[0]);
        }
        return null;
    }

    private boolean isInSegment(ILine2d iLine2d, double d) {
        if (!iLine2d.isLineSegment()) {
            return true;
        }
        if (iLine2d.isPoint0Included() && d < 0.0 || !iLine2d.isPoint0Included() && d <= 0.0) {
            return false;
        }
        return !(iLine2d.isPoint1Included() && 1.0 < d) && (iLine2d.isPoint1Included() || !(1.0 <= d));
    }
}

