/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.hap.geometry.impl.threed;

import com.agfa.hap.geometry.api.threed.ILine;
import com.agfa.hap.geometry.impl.threed.Shape3d;
import com.agfa.hap.mathematics.MathExtended;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector4d;

public class Cylinder
extends Shape3d {
    public Cylinder(Point3d point3d, double d, double d2, List<Vector4d> list) {
        super(point3d, list, new Vector3d(d, d, d2 * 0.5));
    }

    @Override
    public List<Point3d> intersect(Point3d point3d, Vector3d vector3d, ILine iLine) {
        double d;
        int n;
        ArrayList<Point3d> arrayList = new ArrayList<Point3d>(2);
        double d2 = vector3d.x * vector3d.x + vector3d.y * vector3d.y;
        double d3 = 2.0 * (point3d.x * vector3d.x + point3d.y * vector3d.y);
        double d4 = point3d.x * point3d.x + point3d.y * point3d.y - 1.0;
        double[] dArray = MathExtended.solveQuadraticEquation(d2, d3, d4);
        if (dArray != null) {
            n = 0;
            while (n < dArray.length) {
                d = point3d.z + dArray[n] * vector3d.z;
                if (-1.0 <= d && d <= 1.0) {
                    arrayList.add(iLine.getPoint(dArray[n]));
                }
                ++n;
            }
        }
        dArray = null;
        if (vector3d.z != 0.0) {
            dArray = new double[]{(-1.0 - point3d.z) / vector3d.z, (1.0 - point3d.z) / vector3d.z};
        }
        if (dArray != null) {
            n = 0;
            while (n < 2) {
                d = point3d.x + dArray[n] * vector3d.x;
                double d5 = point3d.y + dArray[n] * vector3d.y;
                if ((d *= d) + (d5 *= d5) <= 1.0) {
                    arrayList.add(iLine.getPoint(dArray[n]));
                }
                ++n;
            }
        }
        return arrayList;
    }
}

