/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.hap.geometry.impl.threed;

import com.agfa.hap.geometry.api.threed.ILine;
import com.agfa.hap.geometry.impl.threed.Shape3d;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector4d;

public class Cuboid
extends Shape3d {
    public Cuboid(Point3d point3d, Vector3d vector3d, List<Vector4d> list) {
        super(point3d, list, new Vector3d(vector3d.x * 0.5, vector3d.y * 0.5, vector3d.z * 0.5));
    }

    @Override
    public List<Point3d> intersect(Point3d point3d, Vector3d vector3d, ILine iLine) {
        ArrayList<Point3d> arrayList = new ArrayList<Point3d>(2);
        this.intersectXaxis(point3d, vector3d, iLine, arrayList);
        this.intersectYaxis(point3d, vector3d, iLine, arrayList);
        this.intersectZaxis(point3d, vector3d, iLine, arrayList);
        return arrayList;
    }

    private void intersectXaxis(Point3d point3d, Vector3d vector3d, ILine iLine, List<Point3d> list) {
        Point3d point3d2;
        double d;
        double[] dArray = new double[]{1.0, 1.0, 1.0};
        if (vector3d.x != 0.0) {
            d = (1.0 - point3d.x) / vector3d.x;
            point3d2 = this.pointOnLine(point3d, vector3d, d);
            if (-dArray[1] <= point3d2.y && point3d2.y <= dArray[1] && -dArray[2] <= point3d2.z && point3d2.z <= dArray[2]) {
                list.add(iLine.getPoint(d));
            }
        }
        if (vector3d.x != 0.0) {
            d = (-1.0 - point3d.x) / vector3d.x;
            point3d2 = this.pointOnLine(point3d, vector3d, d);
            if (-dArray[1] <= point3d2.y && point3d2.y <= dArray[1] && -dArray[2] <= point3d2.z && point3d2.z <= dArray[2]) {
                list.add(iLine.getPoint(d));
            }
        }
    }

    private void intersectYaxis(Point3d point3d, Vector3d vector3d, ILine iLine, List<Point3d> list) {
        Point3d point3d2;
        double d;
        double[] dArray = new double[]{1.0, 1.0, 1.0};
        if (vector3d.y != 0.0) {
            d = (1.0 - point3d.y) / vector3d.y;
            point3d2 = this.pointOnLine(point3d, vector3d, d);
            if (-dArray[0] <= point3d2.x && point3d2.x <= dArray[0] && -dArray[2] <= point3d2.z && point3d2.z <= dArray[2]) {
                list.add(iLine.getPoint(d));
            }
        }
        if (vector3d.y != 0.0) {
            d = (-1.0 - point3d.y) / vector3d.y;
            point3d2 = this.pointOnLine(point3d, vector3d, d);
            if (-dArray[0] <= point3d2.x && point3d2.x <= dArray[0] && -dArray[2] <= point3d2.z && point3d2.z <= dArray[2]) {
                list.add(iLine.getPoint(d));
            }
        }
    }

    private void intersectZaxis(Point3d point3d, Vector3d vector3d, ILine iLine, List<Point3d> list) {
        Point3d point3d2;
        double d;
        double[] dArray = new double[]{1.0, 1.0, 1.0};
        if (vector3d.z != 0.0) {
            d = (1.0 - point3d.z) / vector3d.z;
            point3d2 = this.pointOnLine(point3d, vector3d, d);
            if (-dArray[0] <= point3d2.x && point3d2.x <= dArray[0] && -dArray[1] <= point3d2.y && point3d2.y <= dArray[1]) {
                list.add(iLine.getPoint(d));
            }
        }
        if (vector3d.z != 0.0) {
            d = (-1.0 - point3d.z) / vector3d.z;
            point3d2 = this.pointOnLine(point3d, vector3d, d);
            if (-dArray[0] <= point3d2.x && point3d2.x <= dArray[0] && -dArray[1] <= point3d2.y && point3d2.y <= dArray[1]) {
                list.add(iLine.getPoint(d));
            }
        }
    }

    private Point3d pointOnLine(Point3d point3d, Vector3d vector3d, double d) {
        return new Point3d(point3d.x + d * vector3d.x, point3d.y + d * vector3d.y, point3d.z + d * vector3d.z);
    }
}

