/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.hap.geometry.impl.threed;

import com.agfa.hap.geometry.api.threed.ILine;
import com.agfa.hap.geometry.impl.threed.Shape3d;
import com.agfa.hap.mathematics.MathExtended;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector4d;

public class Cone
extends Shape3d {
    public Cone(Point3d point3d, double d, double d2, List<Vector4d> list) {
        super(point3d, list, new Vector3d(d, d, d2));
    }

    @Override
    public List<Point3d> intersect(Point3d point3d, Vector3d vector3d, ILine iLine) {
        ArrayList<Point3d> arrayList = new ArrayList<Point3d>(2);
        double d = vector3d.x * vector3d.x + vector3d.y * vector3d.y - vector3d.z * vector3d.z;
        double d2 = 2.0 * (point3d.x * vector3d.x + point3d.y * vector3d.y - point3d.z * vector3d.z);
        double d3 = point3d.x * point3d.x + point3d.y * point3d.y - point3d.z * point3d.z;
        double[] dArray = MathExtended.solveQuadraticEquation(d, d2, d3);
        if (dArray != null) {
            int n = 0;
            while (n < dArray.length) {
                double d4 = point3d.z + dArray[n] * vector3d.z;
                if (0.0 <= d4 && d4 <= 1.0) {
                    arrayList.add(iLine.getPoint(dArray[n]));
                }
                ++n;
            }
        }
        return arrayList;
    }
}

