/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.hap.geometry.impl.threed;

import com.agfa.hap.geometry.impl.threed.PolyLine;
import javax.vecmath.Vector3f;

public class BSpline {
    protected static int BUFFER = 80;
    protected int number_of_Stuetzpunkte;
    protected int number_of_Intervalle;
    protected int k;
    protected PolyLine stuetzPunkte;
    protected float[] stuetzPunkte_x;
    protected float[] stuetzPunkte_y;
    protected float[] stuetzPunkte_z;
    protected float[] N;
    protected float[] ta;

    public BSpline(PolyLine polyLine, int n) {
        this.number_of_Stuetzpunkte = polyLine.getCount();
        if (this.number_of_Stuetzpunkte < n) {
            n = this.number_of_Stuetzpunkte;
        }
        this.stuetzPunkte = new PolyLine(polyLine);
        this.stuetzPunkte_x = this.stuetzPunkte.getXPoints();
        this.stuetzPunkte_y = this.stuetzPunkte.getYPoints();
        this.stuetzPunkte_z = this.stuetzPunkte.getZPoints();
        this.k = n;
        this.N = new float[n];
        this.ta = new float[n + this.number_of_Stuetzpunkte + BUFFER];
        this.berechneKnotenvektor();
        this.number_of_Intervalle = this.number_of_Stuetzpunkte - n + 1;
    }

    protected void berechneKnotenvektor() {
        int n = this.k + this.number_of_Stuetzpunkte + BUFFER;
        int n2 = 0;
        while (n2 < n) {
            this.ta[n2] = n2 < this.k ? 0.0f : (n2 <= this.number_of_Stuetzpunkte ? (float)(n2 - this.k + 1) : (float)(this.number_of_Stuetzpunkte - this.k + 1));
            ++n2;
        }
    }

    public void getConstantSampledCurve(PolyLine polyLine, float f, float f2, float f3) {
        polyLine.clear();
        float f4 = 0.0f;
        float f5 = 0.5f;
        float f6 = f2;
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        Vector3f vector3f3 = new Vector3f(this.stuetzPunkte_x[this.number_of_Stuetzpunkte - 1], this.stuetzPunkte_y[this.number_of_Stuetzpunkte - 1], this.stuetzPunkte_z[this.number_of_Stuetzpunkte - 1]);
        this.makeWeights(f4);
        this.berechnePunkt(f4, vector3f2);
        while (f4 < (float)this.number_of_Intervalle) {
            polyLine.add(vector3f2.x, vector3f2.y, vector3f2.z);
            vector3f.x = vector3f2.x;
            vector3f.y = vector3f2.y;
            vector3f.z = vector3f2.z;
            int n = 0;
            while (!(f4 + (f5 *= f2 / f6) >= (float)this.number_of_Intervalle)) {
                if (f5 < 0.001f) {
                    f5 = 0.001f;
                    break;
                }
                this.makeWeights(f4 + f5);
                this.berechnePunkt(f4 + f5, vector3f2);
                f6 = this.getDist(vector3f2, vector3f, f);
                if (n++ <= 30 && (f6 > f2 + f3 || f6 < f2 - f3)) continue;
            }
            f4 += f5;
        }
        polyLine.add(vector3f3.x, vector3f3.y, vector3f3.z);
    }

    protected float getDist(Vector3f vector3f, Vector3f vector3f2, float f) {
        return (float)Math.sqrt((vector3f.x - vector3f2.x) * (vector3f.x - vector3f2.x) + (vector3f.y - vector3f2.y) * (vector3f.y - vector3f2.y) + (vector3f.z - vector3f2.z) * (vector3f.z - vector3f2.z) * f * f);
    }

    protected void makeWeights(float f) {
        int n = (int)f + this.k - 1;
        this.N[0] = 1.0f;
        int n2 = 2;
        while (n2 <= this.k) {
            int n3 = n;
            while (n3 >= n - n2 + 1) {
                float f2 = n3 == n ? 0.0f : (this.ta[n3 + n2] - f) * this.N[n3 - n + n2 - 1] / (this.ta[n3 + n2] - this.ta[n3 + 1]);
                if (n3 != n - n2 + 1) {
                    f2 += (f - this.ta[n3]) * this.N[n3 - n + n2 - 2] / (this.ta[n3 + n2 - 1] - this.ta[n3]);
                }
                this.N[n3 - n + n2 - 1] = f2;
                --n3;
            }
            ++n2;
        }
    }

    protected void berechnePunkt(float f, Vector3f vector3f) {
        vector3f.x = 0.0f;
        vector3f.y = 0.0f;
        vector3f.z = 0.0f;
        int n = 0;
        while (n < this.k) {
            vector3f.x += this.stuetzPunkte_x[(int)f + n] * this.N[n];
            vector3f.y += this.stuetzPunkte_y[(int)f + n] * this.N[n];
            vector3f.z += this.stuetzPunkte_z[(int)f + n] * this.N[n];
            ++n;
        }
    }
}

