/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicom.modifier.dataset;

import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.data.dicom.QueryRetrieveLevel;
import com.agfa.pacs.listtext.dicom.modifier.dataset.IModificationObject;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.ElementDictionary;
import org.dcm4che3.data.PersonName;
import org.dcm4che3.data.SpecificCharacterSet;
import org.dcm4che3.util.UIDUtils;

public abstract class AbstractModificationObject
implements IModificationObject {
    private static final String cuid = "1.2.40.0.13.1.3.1.2.3.1.1";
    private final String iuid;
    private final String tsuid;
    private final SpecificCharacterSet specCharset;
    private final QueryRetrieveLevel qrLevel;
    private final IModificationObject.ReasonForModification reasonForModification;
    private final String modifyingSystem;
    private HashMap<Integer, Object> modificationValues;

    protected AbstractModificationObject(SpecificCharacterSet specificCharacterSet, QueryRetrieveLevel queryRetrieveLevel, IModificationObject.ReasonForModification reasonForModification) {
        this.specCharset = specificCharacterSet;
        this.qrLevel = queryRetrieveLevel;
        this.reasonForModification = reasonForModification;
        this.iuid = UIDUtils.createUID();
        this.tsuid = "1.2.840.10008.1.2";
        this.modifyingSystem = this.getModifyingSystemImpl();
    }

    @Override
    public String getSOPClassUID() {
        return cuid;
    }

    @Override
    public String getSOPInstanceUID() {
        return this.iuid;
    }

    @Override
    public String getTransferSyntaxUID() {
        return this.tsuid;
    }

    @Override
    public SpecificCharacterSet getSpecificCharacterSet() {
        return this.specCharset;
    }

    @Override
    public QueryRetrieveLevel getQueryRetrieveLevel() {
        return this.qrLevel;
    }

    @Override
    public String getModifyingSystem() {
        return this.modifyingSystem;
    }

    @Override
    public IModificationObject.ReasonForModification getReasonForModification() {
        return this.reasonForModification;
    }

    @Override
    public void putModification(int n, Object object) {
        if (this.modificationValues == null) {
            this.modificationValues = new HashMap();
        }
        this.modificationValues.put(n, object);
    }

    @Override
    public Object getModification(int n) {
        if (this.modificationValues != null) {
            return this.modificationValues.get(n);
        }
        return null;
    }

    @Override
    public Attributes toDataset() {
        Attributes attributes = new Attributes();
        AbstractModificationObject.putValue(this.tsuid, 131088, attributes);
        AbstractModificationObject.putValue(this.specCharset, 524293, attributes);
        AbstractModificationObject.putValue(this.qrLevel.dicom(), 524370, attributes);
        AbstractModificationObject.putValue(this.reasonForModification.name(), 67110245, attributes);
        AbstractModificationObject.putValue(this.modifyingSystem, 67110243, attributes);
        if (this.modificationValues != null) {
            for (Map.Entry<Integer, Object> entry : this.modificationValues.entrySet()) {
                AbstractModificationObject.putValue(entry.getValue(), entry.getKey(), attributes);
            }
        }
        return attributes;
    }

    private String getModifyingSystemImpl() {
        return String.valueOf(Product.getProductName()) + " " + Product.getVersionString();
    }

    protected static void putValue(Object object, int n, Attributes attributes) {
        if (object == null) {
            attributes.remove(n);
        } else if (object instanceof String) {
            attributes.setString(n, ElementDictionary.vrOf((int)n, null), (String)object);
        } else if (object instanceof Date) {
            attributes.setDate(n, ElementDictionary.vrOf((int)n, null), new Date[]{(Date)object});
        } else if (object instanceof Integer) {
            attributes.setInt(n, ElementDictionary.vrOf((int)n, null), new int[]{(Integer)object});
        } else if (object instanceof Float) {
            attributes.setFloat(n, ElementDictionary.vrOf((int)n, null), new float[]{((Float)object).floatValue()});
        } else if (object instanceof Double) {
            attributes.setDouble(n, ElementDictionary.vrOf((int)n, null), new double[]{(Double)object});
        } else if (object instanceof PersonName) {
            attributes.setString(n, ElementDictionary.vrOf((int)n, null), ((PersonName)object).toString());
        }
    }
}

