/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicom.exporter.image;

import com.agfa.pacs.cache.CacheID;
import com.agfa.pacs.cache.DataCacheProviderFactory;
import com.agfa.pacs.cache.IDataCacheProvider;
import com.agfa.pacs.data.export.ImageObject;
import com.agfa.pacs.data.shared.export.ProcessingException;
import com.agfa.pacs.listtext.dicom.exporter.image.IExportImageRenderer;
import com.agfa.pacs.listtext.dicom.exporter.image.Image;
import java.awt.image.BufferedImage;

public class LazyImage
extends Image {
    private static final IDataCacheProvider cache = DataCacheProviderFactory.getCache();
    private final IExportImageRenderer renderer;
    private final ImageObject imageObject;
    private final CacheID cacheId;

    public LazyImage(ImageObject imageObject, int n, IExportImageRenderer iExportImageRenderer) {
        super(null, imageObject.getDataset(), n);
        this.renderer = iExportImageRenderer;
        this.imageObject = imageObject;
        this.cacheId = cache.createID();
    }

    @Override
    public BufferedImage getImage() throws ProcessingException {
        BufferedImage bufferedImage = (BufferedImage)cache.getContentObject(this.cacheId);
        if (bufferedImage == null) {
            bufferedImage = this.renderer.renderImage(this.imageObject, this.frameNumber);
        }
        cache.putContentObject((Object)bufferedImage, this.cacheId);
        return bufferedImage;
    }

    protected void finalize() throws Throwable {
        cache.getContentObject(this.cacheId);
        super.finalize();
    }
}

