/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.export.internal;

import java.util.Arrays;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.VR;

public class ImpaxEEProfile {
    private static final int[] PATIENT_KEYS = new int[]{524293, 0x100010, 0x100020};
    private static final int[] STUDY_KEYS = new int[]{524293, 524320, 524336, 524368, 528432, 0x20000D, 0x200010};
    private static final int[] SERIES_KEYS = new int[]{524293, 524384, 0x20000E, 0x200011, 524321, 524337};
    private static final int[] IMAGE_KEYS = new int[]{524293, 528704, 2097171, 0x200032, 2097207, 0x200052, 2621456, 2621457, 2621488, 524322, 524338};
    private static final int[] RT_DOSE_SET = new int[]{524293, 2097171, 805568522};
    private static final int[] RT_STRUCTURE_SET = new int[]{524293, 2097171, 805699586, 805699592, 805699593};
    private static final int[] RT_PLAN_KEYS = new int[]{524293, 2097171, 805961730, 805961734, 805961735};
    private static final int[] RT_TREATMENT_KEYS = new int[]{524293, 2097171, 805831248, 805831249};
    private static final int[] PRESENTATION_KEYS = new int[]{524293, 528661, 2097171, 0x700080, 7340161, 7340162, 7340163, 7340164};
    private static final int[] SR_DOCUMENT_KEYS = new int[]{524293, 524323, 524339, 0x700080, 2097171, 4235312, 4235331, 4236433, 4236435};
    private static final int[] KEY_OBJECT_DOCUMENT_KEYS = new int[]{524293, 524323, 524339, 2097171, 4235331};
    private static final int[] WAVEFROM_KEYS = new int[]{524293, 524323, 524339, 2097171};
    private static final int[] SPECTROSCOPY_KEYS = new int[]{524293, 524296, 524323, 524339, 561298, 2097171, 0x280008, 2621456, 2621457, 2658305, 2658306};
    private static final int[] RAWDATA_KEYS = WAVEFROM_KEYS;
    private static final int[] REGISTRATION_KEYS = new int[]{524293, 524323, 524339, 2097171, 0x700080, 7340161, 7340164};
    private static final int[] FIDUCIAL_KEYS = REGISTRATION_KEYS;
    private static final int[] HANGING_PROTOCOL_KEYS = new int[]{524293, 0x720002, 7471108, 7471110, 7471112, 7471114, 7471116, 7471124, 7471118};
    private static final int[] ENCAPSULATED_DOCUMENT_KEYS = new int[]{524293, 524323, 524339, 2097171, 4235331, 4325392, 4325394};
    private static final int[] HL7_STRUCTURED_DOCUMENT_KEYS = new int[]{524293, 4251649, 0x40E004, 4251654, 4325392};
    private static final int[] REAL_WORLD_VALUE_MAPPING_KEYS = REGISTRATION_KEYS;
    private int[] patientKeys = PATIENT_KEYS;
    private int[] studyKeys = STUDY_KEYS;
    private int[] seriesKeys = SERIES_KEYS;
    private int[] imageKeys = IMAGE_KEYS;
    private int[] rtDoseKeys = RT_DOSE_SET;
    private int[] rtStructureSetKeys = RT_STRUCTURE_SET;
    private int[] rtPlanKeys = RT_PLAN_KEYS;
    private int[] rtTreatmentRecordKeys = RT_TREATMENT_KEYS;
    private int[] presentationKeys = PRESENTATION_KEYS;
    private int[] waveformKeys = WAVEFROM_KEYS;
    private int[] srDocumentKeys = SR_DOCUMENT_KEYS;
    private int[] keyObjectDocumentKeys = KEY_OBJECT_DOCUMENT_KEYS;
    private int[] spectroscopyKeys = SPECTROSCOPY_KEYS;
    private int[] rawdataKeys = RAWDATA_KEYS;
    private int[] registrationKeys = REGISTRATION_KEYS;
    private int[] fiducialKeys = FIDUCIAL_KEYS;
    private int[] hangingProtocolKeys = HANGING_PROTOCOL_KEYS;
    private int[] encapsulatedDocumentKeys = ENCAPSULATED_DOCUMENT_KEYS;
    private int[] hl7StructuredDocumentKeys = HL7_STRUCTURED_DOCUMENT_KEYS;
    private int[] realWorldValueMappingKeys = REAL_WORLD_VALUE_MAPPING_KEYS;

    public final int[] getEncapsulatedDocumentKeys() {
        return (int[])this.encapsulatedDocumentKeys.clone();
    }

    public final void setEncapsulatedDocumentKeys(int[] nArray) {
        this.encapsulatedDocumentKeys = (int[])nArray.clone();
    }

    public final int[] getFiducialKeys() {
        return (int[])this.fiducialKeys.clone();
    }

    public final void setFiducialKeys(int[] nArray) {
        this.fiducialKeys = (int[])nArray.clone();
    }

    public final int[] getHangingProtocolKeys() {
        return (int[])this.hangingProtocolKeys.clone();
    }

    public final void setHangingProtocolKeys(int[] nArray) {
        this.hangingProtocolKeys = (int[])nArray.clone();
    }

    public final int[] getHl7StructuredDocumentKeys() {
        return (int[])this.hl7StructuredDocumentKeys.clone();
    }

    public final void setHl7StructuredDocumentKeys(int[] nArray) {
        this.hl7StructuredDocumentKeys = (int[])nArray.clone();
    }

    public final int[] getImageKeys() {
        return (int[])this.imageKeys.clone();
    }

    public final void setImageKeys(int[] nArray) {
        this.imageKeys = (int[])nArray.clone();
    }

    public final int[] getKeyObjectDocumentKeys() {
        return (int[])this.keyObjectDocumentKeys.clone();
    }

    public final void setKeyObjectDocumentKeys(int[] nArray) {
        this.keyObjectDocumentKeys = (int[])nArray.clone();
    }

    public final int[] getPatientKeys() {
        return (int[])this.patientKeys.clone();
    }

    public final void setPatientKeys(int[] nArray) {
        this.patientKeys = (int[])nArray.clone();
    }

    public final int[] getPresentationKeys() {
        return (int[])this.presentationKeys.clone();
    }

    public final void setPresentationKeys(int[] nArray) {
        this.presentationKeys = (int[])nArray.clone();
    }

    public final int[] getRawdataKeys() {
        return (int[])this.rawdataKeys.clone();
    }

    public final void setRawdataKeys(int[] nArray) {
        this.rawdataKeys = (int[])nArray.clone();
    }

    public final int[] getRealWorldValueMappingKeys() {
        return (int[])this.realWorldValueMappingKeys.clone();
    }

    public final void setRealWorldValueMappingKeys(int[] nArray) {
        this.realWorldValueMappingKeys = (int[])nArray.clone();
    }

    public final int[] getRegistrationKeys() {
        return (int[])this.registrationKeys.clone();
    }

    public final void setRegistrationKeys(int[] nArray) {
        this.registrationKeys = (int[])nArray.clone();
    }

    public final int[] getRtDoseKeys() {
        return (int[])this.rtDoseKeys.clone();
    }

    public final void setRtDoseKeys(int[] nArray) {
        this.rtDoseKeys = (int[])nArray.clone();
    }

    public final int[] getRtPlanKeys() {
        return (int[])this.rtPlanKeys.clone();
    }

    public final void setRtPlanKeys(int[] nArray) {
        this.rtPlanKeys = (int[])nArray.clone();
    }

    public final int[] getRtStructureSetKeys() {
        return (int[])this.rtStructureSetKeys.clone();
    }

    public final void setRtStructureSetKeys(int[] nArray) {
        this.rtStructureSetKeys = (int[])nArray.clone();
    }

    public final int[] getRtTreatmentRecordKeys() {
        return (int[])this.rtTreatmentRecordKeys.clone();
    }

    public final void setRtTreatmentRecordKeys(int[] nArray) {
        this.rtTreatmentRecordKeys = (int[])nArray.clone();
    }

    public final int[] getSeriesKeys() {
        return (int[])this.seriesKeys.clone();
    }

    public final void setSeriesKeys(int[] nArray) {
        this.seriesKeys = (int[])nArray.clone();
    }

    public final int[] getSpectroscopyKeys() {
        return (int[])this.spectroscopyKeys.clone();
    }

    public final void setSpectroscopyKeys(int[] nArray) {
        this.spectroscopyKeys = (int[])nArray.clone();
    }

    public final int[] getSrDocumentKeys() {
        return (int[])this.srDocumentKeys.clone();
    }

    public final void setSrDocumentKeys(int[] nArray) {
        this.srDocumentKeys = (int[])nArray.clone();
    }

    public final int[] getStudyKeys() {
        return (int[])this.studyKeys.clone();
    }

    public final void setStudyKeys(int[] nArray) {
        this.studyKeys = (int[])nArray.clone();
    }

    public final int[] getWaveformKeys() {
        return (int[])this.waveformKeys.clone();
    }

    public final void setWaveformKeys(int[] nArray) {
        this.waveformKeys = (int[])nArray.clone();
    }

    private Attributes makeRecord(String string, int[] nArray, Attributes attributes) {
        Attributes attributes2 = new Attributes();
        attributes2.setString(267312, VR.CS, string);
        Arrays.sort(nArray);
        attributes2.addSelected(attributes, nArray);
        return attributes2;
    }

    private Attributes makeRecord(String string, int[] nArray, Attributes attributes, String[] stringArray) {
        Attributes attributes2 = this.makeRecord(string, nArray, attributes);
        attributes2.setString(267520, VR.CS, stringArray);
        attributes2.setString(267537, VR.UI, attributes.getString(131075));
        attributes2.setString(267536, VR.UI, attributes.getString(131074));
        attributes2.setString(267538, VR.UI, attributes.getString(131088));
        String string2 = attributes.getString(524314);
        if (string2 != null) {
            attributes2.setString(267546, VR.UI, string2);
        }
        return attributes2;
    }

    public Attributes makePatientDirectoryRecord(Attributes attributes) {
        Attributes attributes2 = this.makeRecord("PATIENT", this.patientKeys, attributes);
        if (!attributes2.contains(0x100010)) {
            attributes2.setNull(0x100010, VR.PN);
        }
        if (!attributes2.containsValue(0x100020)) {
            attributes2.setString(0x100020, VR.LO, attributes.getString(0x20000D));
        }
        return attributes2;
    }

    public Attributes makeStudyDirectoryRecord(Attributes attributes) {
        Attributes attributes2 = this.makeRecord("STUDY", this.studyKeys, attributes);
        return attributes2;
    }

    public Attributes makeSeriesDirectoryRecord(Attributes attributes) {
        Attributes attributes2 = this.makeRecord("SERIES", this.seriesKeys, attributes);
        return attributes2;
    }

    public Attributes makeInstanceDirectoryRecord(Attributes attributes, String[] stringArray) {
        String string = attributes.getString(131074);
        switch (string.hashCode()) {
            case -525617006: {
                if (!"1.2.840.10008.5.1.4.1.1.66".equals(string)) break;
                return this.makeRawDataDirectoryRecord(attributes, stringArray);
            }
            case -525617005: {
                if (!"1.2.840.10008.5.1.4.1.1.67".equals(string)) break;
                return this.makeRealWorldValueMappingDirectorRecord(attributes, stringArray);
            }
            case 789790566: {
                if (!"1.2.840.10008.5.1.4.1.1.104.1".equals(string)) break;
                return this.makeEncapsulatedDocumentDirectorRecord(attributes, stringArray);
            }
            case 792796575: {
                if (!"1.2.840.10008.5.1.4.1.1.481.2".equals(string)) break;
                return this.makeRTDoseDirectoryRecord(attributes, stringArray);
            }
            case 792796576: {
                if (!"1.2.840.10008.5.1.4.1.1.481.3".equals(string)) break;
                return this.makeRTStructuredSetDirectoryRecord(attributes, stringArray);
            }
            case 792796577: {
                if (!"1.2.840.10008.5.1.4.1.1.481.4".equals(string)) break;
                return this.makeRTTreatmentDirectoryRecord(attributes, stringArray);
            }
            case 792796578: {
                if (!"1.2.840.10008.5.1.4.1.1.481.5".equals(string)) break;
                return this.makeRTPlanDirectoryRecord(attributes, stringArray);
            }
            case 792796579: {
                if (!"1.2.840.10008.5.1.4.1.1.481.6".equals(string)) break;
                return this.makeRTTreatmentDirectoryRecord(attributes, stringArray);
            }
            case 792796580: {
                if (!"1.2.840.10008.5.1.4.1.1.481.7".equals(string)) break;
                return this.makeRTTreatmentDirectoryRecord(attributes, stringArray);
            }
            case 792796581: {
                if (!"1.2.840.10008.5.1.4.1.1.481.8".equals(string)) break;
                return this.makeRTPlanDirectoryRecord(attributes, stringArray);
            }
            case 792796582: {
                if (!"1.2.840.10008.5.1.4.1.1.481.9".equals(string)) break;
                return this.makeRTTreatmentDirectoryRecord(attributes, stringArray);
            }
            case 796487868: {
                if (!"1.2.840.10008.5.1.4.1.1.88.11".equals(string)) break;
                return this.makeSRDocumentDirectoryRecord(attributes, stringArray);
            }
            case 796487900: {
                if (!"1.2.840.10008.5.1.4.1.1.88.22".equals(string)) break;
                return this.makeSRDocumentDirectoryRecord(attributes, stringArray);
            }
            case 796487932: {
                if (!"1.2.840.10008.5.1.4.1.1.88.33".equals(string)) break;
                return this.makeSRDocumentDirectoryRecord(attributes, stringArray);
            }
            case 796487960: {
                if (!"1.2.840.10008.5.1.4.1.1.88.40".equals(string)) break;
                return this.makeSRDocumentDirectoryRecord(attributes, stringArray);
            }
            case 796487991: {
                if (!"1.2.840.10008.5.1.4.1.1.88.50".equals(string)) break;
                return this.makeSRDocumentDirectoryRecord(attributes, stringArray);
            }
            case 796488000: {
                if (!"1.2.840.10008.5.1.4.1.1.88.59".equals(string)) break;
                return this.makeKeyObjectDirectoryRecord(attributes, stringArray);
            }
            case 796488027: {
                if (!"1.2.840.10008.5.1.4.1.1.88.65".equals(string)) break;
                return this.makeSRDocumentDirectoryRecord(attributes, stringArray);
            }
            case 796488029: {
                if (!"1.2.840.10008.5.1.4.1.1.88.67".equals(string)) break;
                return this.makeSRDocumentDirectoryRecord(attributes, stringArray);
            }
            case 797116269: {
                if (!"1.2.840.10008.5.1.4.1.1.9.1.1".equals(string)) break;
                return this.makeWaveformDirectoryRecord(attributes, stringArray);
            }
            case 797116270: {
                if (!"1.2.840.10008.5.1.4.1.1.9.1.2".equals(string)) break;
                return this.makeWaveformDirectoryRecord(attributes, stringArray);
            }
            case 797116271: {
                if (!"1.2.840.10008.5.1.4.1.1.9.1.3".equals(string)) break;
                return this.makeWaveformDirectoryRecord(attributes, stringArray);
            }
            case 797117230: {
                if (!"1.2.840.10008.5.1.4.1.1.9.2.1".equals(string)) break;
                return this.makeWaveformDirectoryRecord(attributes, stringArray);
            }
            case 797118191: {
                if (!"1.2.840.10008.5.1.4.1.1.9.3.1".equals(string)) break;
                return this.makeWaveformDirectoryRecord(attributes, stringArray);
            }
            case 797119152: {
                if (!"1.2.840.10008.5.1.4.1.1.9.4.1".equals(string)) break;
                return this.makeWaveformDirectoryRecord(attributes, stringArray);
            }
            case 885739878: {
                if (!"1.2.840.10008.5.1.4.1.1.4.2".equals(string)) break;
                return this.makeSpectroscopyDirectoryRecord(attributes, stringArray);
            }
            case 1688045877: {
                if (!"1.2.840.10008.5.1.4.1.1.11.1".equals(string)) break;
                return this.makePresentationStateDirectoryRecord(attributes, stringArray);
            }
            case 1688045878: {
                if (!"1.2.840.10008.5.1.4.1.1.11.2".equals(string)) break;
                return this.makePresentationStateDirectoryRecord(attributes, stringArray);
            }
            case 1688045879: {
                if (!"1.2.840.10008.5.1.4.1.1.11.3".equals(string)) break;
                return this.makePresentationStateDirectoryRecord(attributes, stringArray);
            }
            case 1688045880: {
                if (!"1.2.840.10008.5.1.4.1.1.11.4".equals(string)) break;
                return this.makePresentationStateDirectoryRecord(attributes, stringArray);
            }
            case 1688199637: {
                if (!"1.2.840.10008.5.1.4.1.1.66.1".equals(string)) break;
                return this.makeRegistrationDirectoryRecord(attributes, stringArray);
            }
            case 1688199638: {
                if (!"1.2.840.10008.5.1.4.1.1.66.2".equals(string)) break;
                return this.makeFiducialDirectoryRecord(attributes, stringArray);
            }
        }
        return this.makeImageDirectoryRecord(attributes, stringArray);
    }

    public Attributes makeImageDirectoryRecord(Attributes attributes, String[] stringArray) {
        Attributes attributes2 = this.makeRecord("IMAGE", this.imageKeys, attributes, stringArray);
        return attributes2;
    }

    public Attributes makeRTDoseDirectoryRecord(Attributes attributes, String[] stringArray) {
        Attributes attributes2 = this.makeRecord("RT DOSE", this.rtDoseKeys, attributes, stringArray);
        return attributes2;
    }

    public Attributes makeRTStructuredSetDirectoryRecord(Attributes attributes, String[] stringArray) {
        Attributes attributes2 = this.makeRecord("RT STRUCTURE SET", this.rtStructureSetKeys, attributes, stringArray);
        return attributes2;
    }

    public Attributes makeRTPlanDirectoryRecord(Attributes attributes, String[] stringArray) {
        Attributes attributes2 = this.makeRecord("RT PLAN", this.rtPlanKeys, attributes, stringArray);
        return attributes2;
    }

    public Attributes makeRTTreatmentDirectoryRecord(Attributes attributes, String[] stringArray) {
        Attributes attributes2 = this.makeRecord("RT TREAT RECORD", this.rtTreatmentRecordKeys, attributes, stringArray);
        return attributes2;
    }

    public Attributes makePresentationStateDirectoryRecord(Attributes attributes, String[] stringArray) {
        Attributes attributes2 = this.makeRecord("PRESENTATION ", this.presentationKeys, attributes, stringArray);
        return attributes2;
    }

    public Attributes makeWaveformDirectoryRecord(Attributes attributes, String[] stringArray) {
        Attributes attributes2 = this.makeRecord("WAVEFORM", this.waveformKeys, attributes, stringArray);
        return attributes2;
    }

    public Attributes makeSRDocumentDirectoryRecord(Attributes attributes, String[] stringArray) {
        Attributes attributes2 = this.makeRecord("SR DOCUMENT", this.srDocumentKeys, attributes, stringArray);
        this.copyConceptNameModifiers(attributes, attributes2);
        return attributes2;
    }

    public Attributes makeKeyObjectDirectoryRecord(Attributes attributes, String[] stringArray) {
        Attributes attributes2 = this.makeRecord("KEY OBJECT DOC", this.keyObjectDocumentKeys, attributes, stringArray);
        this.copyConceptNameModifiers(attributes, attributes2);
        return attributes2;
    }

    private void copyConceptNameModifiers(Attributes attributes, Attributes attributes2) {
        Sequence sequence = attributes.getSequence(4237104);
        if (sequence == null) {
            return;
        }
        Sequence sequence2 = null;
        int n = 0;
        int n2 = sequence.size();
        while (n < n2) {
            Attributes attributes3 = (Attributes)sequence.get(n);
            if ("HAS CONCEPT MOD".equals(attributes3.getString(4235280))) {
                if (sequence2 == null) {
                    sequence2 = attributes2.newSequence(4237104, 10);
                }
                sequence2.add(new Attributes(attributes3));
            }
            ++n;
        }
    }

    public Attributes makeSpectroscopyDirectoryRecord(Attributes attributes, String[] stringArray) {
        Attributes attributes2 = this.makeRecord("SPECTROSCOPY", this.spectroscopyKeys, attributes, stringArray);
        return attributes2;
    }

    public Attributes makeRawDataDirectoryRecord(Attributes attributes, String[] stringArray) {
        Attributes attributes2 = this.makeRecord("RAW DATA", this.rawdataKeys, attributes, stringArray);
        return attributes2;
    }

    public Attributes makeRegistrationDirectoryRecord(Attributes attributes, String[] stringArray) {
        Attributes attributes2 = this.makeRecord("REGISTRATION", this.registrationKeys, attributes, stringArray);
        return attributes2;
    }

    public Attributes makeFiducialDirectoryRecord(Attributes attributes, String[] stringArray) {
        Attributes attributes2 = this.makeRecord("FIDUCIAL", this.fiducialKeys, attributes, stringArray);
        return attributes2;
    }

    public Attributes makeHangingProtocolDirectorRecord(Attributes attributes, String[] stringArray) {
        Attributes attributes2 = this.makeRecord("HANGING PROTOCOL", this.hangingProtocolKeys, attributes, stringArray);
        return attributes2;
    }

    public Attributes makeEncapsulatedDocumentDirectorRecord(Attributes attributes, String[] stringArray) {
        Attributes attributes2 = this.makeRecord("ENCAP DOC", this.encapsulatedDocumentKeys, attributes, stringArray);
        return attributes2;
    }

    public Attributes makeHL7StructuredDocumentDirectorRecord(Attributes attributes, String[] stringArray) {
        Attributes attributes2 = this.makeRecord("HL7 STRUC DOC", this.hl7StructuredDocumentKeys, attributes, stringArray);
        return attributes2;
    }

    public Attributes makeRealWorldValueMappingDirectorRecord(Attributes attributes, String[] stringArray) {
        Attributes attributes2 = this.makeRecord("VALUE MAP", this.realWorldValueMappingKeys, attributes, stringArray);
        return attributes2;
    }
}

