/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.export;

import com.agfa.pacs.data.export.IFileIDsSource;
import com.agfa.pacs.data.export.ImageObject;
import com.agfa.pacs.data.export.Messages;
import com.agfa.pacs.data.export.internal.DefaultFileIDsSource;
import com.agfa.pacs.data.export.internal.DicomDirCreator;
import com.agfa.pacs.data.export.internal.FileSourceDataSink;
import com.agfa.pacs.data.export.internal.IDataSink;
import com.agfa.pacs.data.export.internal.ZipDataSink;
import com.agfa.pacs.data.shared.data.IDicomDataListener;
import com.agfa.pacs.data.shared.data.OutputStreamDicomDataWriter;
import com.agfa.pacs.data.shared.export.IProcessingElement;
import com.agfa.pacs.data.shared.export.ProcessingException;
import com.agfa.pacs.data.shared.export.ProcessingProperty;
import com.agfa.pacs.logging.ALogger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class DicomFileWriter
implements IProcessingElement {
    private static final ALogger log = ALogger.getLogger(DicomFileWriter.class);
    public static final String DESTINATION = "DICOM_DIRECTORY";
    public static final String FILE_NAME = "DICOM_FILE_NAME";
    public static final String ZIPPED_OUTPUT = "ZIPPED_OUTPUT";
    public static final String FLAT_STRUCTURE = "FLAT_STRUCTURE";
    public static final String ZIP_OUTPUTSTREAM = "ZIP_OUTPUTSTREAM";
    public static final String CREATE_DICOM_DIR = "CREATE_DICOM_DIR";
    public static final String INCLUDE_THUMBNAILS = "INCLUDE_THUMBNAILS";
    public static final String FILE_MAP = "DICOM_FILE_MAP";
    public static final String FILE_SUFFIX = "FILE_SUFFIX";
    private File destination;
    private boolean createDicomDir;
    private boolean addThumbnails;
    private DicomDirCreator dirCreator = null;
    private IFileIDsSource fileIDSource = null;
    private IDataSink dataTarget = null;
    private boolean zipped = false;
    private boolean flatStructure = false;
    private ZipOutputStream zippedOS = null;
    private String fileSuffix = null;

    public void finishProcessing() throws ProcessingException {
        block10: {
            if (this.zipped) {
                try {
                    ZipEntry zipEntry = new ZipEntry("DICOMDIR");
                    this.zippedOS.putNextEntry(zipEntry);
                    this.dirCreator.writeToOutputStream(this.zippedOS);
                    this.zippedOS.closeEntry();
                    this.zippedOS.close();
                }
                catch (IOException iOException) {
                    log.error("Error", (Throwable)iOException);
                }
            } else {
                try {
                    if (this.dirCreator == null) break block10;
                    this.dirCreator.finishDicomDir();
                    File file = new File(this.destination, "DICOMDIR");
                    try (FileOutputStream fileOutputStream = null;){
                        fileOutputStream = new FileOutputStream(file);
                        this.dirCreator.writeToOutputStream(fileOutputStream);
                    }
                }
                catch (IOException iOException) {
                    throw new ProcessingException("Problem with storing dicom dir", Messages.getString("export.errorWritingFiles"), (Throwable)iOException);
                }
            }
        }
    }

    public void cleanUp() {
        this.destination = null;
        this.dirCreator = null;
        this.dataTarget = null;
    }

    public String getErrorMessage() {
        return null;
    }

    public void prepareProcessing(Properties properties, List<? extends Object> list) throws ProcessingException {
        if (properties.containsKey(ZIPPED_OUTPUT)) {
            this.zipped = (Boolean)properties.get(ZIPPED_OUTPUT);
        }
        if (properties.containsKey(FLAT_STRUCTURE)) {
            this.flatStructure = (Boolean)properties.get(FLAT_STRUCTURE);
        }
        if (properties.containsKey(ZIP_OUTPUTSTREAM)) {
            this.zippedOS = (ZipOutputStream)properties.get(ZIP_OUTPUTSTREAM);
        }
        if (properties.containsKey(DESTINATION)) {
            this.destination = (File)properties.get(DESTINATION);
        }
        if (this.zipped) {
            if (this.destination == null && this.zippedOS == null) {
                throw new IllegalArgumentException("Output is not specified");
            }
            if (this.destination != null && this.destination.isDirectory()) {
                throw new ProcessingException("For Zip destination has to be a file", Messages.getString("export.errorWritingFiles"));
            }
        } else {
            if (this.destination == null) {
                throw new IllegalArgumentException("Output directory is not specified");
            }
            if (!this.destination.isDirectory()) {
                throw new IllegalArgumentException("Not a directory");
            }
        }
        if (properties.containsKey(CREATE_DICOM_DIR)) {
            this.createDicomDir = (Boolean)properties.get(CREATE_DICOM_DIR);
        }
        if (properties.containsKey(INCLUDE_THUMBNAILS)) {
            this.addThumbnails = (Boolean)properties.get(INCLUDE_THUMBNAILS);
        }
        if (this.createDicomDir) {
            try {
                this.dirCreator = new DicomDirCreator("1", this.flatStructure);
                this.fileIDSource = this.dirCreator;
            }
            catch (IOException iOException) {
                log.error("Could not create Temp file");
                throw new ProcessingException("Internal problem creating dicom dir", Messages.getString("export.errorWritingFiles"), (Throwable)iOException);
            }
        } else {
            this.fileIDSource = new DefaultFileIDsSource();
        }
        if (properties.containsKey(FILE_SUFFIX)) {
            this.fileSuffix = (String)properties.get(FILE_SUFFIX);
        }
        if (this.zipped) {
            try {
                if (this.zippedOS == null) {
                    this.zippedOS = new ZipOutputStream(new FileOutputStream(this.destination));
                }
                this.dataTarget = new ZipDataSink(this.zippedOS);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new ProcessingException("Zip output cannot be created", Messages.getString("export.errorWritingFiles"), (Throwable)fileNotFoundException);
            }
        } else {
            Hashtable<String, File> hashtable = null;
            hashtable = properties.containsKey(FILE_MAP) ? (Hashtable<String, File>)properties.get(FILE_MAP) : new Hashtable<String, File>(200);
            this.dataTarget = new FileSourceDataSink(this.destination, this.fileSuffix, hashtable);
            properties.put(FILE_MAP, hashtable);
        }
    }

    public Object process(Object object) {
        if (object instanceof ImageObject) {
            ImageObject imageObject = (ImageObject)object;
            String string = imageObject.getDataset().getString(524312);
            String[] stringArray = null;
            stringArray = imageObject.getObjectInfo() != null ? this.fileIDSource.getFileIDs(imageObject.getObjectInfo(), 0) : this.fileIDSource.getFileIDs(imageObject.getDataset(), 0);
            if (this.dirCreator != null) {
                try {
                    this.dirCreator.addToDicomDir(imageObject.getObjectInfo(), imageObject.getDataset());
                }
                catch (IOException iOException) {
                    log.warn("DicomDir Exception", (Throwable)iOException);
                }
            }
            OutputStream outputStream = this.dataTarget.getOutputStream(string, stringArray);
            OutputStreamDicomDataWriter outputStreamDicomDataWriter = new OutputStreamDicomDataWriter(outputStream, true);
            outputStreamDicomDataWriter.dicomDataAvailable(string, imageObject.getDataset(), imageObject.getFrameCount() > 0);
            int n = 0;
            while (n < imageObject.getFrameCount()) {
                outputStreamDicomDataWriter.pixelDataAvailable(string, imageObject.getFrame(n), n);
                ++n;
            }
            outputStreamDicomDataWriter.dicomDataFinished(string, IDicomDataListener.Status.Success, imageObject.getPostPixelDataset());
            this.dataTarget.closeOutputStream(string);
        }
        return object;
    }

    public ProcessingProperty[] queryProperties() {
        ProcessingProperty[] processingPropertyArray = new ProcessingProperty[]{new ProcessingProperty(DESTINATION, File.class, null), new ProcessingProperty(FILE_NAME, String.class, null), new ProcessingProperty(CREATE_DICOM_DIR, Boolean.class, null), new ProcessingProperty(INCLUDE_THUMBNAILS, Boolean.class, null)};
        return processingPropertyArray;
    }

    public boolean supportsConcurrentProcessing() {
        return true;
    }
}

