/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.export;

import com.agfa.pacs.data.export.ImageObject;
import com.agfa.pacs.data.export.ImageObjectDicomDataListener;
import com.agfa.pacs.data.export.ProcessingExceptionMessageFactory;
import com.agfa.pacs.data.shared.data.IDicomDataListener;
import com.agfa.pacs.data.shared.dicom.UIDMap;
import com.agfa.pacs.data.shared.export.IProcessingElement;
import com.agfa.pacs.data.shared.export.ProcessingException;
import com.agfa.pacs.data.shared.export.ProcessingProperty;
import com.agfa.pacs.data.shared.hw.DicomDataRequester;
import com.agfa.pacs.data.shared.hw.IDicomDataRequest;
import com.agfa.pacs.data.shared.hw.IDicomDataRequester;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.logging.ALogger;
import java.util.List;
import java.util.Properties;

public class DataInfoProcessor
implements IProcessingElement {
    private static final ALogger log = ALogger.getLogger(DataInfoProcessor.class);
    private final IDicomDataRequester ddm = DicomDataRequester.getInstance();

    public void finishProcessing() {
    }

    public void cleanUp() {
    }

    public String getErrorMessage() {
        return null;
    }

    public void prepareProcessing(Properties properties, List<? extends Object> list) {
        UIDMap uIDMap = new UIDMap();
        if (list != null) {
            for (Object object : list) {
                if (!(object instanceof IObjectInfo)) continue;
                IObjectInfo iObjectInfo = (IObjectInfo)object;
                String string = iObjectInfo.getString(131088);
                if (string != null) {
                    uIDMap.addTransferSyntaxUID(iObjectInfo.getSOPClassUID(), string);
                    continue;
                }
                uIDMap.addClassUID(iObjectInfo.getSOPClassUID());
            }
            properties.put("UID_MAP", uIDMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object process(Object object) throws ProcessingException {
        if (!(object instanceof IObjectInfo)) {
            throw new IllegalArgumentException("Wrong input type");
        }
        IObjectInfo iObjectInfo = (IObjectInfo)object;
        ImageObject imageObject = new ImageObject();
        imageObject.setObjectInfo(iObjectInfo);
        IDicomDataRequest iDicomDataRequest = this.ddm.createDicomDataRequest(iObjectInfo);
        iDicomDataRequest.setListener((IDicomDataListener)new ImageObjectDicomDataListener(imageObject));
        this.ddm.addRequest(iDicomDataRequest);
        ImageObject imageObject2 = imageObject;
        synchronized (imageObject2) {
            try {
                if (!imageObject.isFinished() && !imageObject.isFailed()) {
                    imageObject.wait();
                }
            }
            catch (InterruptedException interruptedException) {}
        }
        if (imageObject.isFailed()) {
            log.error("Error retrieving object " + iObjectInfo.getSOPInstanceUID());
            throw new ProcessingException("Error retrieving object " + iObjectInfo.getSOPInstanceUID(), ProcessingExceptionMessageFactory.getProcessingExceptionMessage("export.errorLoadingData", iObjectInfo));
        }
        return imageObject;
    }

    public ProcessingProperty[] queryProperties() {
        return null;
    }

    public boolean supportsConcurrentProcessing() {
        return true;
    }
}

